/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.component;

import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.MenuEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AdminComponentImpl
implements AdminComponent {
    private String displayName;
    private MenuEntry mainMenu;
    private List<String> notificationTemplates = new ArrayList<String>(0);
    private Map<String, Boolean> additionalCSS = new LinkedHashMap<String, Boolean>(1);
    private Map<String, Boolean> additionalJS = new LinkedHashMap<String, Boolean>(1);
    private Set<String> securityRoles = new HashSet<String>();
    private Integer position;

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public MenuEntry getMainMenu() {
        return this.mainMenu;
    }

    @Override
    public void setMainMenu(MenuEntry mainMenu) {
        mainMenu.setComponent(this);
        this.mainMenu = mainMenu;
    }

    @Override
    public List<String> getNotificationTemplates() {
        return this.notificationTemplates;
    }

    @Override
    public void setNotificationTemplates(List<String> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
    }

    @Override
    public void addNotificationTemplate(String notificationTemplate) {
        this.notificationTemplates.add(notificationTemplate);
    }

    @Override
    public Map<String, Boolean> getAdditionalCSS() {
        return this.additionalCSS;
    }

    @Override
    public void setAdditionalCSS(Map<String, Boolean> additionalCSS) {
        this.additionalCSS = additionalCSS;
    }

    @Override
    public void addAdditionalCSS(String additionalCSS, boolean relative) {
        this.additionalCSS.put(additionalCSS, relative);
    }

    @Override
    public Map<String, Boolean> getAdditionalJS() {
        return this.additionalJS;
    }

    @Override
    public void setAdditionalJS(Map<String, Boolean> additionalJS) {
        this.additionalJS = additionalJS;
    }

    @Override
    public void addAdditionalJS(String additionalJS, boolean relative) {
        this.additionalJS.put(additionalJS, relative);
    }

    @Override
    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(Set<String> securityRoles) {
        this.securityRoles = securityRoles;
    }

    @Override
    public void addSecurityRole(String securityRole) {
        this.securityRoles.add(securityRole);
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Integer position) {
        this.position = position;
    }

    @Override
    public int compareTo(AdminComponent o) {
        return this.displayName.compareTo(o.getDisplayName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.mainMenu == null ? 0 : this.mainMenu.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdminComponentImpl other = (AdminComponentImpl)obj;
        if (this.additionalCSS == null ? other.additionalCSS != null : !this.additionalCSS.equals(other.additionalCSS)) {
            return false;
        }
        if (this.additionalJS == null ? other.additionalJS != null : !this.additionalJS.equals(other.additionalJS)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.mainMenu == null ? other.mainMenu != null : !this.mainMenu.equals(other.mainMenu)) {
            return false;
        }
        if (this.notificationTemplates == null ? other.notificationTemplates != null : !this.notificationTemplates.equals(other.notificationTemplates)) {
            return false;
        }
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        return !(this.securityRoles == null ? other.securityRoles != null : !this.securityRoles.equals(other.securityRoles));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdminComponentImpl [displayName=").append(this.displayName).append(", mainMenu=").append(this.mainMenu).append(", notificationTemplates=").append(this.notificationTemplates).append(", additionalCSS=").append(this.additionalCSS).append(", additionalJS=").append(this.additionalJS).append(", securityRoles=").append(this.securityRoles).append(", position=").append(this.position).append("]");
        return builder.toString();
    }

    public static AdminComponentBuilder builder() {
        return new AdminComponentBuilder();
    }

    public static class AdminComponentBuilder {
        private AdminComponent component = new AdminComponentImpl();

        public AdminComponentBuilder displayName(String displayName) {
            this.component.setDisplayName(displayName);
            return this;
        }

        public AdminComponentBuilder mainMenu(MenuEntry mainMenu) {
            this.component.setMainMenu(mainMenu);
            return this;
        }

        public AdminComponentBuilder notificationTemplates(List<String> notificationTemplates) {
            this.component.setNotificationTemplates(notificationTemplates);
            return this;
        }

        public AdminComponentBuilder notificationTemplate(String notificationTemplate) {
            this.component.addNotificationTemplate(notificationTemplate);
            return this;
        }

        public AdminComponentBuilder additionalCSS(Map<String, Boolean> additionalCSS) {
            this.component.setAdditionalCSS(additionalCSS);
            return this;
        }

        public AdminComponentBuilder additionalCSS(String additionalCSS, boolean relative) {
            this.component.addAdditionalCSS(additionalCSS, relative);
            return this;
        }

        public AdminComponentBuilder additionalJS(Map<String, Boolean> additionalJS) {
            this.component.setAdditionalJS(additionalJS);
            return this;
        }

        public AdminComponentBuilder additionalJS(String additionalJS, boolean relative) {
            this.component.addAdditionalJS(additionalJS, relative);
            return this;
        }

        public AdminComponentBuilder securityRole(String securityRole) {
            this.component.addSecurityRole(securityRole);
            return this;
        }

        public AdminComponentBuilder position(Integer position) {
            this.component.setPosition(position);
            return this;
        }

        public AdminComponent build() {
            return this.component;
        }
    }
}

