/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core;

import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.MenuEntrySearchResult;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentComparator;
import de.chandre.admintool.core.component.MenuEntry;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="adminTool")
public class AdminToolImpl
implements AdminTool {
    private static final Log LOGGER = LogFactory.getLog(AdminToolImpl.class);
    private Set<AdminComponent> components = new TreeSet<AdminComponent>(new AdminComponentComparator());
    private Map<String, Boolean> globalJavaScripts = new LinkedHashMap<String, Boolean>();
    private Map<String, Boolean> globalStyleSheets = new LinkedHashMap<String, Boolean>();

    @Override
    public void setComponentComparator(Comparator<AdminComponent> comparator) {
        if (null == comparator) {
            this.components = new TreeSet<AdminComponent>();
        } else {
            TreeSet<AdminComponent> newComponents = new TreeSet<AdminComponent>(new AdminComponentComparator());
            newComponents.addAll(this.components);
            this.components = newComponents;
        }
    }

    @Override
    public Set<AdminComponent> getComponents() {
        return this.components;
    }

    @Override
    public void addComponent(AdminComponent components) {
        this.components.add(components);
    }

    @Override
    public void addComponents(Set<AdminComponent> components) {
        this.components.addAll(components);
    }

    public void setComponents(Set<AdminComponent> components) {
        this.components = components;
    }

    @Override
    public Map<String, Boolean> getGlobalJavaScripts() {
        return this.globalJavaScripts;
    }

    public void setGlobalJavaScripts(Map<String, Boolean> globalJavaScripts) {
        this.globalJavaScripts = globalJavaScripts;
    }

    @Override
    public void addGlobalJavaScript(String globalJavaScript, boolean local) {
        this.globalJavaScripts.put(globalJavaScript, local);
    }

    @Override
    public Map<String, Boolean> getGlobalStyleSheets() {
        return this.globalStyleSheets;
    }

    public void setGlobalStyleSheet(Map<String, Boolean> globalStyleSheets) {
        this.globalStyleSheets = globalStyleSheets;
    }

    @Override
    public void addGlobalStyleSheet(String globalStyleSheet, boolean local) {
        this.globalStyleSheets.put(globalStyleSheet, local);
    }

    @Override
    public MenuEntrySearchResult searchComponent(String menuName) {
        MenuEntrySearchResult result = null;
        LOGGER.debug((Object)("search for component for menuName: " + menuName));
        Optional<Object> menuEntry = Optional.empty();
        for (AdminComponent comp : this.getComponents()) {
            menuEntry = comp.getMainMenu().flattened().filter(entry -> null != entry.getName() && entry.getName().equals(menuName)).findFirst();
            if (!menuEntry.isPresent()) continue;
            result = new MenuEntrySearchResult(comp, (MenuEntry)menuEntry.get());
            break;
        }
        if (null == result && menuName.lastIndexOf(47) != -1) {
            result = this.searchComponent(menuName.substring(0, menuName.lastIndexOf(47)));
        }
        return result;
    }
}

