/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.utils;

import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.MenuEntry;
import de.chandre.admintool.core.utils.MenuIntegrityError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="adminToolIntegrityUtil")
public class AdminToolIntegrityUtil {
    @Autowired
    private AdminTool adminTool;

    public boolean hasMenuIntegrityErrors() {
        return !CollectionUtils.isEmpty(this.checkMenuIntegrity());
    }

    public List<MenuIntegrityError> checkMenuIntegrity() {
        ArrayList<MenuIntegrityError> errorList = new ArrayList<MenuIntegrityError>();
        HashSet links = new HashSet();
        HashSet templates = new HashSet();
        for (AdminComponent comp : this.adminTool.getComponents()) {
            comp.getMainMenu().flattened().forEach(menu -> {
                if (links.contains(menu.getName()) && CollectionUtils.isEmpty(menu.getSubmenu())) {
                    this.findErrorAndAddEntry("duplicate link name", (List<MenuIntegrityError>)errorList, (MenuEntry)menu);
                } else {
                    links.add(menu.getName());
                }
                if (templates.contains(menu.getTarget()) && CollectionUtils.isEmpty(menu.getSubmenu())) {
                    this.findErrorAndAddEntry("duplicate template reference", (List<MenuIntegrityError>)errorList, (MenuEntry)menu);
                } else {
                    templates.add(menu.getTarget());
                }
            });
        }
        links.clear();
        templates.clear();
        return errorList;
    }

    private void findErrorAndAddEntry(String clusterName, List<MenuIntegrityError> errorList, MenuEntry menuEntry) {
        Optional<MenuIntegrityError> errorRes = errorList.stream().filter(error -> error.getError().equals(clusterName)).findFirst();
        MenuIntegrityError intError = null;
        if (!errorRes.isPresent()) {
            intError = new MenuIntegrityError(clusterName);
            errorList.add(intError);
        } else {
            intError = errorRes.get();
        }
        intError.addMenuEntry(menuEntry);
    }
}

