/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.thymeleaf;

import de.chandre.admintool.core.thymeleaf.OrderedClassLoaderTemplateResolver;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.context.annotation.Configuration;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
public class ThymeleafResolverExtension {
    @Autowired
    private SpringTemplateEngine templateEngine;
    @Autowired
    private ThymeleafProperties properties;

    @PostConstruct
    public void extension() {
        OrderedClassLoaderTemplateResolver resolver = new OrderedClassLoaderTemplateResolver();
        resolver.setOrder(this.templateEngine.getTemplateResolvers().size());
        resolver.setPrefix(this.properties.getPrefix());
        resolver.setSuffix(this.properties.getSuffix());
        resolver.setTemplateMode(this.properties.getMode());
        if (this.properties.getEncoding() != null) {
            resolver.setCharacterEncoding(this.properties.getEncoding().name());
        }
        resolver.setCacheable(this.properties.isCache());
        this.templateEngine.addTemplateResolver((ITemplateResolver)resolver);
    }
}

