/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.component;

import de.chandre.admintool.core.component.AdminComponent;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;

public class MenuEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String displayName;
    private String resouceMessageKey;
    private String target;
    private boolean hide;
    private AdminComponent component;
    private MenuEntry parent;
    private List<MenuEntry> submenu = new LinkedList<MenuEntry>();
    private Set<String> securityRoles = new HashSet<String>();
    private Map<String, Object> variables = new HashMap<String, Object>();

    public MenuEntry() {
        this.hide = false;
    }

    public MenuEntry(String name, String displayName, String target) {
        this.name = name;
        this.displayName = displayName;
        this.target = target;
        this.hide = false;
    }

    public MenuEntry(String name, String displayName, String target, Set<String> securityRoles) {
        this.name = name;
        this.displayName = displayName;
        this.target = target;
        this.hide = false;
        this.securityRoles = securityRoles;
    }

    void setComponent(AdminComponent component) {
        this.component = component;
    }

    AdminComponent getComponent() {
        return this.component;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getResouceMessageKey() {
        return this.resouceMessageKey;
    }

    public void setResouceMessageKey(String resouceMessageKey) {
        this.resouceMessageKey = resouceMessageKey;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public MenuEntry getParent() {
        return this.parent;
    }

    public void setParent(MenuEntry parent) {
        this.parent = parent;
    }

    public List<MenuEntry> getSubmenu() {
        return this.submenu;
    }

    public void setSubmenu(List<MenuEntry> submenu) {
        submenu.stream().forEach(entry -> entry.setParent(this));
        this.submenu = submenu;
    }

    public void addSubmenuEntry(MenuEntry submenu) {
        submenu.setParent(this);
        this.submenu.add(submenu);
    }

    public Stream<MenuEntry> flattened() {
        return Stream.concat(Stream.of(this), this.submenu.stream().flatMap(MenuEntry::flattened));
    }

    public Stream<MenuEntry> reverseFlattened() {
        if (null == this.parent) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), Stream.of(this.parent).flatMap(MenuEntry::reverseFlattened));
    }

    public Set<String> getAffectedSecurityRoles() {
        if (CollectionUtils.isEmpty(this.securityRoles)) {
            Stream<MenuEntry> parents = this.reverseFlattened();
            Iterator entry = parents.iterator();
            while (entry.hasNext()) {
                MenuEntry menuEntry = (MenuEntry)entry.next();
                if (!CollectionUtils.isEmpty(menuEntry.getSecurityRoles())) {
                    return Collections.unmodifiableSet(menuEntry.getSecurityRoles());
                }
                if (null == menuEntry.getComponent() || null == menuEntry.getComponent().getSecurityRoles()) continue;
                return Collections.unmodifiableSet(menuEntry.getComponent().getSecurityRoles());
            }
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.securityRoles);
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(Set<String> securityRoles) {
        this.securityRoles = securityRoles;
    }

    public void addSecurityRole(String securityRole) {
        this.securityRoles.add(securityRole);
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void addVariable(String key, Object variable) {
        this.variables.put(key, variable);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MenuEntry [name=").append(this.name).append(", displayName=").append(this.displayName).append(", resouceMessageKey=").append(this.resouceMessageKey).append(", target=").append(this.target).append(", hide=").append(this.hide).append(", submenu=").append(this.submenu).append(", securityRoles=").append(this.securityRoles).append(", variables=").append(this.variables).append("]");
        return builder.toString();
    }
}

