/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.security.auth;

import de.chandre.admintool.core.security.auth.LoginAttemptService;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginAttemptServiceImpl
implements LoginAttemptService {
    private static final Log LOGGER = LogFactory.getLog(LoginAttemptServiceImpl.class);
    private final int MAX_ATTEMPT;
    private boolean useUserName = true;
    private boolean useRemoteAddress = false;
    private final Map<String, LoginAttempt> attemptsCache = new ConcurrentHashMap<String, LoginAttempt>();

    public LoginAttemptServiceImpl() {
        this(5);
    }

    public LoginAttemptServiceImpl(int maxAttempts) {
        this(maxAttempts, true, false);
    }

    public LoginAttemptServiceImpl(int maxAttempts, boolean useUserName, boolean useRemoteAddress) {
        this.MAX_ATTEMPT = maxAttempts;
        this.useUserName = useUserName;
        this.useRemoteAddress = useRemoteAddress;
        LOGGER.debug((Object)("LoginAttemptService initialized with maxAttempts=" + maxAttempts + ", using usernames=" + useUserName + ", useRemoteAddress=" + useRemoteAddress));
    }

    @Override
    public void invalidate(String userName) {
        this.attemptsCache.remove(userName);
    }

    @Override
    public void loginFailed(String userName) {
        LoginAttempt attempt = this.attemptsCache.get(userName);
        if (null == attempt && null != this.attemptsCache.putIfAbsent(userName, attempt = new LoginAttempt())) {
            attempt = this.attemptsCache.get(userName);
        }
        attempt.getActualAttempt().incrementAndGet();
        attempt.setLastAccessNow();
    }

    @Override
    public boolean isBlocked(String userName) {
        LoginAttempt attempt = this.attemptsCache.get(userName);
        if (null != attempt) {
            return attempt.getActualAttempt().get() >= this.MAX_ATTEMPT;
        }
        return false;
    }

    public LocalDateTime getLastAccess(String userName) {
        LoginAttempt attempt = this.attemptsCache.get(userName);
        if (null != attempt) {
            return attempt.getLastAccess();
        }
        return null;
    }

    @Override
    public boolean isUseUserName() {
        return this.useUserName;
    }

    public void setUseUserName(boolean useUserName) {
        this.useUserName = useUserName;
    }

    @Override
    public boolean isUseRemoteAddress() {
        return this.useRemoteAddress;
    }

    public void setUseRemoteAddress(boolean useRemoteAddress) {
        this.useRemoteAddress = useRemoteAddress;
    }

    @Override
    public void clearAttempts() {
        this.attemptsCache.clear();
    }

    private class LoginAttempt {
        private LocalDateTime lastAccess;
        private AtomicInteger actualAttempt = new AtomicInteger(0);

        private LoginAttempt() {
        }

        public LocalDateTime getLastAccess() {
            return this.lastAccess;
        }

        public void setLastAccessNow() {
            this.lastAccess = LocalDateTime.now();
        }

        public AtomicInteger getActualAttempt() {
            return this.actualAttempt;
        }
    }
}

