/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.security.auth;

import de.chandre.admintool.core.security.auth.LoginAttemptService;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class AdminToolAuthenticationSuccessListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    private LoginAttemptService loginAttemptService;

    public AdminToolAuthenticationSuccessListener(LoginAttemptService loginAttemptService) {
        this.loginAttemptService = loginAttemptService;
    }

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        if (this.loginAttemptService.isUseUserName()) {
            this.loginAttemptService.invalidate(event.getAuthentication().getName());
        }
        if (this.loginAttemptService.isUseRemoteAddress()) {
            WebAuthenticationDetails auth = (WebAuthenticationDetails)event.getAuthentication().getDetails();
            this.loginAttemptService.invalidate(auth.getRemoteAddress());
        }
    }
}

