/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.security.auth;

import de.chandre.admintool.core.security.auth.LoginAttemptService;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class AdminToolAuthenticationFailureListener
implements ApplicationListener<AuthenticationFailureBadCredentialsEvent> {
    private LoginAttemptService loginAttemptService;

    public AdminToolAuthenticationFailureListener(LoginAttemptService loginAttemptService) {
        this.loginAttemptService = loginAttemptService;
    }

    public void onApplicationEvent(AuthenticationFailureBadCredentialsEvent event) {
        if (this.loginAttemptService.isUseUserName()) {
            this.loginAttemptService.loginFailed(event.getAuthentication().getName());
        }
        if (this.loginAttemptService.isUseRemoteAddress()) {
            WebAuthenticationDetails auth = (WebAuthenticationDetails)event.getAuthentication().getDetails();
            this.loginAttemptService.loginFailed(auth.getRemoteAddress());
        }
    }
}

