/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.security.auth;

import de.chandre.admintool.core.controller.AbstractAdminController;
import de.chandre.admintool.core.security.auth.AdminToolUserDetailsService;
import de.chandre.admintool.core.security.auth.UserStateType;
import de.chandre.admintool.core.security.auth.UserTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.StringUtils;

public abstract class AbstractAdminToolSecurityViewController
extends AbstractAdminController {
    private static final String ROLE_PREFIX = "ROLE_";

    protected abstract AdminToolUserDetailsService getUserServiceDelegate();

    protected String setUserState(UserTO userTo, String type) {
        return this.setUserState(userTo, UserStateType.fromType(type));
    }

    protected static String getRolePrefix() {
        return ROLE_PREFIX;
    }

    protected String setUserState(UserTO userTo, UserStateType type) {
        switch (type) {
            case ENABLE: {
                this.getUserServiceDelegate().setUserEnabled(userTo.getUsername(), userTo.getNewState());
                break;
            }
            case EXIPRE_CREDENTIALS: {
                this.getUserServiceDelegate().setUserCredentialsExpired(userTo.getUsername(), userTo.getNewState());
                break;
            }
            case EXPIRE: {
                this.getUserServiceDelegate().setUserExpired(userTo.getUsername(), userTo.getNewState());
                break;
            }
            case LOCK: {
                this.getUserServiceDelegate().setUserLocked(userTo.getUsername(), userTo.getNewState());
                break;
            }
            default: {
                return Boolean.FALSE.toString();
            }
        }
        return Boolean.TRUE.toString();
    }

    protected Collection<GrantedAuthority> transformToSimpleAuthorities(Set<String> strAuthorities) {
        return this.transformToSimpleAuthorities(strAuthorities, false);
    }

    protected Collection<GrantedAuthority> transformToSimpleAuthorities(Set<String> strAuthorities, boolean appendRolePrefix) {
        if (null != strAuthorities) {
            HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>(strAuthorities.size());
            for (String authority : strAuthorities) {
                if (StringUtils.isEmpty((Object)authority)) continue;
                String role = authority.trim().toUpperCase(Locale.ENGLISH);
                if (appendRolePrefix) {
                    authorities.add((GrantedAuthority)new SimpleGrantedAuthority(AbstractAdminToolSecurityViewController.getRolePrefix() + role));
                    continue;
                }
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role));
            }
            return authorities;
        }
        return Collections.emptyList();
    }
}

