/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.admintool.core.security.auth;

import de.chandre.admintool.core.AbstractAdminToolLoader;
import de.chandre.admintool.core.AdminTool;
import de.chandre.admintool.core.component.AdminComponent;
import de.chandre.admintool.core.component.AdminComponentImpl;
import de.chandre.admintool.core.component.MenuEntry;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class AbstractAdminToolSecurityViewLoader
extends AbstractAdminToolLoader {
    private static final Log LOGGER = LogFactory.getLog(AbstractAdminToolSecurityViewLoader.class);
    @Autowired
    private AdminTool adminTool;
    @Value(value="${admintool.security.componentPosition:}")
    private Integer componentPosition;
    @Value(value="#{'${admintool.security.securityRoles.users:}'.split(';')}")
    private Set<String> securityRolesConfig = new HashSet<String>();
    @Value(value="${admintool.security.mustacheVersion:2.3.0}")
    private String mustacheVersion;
    private AdminComponent component = new AdminComponentImpl();

    protected void addUsersMenu() {
        LOGGER.info((Object)"adding Authentication component");
        MenuEntry mainMenu = new MenuEntry("users", "Users", "security/content/users", this.securityRolesConfig);
        mainMenu.addAdditionalJS("/static/admintool/security/users.js", true);
        mainMenu.addAdditionalJS("/static/admintool/security/validator.min.js", true);
        mainMenu.setResouceMessageKey("ui.admintool.core.security.users.displayName");
        String adminLtePrefix = this.getAdminLTEPrefixUri();
        boolean relative = !this.shouldCDNsUsed();
        this.component.addAdditionalJS(adminLtePrefix + "plugins/select2/select2.min.js", relative);
        this.component.addAdditionalCSS(adminLtePrefix + "plugins/select2/select2.min.css", relative);
        this.component.addAdditionalJS(this.getWebjarsPrefixUri() + "mustache/" + this.mustacheVersion + "/mustache.min.js", relative);
        this.component.setMainMenu(mainMenu);
        this.component.setPosition(this.componentPosition);
        this.component.getSecurityRoles().addAll(this.securityRolesConfig);
        this.component.setDisplayName("Authentication");
        this.adminTool.addComponent(this.component);
    }
}

