/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.util;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.klighd.SynthesisOption;
import de.cau.cs.kieler.klighd.krendering.SimpleUpdateStrategy;
import java.util.Map;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.elk.graph.properties.Property;

public class KlighdSynthesisProperties
extends MapPropertyHolder {
    private static final long serialVersionUID = -5635072164749313580L;
    public static final IProperty<String> REQUESTED_VIEWER_PROVIDER = new Property("klighd.viewerProvider");
    public static final IProperty<String> REQUESTED_DIAGRAM_SYNTHESIS = new Property("klighd.synthesis");
    public static final IProperty<String> REQUESTED_UPDATE_STRATEGY = new Property("klighd.updateStrategy");
    public static final IProperty<SideBarHandling> REQUESTED_SIDE_BAR_HANDLING = new Property("klighd.sideBarHandling", (Object)SideBarHandling.UNDEFINED);
    public static final IProperty<Boolean> MULTI_SELECTION = new Property("klighd.multiSelection", (Object)true);
    public static final IProperty<Boolean> INCLUDE_PORTS_IN_CONNECTED_EDGES_SELECTIONS = new Property("klighd.includePortsInConnectedEdgesSelections", (Object)false);
    public static final IProperty<Map<SynthesisOption, Object>> SYNTHESIS_OPTION_CONFIG = new Property("klighd.synthesisOptionConfig");
    public static final IProperty<ZoomConfigButtonsHandling> REQUESTED_ZOOM_CONFIG_BUTTONS_HANDLING = new Property("klighd.zoomConfigButtonsHandling", (Object)ZoomConfigButtonsHandling.UNDEFINED);
    public static final IProperty<Boolean> SUPPRESS_SIZE_ESTIMATION = new Property("klighd.suppressSizeEstimation", (Object)false);
    public static final IProperty<Boolean> SUPPRESS_EDGE_ADJUSTMENT = new Property("klighd.suppressEdgeAdjustment", (Object)false);
    private static final KlighdSynthesisProperties EMPTY_CONFIG = new KlighdSynthesisProperties(){
        private static final long serialVersionUID = 8047045626356247605L;
        private final String msg = "KLighD: Empty KlighdSynthesisProperties config must not be changed.";

        @Override
        public <T> KlighdSynthesisProperties setProperty(IProperty<? super T> property, T value) {
            throw new UnsupportedOperationException("KLighD: Empty KlighdSynthesisProperties config must not be changed.");
        }

        public MapPropertyHolder copyProperties(IPropertyHolder other) {
            throw new UnsupportedOperationException("KLighD: Empty KlighdSynthesisProperties config must not be changed.");
        }
    };

    public static KlighdSynthesisProperties emptyConfig() {
        return EMPTY_CONFIG;
    }

    public static KlighdSynthesisProperties newInstance(IPropertyHolder ... propertyHolders) {
        return KlighdSynthesisProperties.create(propertyHolders);
    }

    public static KlighdSynthesisProperties create(IPropertyHolder ... propertyHolders) {
        if (propertyHolders == null || propertyHolders.length == 0) {
            return new KlighdSynthesisProperties();
        }
        KlighdSynthesisProperties sp = new KlighdSynthesisProperties();
        IPropertyHolder[] iPropertyHolderArray = propertyHolders;
        int n = propertyHolders.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyHolder p = iPropertyHolderArray[n2];
            sp.copyProperties(p);
            ++n2;
        }
        return sp;
    }

    public <T> KlighdSynthesisProperties setProperty(IProperty<? super T> property, T value) {
        super.setProperty(property, value);
        return this;
    }

    public <T> KlighdSynthesisProperties setProperty2(IProperty<? super T> property, T value) {
        super.setProperty(property, value);
        return this;
    }

    public KlighdSynthesisProperties useDiagramSynthesis(String id) {
        this.setProperty((IProperty)REQUESTED_DIAGRAM_SYNTHESIS, id);
        return this;
    }

    public KlighdSynthesisProperties useUpdateStrategy(String id) {
        this.setProperty((IProperty)REQUESTED_UPDATE_STRATEGY, id);
        return this;
    }

    public KlighdSynthesisProperties useSimpleUpdateStrategy() {
        this.setProperty((IProperty)REQUESTED_UPDATE_STRATEGY, SimpleUpdateStrategy.ID);
        return this;
    }

    public KlighdSynthesisProperties useViewer(String id) {
        this.setProperty((IProperty)REQUESTED_VIEWER_PROVIDER, id);
        return this;
    }

    public KlighdSynthesisProperties expandSideBar() {
        this.setProperty((IProperty)REQUESTED_SIDE_BAR_HANDLING, (Object)SideBarHandling.EXPAND);
        return this;
    }

    public KlighdSynthesisProperties collapseSideBar() {
        this.setProperty((IProperty)REQUESTED_SIDE_BAR_HANDLING, (Object)SideBarHandling.COLLAPSE);
        return this;
    }

    public KlighdSynthesisProperties hideDiagramZoomConfigButtons() {
        this.setProperty((IProperty)REQUESTED_ZOOM_CONFIG_BUTTONS_HANDLING, (Object)ZoomConfigButtonsHandling.HIDE);
        return this;
    }

    public KlighdSynthesisProperties suppressMultiSelection() {
        this.setProperty((IProperty)MULTI_SELECTION, (Object)false);
        return this;
    }

    public KlighdSynthesisProperties includePortsInConnectedEdgesSelections() {
        this.setProperty((IProperty)INCLUDE_PORTS_IN_CONNECTED_EDGES_SELECTIONS, (Object)true);
        return this;
    }

    public KlighdSynthesisProperties suppressNodeAndLabelSizeEstimation() {
        this.setProperty((IProperty)SUPPRESS_SIZE_ESTIMATION, (Object)true);
        return this;
    }

    public KlighdSynthesisProperties suppressEdgeAdjustment() {
        this.setProperty((IProperty)SUPPRESS_EDGE_ADJUSTMENT, (Object)false);
        return this;
    }

    public KlighdSynthesisProperties configureSynthesisOptionValue(SynthesisOption option, Object value) {
        Map optionConfig = (Map)this.getProperty(SYNTHESIS_OPTION_CONFIG);
        if (optionConfig == null) {
            optionConfig = Maps.newHashMap();
            this.setProperty((IProperty)SYNTHESIS_OPTION_CONFIG, optionConfig);
        }
        optionConfig.put(option, value);
        return this;
    }

    public KlighdSynthesisProperties configureSynthesisOptionValues(Map<SynthesisOption, Object> options) {
        Map optionConfig = (Map)this.getProperty(SYNTHESIS_OPTION_CONFIG);
        if (optionConfig == null) {
            optionConfig = Maps.newHashMap();
            this.setProperty((IProperty)SYNTHESIS_OPTION_CONFIG, optionConfig);
        }
        optionConfig.putAll(options);
        return this;
    }

    public static enum SideBarHandling {
        EXPAND,
        COLLAPSE,
        UNDEFINED;

    }

    public static enum ZoomConfigButtonsHandling {
        SHOW,
        HIDE,
        UNDEFINED;

    }
}

