/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import de.cau.cs.kieler.klighd.internal.util.KlighdInternalProperties;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KStyle;
import de.cau.cs.kieler.klighd.util.KlighdProperties;
import de.cau.cs.kieler.klighd.util.RenderingContextData;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public final class KlighdPredicates {
    private static final Predicate<EObject> IS_SELECTABLE = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            return KlighdProperties.isSelectable(input);
        }
    };
    private static final Predicate<KStyle> IS_SELECTION = new Predicate<KStyle>(){

        public boolean apply(KStyle input) {
            return input.isSelection();
        }
    };
    private static final Predicate<KRendering> IS_COLLAPSED_RENDERING = new Predicate<KRendering>(){

        public boolean apply(KRendering rendering) {
            return (Boolean)rendering.getProperty(KlighdProperties.COLLAPSED_RENDERING);
        }
    };
    private static final Predicate<KRendering> IS_EXPANDED_RENDERING = new Predicate<KRendering>(){

        public boolean apply(KRendering rendering) {
            return (Boolean)rendering.getProperty(KlighdProperties.EXPANDED_RENDERING);
        }
    };
    private static final Predicate<KRendering> IS_COLLAPSED_OR_EXPANDED_RENDERING = Predicates.or(IS_COLLAPSED_RENDERING, IS_EXPANDED_RENDERING);
    private static final Function<Class<?>, Predicate<Object>> CLASS_TO_PREDICATE = new Function<Class<?>, Predicate<Object>>(){

        public Predicate<Object> apply(Class<?> clazz) {
            return Predicates.instanceOf(clazz);
        }
    };
    private static final Function<EClass, Predicate<EObject>> ECLASS_TO_PREDICATE = new Function<EClass, Predicate<EObject>>(){

        public Predicate<EObject> apply(final EClass clazz) {
            return new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return clazz.isInstance((Object)input);
                }
            };
        }
    };

    private KlighdPredicates() {
    }

    public static IsNotEmptyAndExpandedPredicate isNotEmptyAndExpanded() {
        return new IsNotEmptyAndExpandedPredicate();
    }

    public static <S extends IPropertyHolder, T> Predicate<S> propertyPredicate(final IProperty<T> property, final T expected, final boolean unsetEqualsTrue) {
        return new Predicate<S>(){

            public boolean apply(S properties) {
                Object value = properties.getProperty(property);
                if (value != null) {
                    return value.equals(expected);
                }
                return unsetEqualsTrue;
            }
        };
    }

    public static <S extends KGraphElement, T> Predicate<S> kgePropertyPredicate(final IProperty<T> property, final T expected, final boolean unsetEqualsTrue) {
        return new Predicate<S>(){

            public boolean apply(S node) {
                Object value = node.getProperty(property);
                if (value != null) {
                    return value.equals(expected);
                }
                return unsetEqualsTrue;
            }
        };
    }

    public static Predicate<EObject> isSelectable() {
        return IS_SELECTABLE;
    }

    public static Predicate<KStyle> isSelection() {
        return IS_SELECTION;
    }

    public static Predicate<KRendering> isCollapsedRendering() {
        return IS_COLLAPSED_RENDERING;
    }

    public static Predicate<KRendering> isExpandedRendering() {
        return IS_EXPANDED_RENDERING;
    }

    public static Predicate<KRendering> isCollapsedOrExpandedRendering() {
        return IS_COLLAPSED_OR_EXPANDED_RENDERING;
    }

    public static <T> Predicate<T> notIn(Collection<? extends T> target) {
        return Predicates.not((Predicate)Predicates.in(target));
    }

    public static Predicate<Object> notInstanceOf(Class<?> clazz) {
        return Predicates.not((Predicate)Predicates.instanceOf(clazz));
    }

    public static Predicate<Object> instanceOf(Class<?> ... classes) {
        return Predicates.or((Iterable)Iterables.transform(Arrays.asList(classes), CLASS_TO_PREDICATE));
    }

    public static Predicate<Object> instanceOf(Iterable<Class<?>> classes) {
        return Predicates.or((Iterable)Iterables.transform(classes, CLASS_TO_PREDICATE));
    }

    public static Predicate<EObject> eInstanceOf(EClass ... classes) {
        return Predicates.or((Iterable)Iterables.transform(Arrays.asList(classes), ECLASS_TO_PREDICATE));
    }

    public static Predicate<EObject> eInstanceOf(Iterable<EClass> classes) {
        return Predicates.or((Iterable)Iterables.transform(classes, ECLASS_TO_PREDICATE));
    }

    public static class IsNotEmptyAndExpandedPredicate
    implements Predicate<KNode> {
        public boolean apply(KNode node) {
            return !node.getChildren().isEmpty() && (Boolean)RenderingContextData.get((KGraphElement)node).getProperty(KlighdInternalProperties.POPULATED) != false;
        }
    }
}

