/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.util;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.klighd.kgraph.KEdge;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KPort;
import de.cau.cs.kieler.klighd.krendering.KBackground;
import de.cau.cs.kieler.klighd.krendering.KColor;
import de.cau.cs.kieler.klighd.krendering.KForeground;
import de.cau.cs.kieler.klighd.krendering.KLineStyle;
import de.cau.cs.kieler.klighd.krendering.KLineWidth;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingFactory;
import de.cau.cs.kieler.klighd.krendering.KStyle;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Color;

public class KlighdHighlightingHelper {
    private KRenderingFactory factory = KRenderingFactory.eINSTANCE;
    private KGraphElement targetNode;
    private List<KStyle> styles = new LinkedList<KStyle>();
    private Color foregroundColor = null;
    private Color backgroundColor = null;
    private float lineWidth = 0.0f;
    private KLineStyle lineStyle = null;
    private Color labelBackgroundColor = null;
    private Color labelForegroundColor = null;
    private Color portForegroundColor = null;
    private Color portBackgroundColor = null;

    public KlighdHighlightingHelper(KGraphElement target, Color color, Color background) {
        this.targetNode = target;
        this.foregroundColor = color;
        this.backgroundColor = background;
    }

    public KlighdHighlightingHelper(KGraphElement target, Color color, Color background, float lineWidth) {
        this(target, color, background);
        this.lineWidth = lineWidth;
    }

    public KlighdHighlightingHelper(KGraphElement target, Color color, Color background, KLineStyle lineStyle) {
        this(target, color, background);
        this.lineStyle = lineStyle;
    }

    public KlighdHighlightingHelper(KGraphElement target, Color color, Color background, float lineWidth, KLineStyle lineStyle) {
        this(target, color, background);
        this.lineWidth = lineWidth;
        this.lineStyle = lineStyle;
    }

    public KlighdHighlightingHelper(KGraphElement target, Color color, Color background, float lineWidth, KLineStyle lineStyle, Color labelForegroundColor, Color labelBackgroundColor) {
        this(target, color, background, lineWidth, lineStyle);
        this.labelBackgroundColor = labelBackgroundColor;
        this.labelForegroundColor = labelForegroundColor;
    }

    public KlighdHighlightingHelper(KEdge target, Color color, Color background, float lineWidth, KLineStyle lineStyle, Color labelForegroundColor, Color labelBackgroundColor, Color portForegroundColor, Color portBackgroundColor) {
        this((KGraphElement)target, color, background, lineWidth, lineStyle, labelForegroundColor, labelBackgroundColor);
        this.portBackgroundColor = portBackgroundColor;
        this.portForegroundColor = portForegroundColor;
    }

    protected Iterable<KRendering> getKRenderingsToBeHightlighted() {
        return Iterables.filter((Iterable)this.targetNode.getData(), KRendering.class);
    }

    public void execute() {
        for (KRendering rendering : this.getKRenderingsToBeHightlighted()) {
            KForeground pfg;
            KRendering portRendering;
            if (this.foregroundColor != null) {
                KForeground fg = this.getKForeground(this.foregroundColor);
                rendering.getStyles().add((Object)fg);
                this.styles.add((KStyle)fg);
            }
            if (this.lineStyle != null) {
                rendering.getStyles().add((Object)this.lineStyle);
                this.styles.add((KStyle)this.lineStyle);
            }
            if (this.backgroundColor != null) {
                KBackground bg = this.getKBackground(this.backgroundColor);
                rendering.getStyles().add((Object)bg);
                this.styles.add((KStyle)bg);
            }
            if (this.lineWidth != 0.0f) {
                KLineWidth lw = this.getLineWidth(this.lineWidth);
                rendering.getStyles().add((Object)lw);
                this.styles.add((KStyle)lw);
            }
            if (this.targetNode instanceof KLabeledGraphElement) {
                for (KLabel l : ((KLabeledGraphElement)this.targetNode).getLabels()) {
                    KRendering labelRendering = (KRendering)l.getData(KRendering.class);
                    if (this.labelForegroundColor != null) {
                        KForeground lfg = this.getKForeground(this.labelForegroundColor);
                        labelRendering.getStyles().add((Object)lfg);
                        this.styles.add((KStyle)lfg);
                    }
                    if (this.labelBackgroundColor == null) continue;
                    KBackground lbg = this.getKBackground(this.labelBackgroundColor);
                    labelRendering.getStyles().add((Object)lbg);
                    this.styles.add((KStyle)lbg);
                }
            }
            if (!(this.targetNode instanceof KEdge)) continue;
            KPort sourcePort = ((KEdge)this.targetNode).getSourcePort();
            KPort targetPort = ((KEdge)this.targetNode).getTargetPort();
            if (this.portForegroundColor != null) {
                if (sourcePort != null) {
                    portRendering = (KRendering)sourcePort.getData(KRendering.class);
                    pfg = this.getKForeground(this.portForegroundColor);
                    portRendering.getStyles().add((Object)pfg);
                    this.styles.add((KStyle)pfg);
                }
                if (targetPort != null) {
                    portRendering = (KRendering)targetPort.getData(KRendering.class);
                    pfg = this.getKForeground(this.portForegroundColor);
                    portRendering.getStyles().add((Object)pfg);
                    this.styles.add((KStyle)pfg);
                }
            }
            if (this.portBackgroundColor == null) continue;
            if (sourcePort != null) {
                portRendering = (KRendering)sourcePort.getData(KRendering.class);
                pfg = this.getKBackground(this.portBackgroundColor);
                portRendering.getStyles().add((Object)pfg);
                this.styles.add((KStyle)pfg);
            }
            if (targetPort == null) continue;
            portRendering = (KRendering)targetPort.getData(KRendering.class);
            pfg = this.getKBackground(this.portBackgroundColor);
            portRendering.getStyles().add((Object)pfg);
            this.styles.add((KStyle)pfg);
        }
    }

    public void undo() {
        for (KStyle s : this.styles) {
            KRendering rendering = (KRendering)s.eContainer();
            rendering.getStyles().remove((Object)s);
        }
        this.styles.clear();
    }

    private KLineWidth getLineWidth(float width) {
        KLineWidth lw = this.factory.createKLineWidth();
        lw.setLineWidth(width);
        return lw;
    }

    private KForeground getKForeground(Color color) {
        KForeground fg = this.factory.createKForeground();
        fg.setColor(this.kcolorFromSwtcolor(color));
        return fg;
    }

    private KBackground getKBackground(Color color) {
        KBackground bg = this.factory.createKBackground();
        bg.setColor(this.kcolorFromSwtcolor(color));
        return bg;
    }

    private KColor kcolorFromSwtcolor(Color color) {
        KColor c = this.factory.createKColor();
        c.setBlue(color.getBlue());
        c.setGreen(color.getGreen());
        c.setRed(color.getRed());
        return c;
    }
}

