/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.eclipse.elk.core.util.Pair;

public final class Iterables2 {
    private Iterables2() {
    }

    public static <T> Iterable<T> toIterable(final Iterator<T> iterator) {
        return new Iterable<T>(){
            private boolean exhausted = false;

            @Override
            public Iterator<T> iterator() {
                if (this.exhausted) {
                    throw new IllegalStateException("The wrapped Iterator has been accessed already, it is forbidden to request it more than once for this Iterable!");
                }
                this.exhausted = true;
                return iterator;
            }
        };
    }

    public static <T> Iterable<T> singletonIterable(T value) {
        return Iterables2.singletonList(value);
    }

    public static <T> List<T> singletonList(T value) {
        return value != null ? ImmutableList.of(value) : ImmutableList.of();
    }

    public static <T> Iterable<T> skipLast(final Iterable<T> iterable, final int count) {
        if (iterable == null) {
            throw new NullPointerException("The provided 'iterable' is 'null'!");
        }
        if (count == 0) {
            return iterable;
        }
        if (count < 0) {
            throw new IllegalArgumentException("Cannot drop a negative number of elements. Argument 'count' was: " + count);
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new SkipLastIterator(iterable, count);
            }
        };
    }

    public static <T> Iterator<T> skipLast(Iterator<T> iterator, int count) {
        if (iterator == null) {
            throw new NullPointerException("The provided 'iterator' is 'null'!");
        }
        if (count == 0) {
            return iterator;
        }
        if (count < 0) {
            throw new IllegalArgumentException("Cannot drop a negative number of elements. Argument 'count' was: " + count);
        }
        return new SkipLastIterator<T>(iterator, count);
    }

    public static <E, R> R fold(Iterable<E> iterable, Function<Pair<R, E>, R> function) {
        Pair pair = new Pair();
        Object result = null;
        for (E element : iterable) {
            pair.setFirst(result);
            pair.setSecond(element);
            result = function.apply((Object)pair);
        }
        return (R)result;
    }

    private static class SkipLastIterator<T>
    implements Iterator<T> {
        private final Iterable<T> src;
        private final int count;
        private Iterator<T> srcIterator = null;
        private Queue<T> queue = null;

        SkipLastIterator(Iterable<T> src, int count) {
            this.src = (Iterable)Preconditions.checkNotNull(src);
            this.count = count;
        }

        SkipLastIterator(Iterator<T> src, int count) {
            this.src = null;
            this.srcIterator = (Iterator)Preconditions.checkNotNull(src);
            this.count = count;
        }

        private boolean initialize() {
            if (this.srcIterator == null) {
                this.srcIterator = this.src.iterator();
            }
            this.queue = Lists.newLinkedList();
            int i = this.count;
            while (i-- != 0) {
                if (this.srcIterator.hasNext()) {
                    this.queue.add(this.srcIterator.next());
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            if (this.queue == null && !this.initialize()) {
                return false;
            }
            return this.srcIterator.hasNext();
        }

        @Override
        public T next() {
            if (this.srcIterator.hasNext()) {
                this.queue.add(this.srcIterator.next());
                return this.queue.poll();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return Iterators.toString((Iterator)this);
        }
    }
}

