/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.util.IDataObject;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.elk.graph.properties.Property;

public final class ExpansionAwareLayoutOption {
    public static final IProperty<ExpansionAwareLayoutOptionData> OPTION = new Property("de.cau.cs.kieler.klighd.expansionAwareLayoutOption");

    private ExpansionAwareLayoutOption() {
    }

    public static <T> void setProperty(IPropertyHolder holder, IProperty<T> property, T collapsedValue, T expandedValue) {
        ExpansionAwareLayoutOptionData data = (ExpansionAwareLayoutOptionData)holder.getProperty(OPTION);
        if (data == null) {
            data = new ExpansionAwareLayoutOptionData();
            holder.setProperty(OPTION, (Object)data);
        }
        data.setProperty(property, collapsedValue, expandedValue);
    }

    public static class ExpansionAwareLayoutOptionData
    implements IDataObject {
        private static final long serialVersionUID = 8851060475752240313L;
        private MapPropertyHolder collapsedValues;
        private MapPropertyHolder expandedValues;

        public ExpansionAwareLayoutOptionData() {
            this.collapsedValues = new MapPropertyHolder();
            this.expandedValues = new MapPropertyHolder();
        }

        public ExpansionAwareLayoutOptionData(ExpansionAwareLayoutOptionData original) {
            this.collapsedValues = new MapPropertyHolder().copyProperties((IPropertyHolder)original.collapsedValues);
            this.expandedValues = new MapPropertyHolder().copyProperties((IPropertyHolder)original.expandedValues);
        }

        public <T> ExpansionAwareLayoutOptionData setProperty(IProperty<T> property, T collapsedValue, T expandedValue) {
            this.collapsedValues.setProperty(property, collapsedValue);
            this.expandedValues.setProperty(property, expandedValue);
            return this;
        }

        public <T> T getValue(IProperty<T> property, boolean expanded) {
            Object res = expanded ? this.expandedValues.getAllProperties().get(property) : this.collapsedValues.getAllProperties().get(property);
            return (T)res;
        }

        public IPropertyHolder getValues(boolean expanded) {
            return expanded ? this.expandedValues : this.collapsedValues;
        }

        public void parse(String string) {
            Iterator<String> definitions = Arrays.asList(string.trim().split("\\(\\(|;;|\\)\\)")).iterator();
            while (definitions.hasNext()) {
                MapPropertyHolder holder;
                String next = definitions.next().trim();
                if (next.startsWith("collapsed:")) {
                    holder = this.collapsedValues;
                } else {
                    if (!next.startsWith("expanded:")) continue;
                    holder = this.expandedValues;
                }
                Iterator<String> keyVals = Arrays.asList(next.substring(next.indexOf(58) + 1).split(",,|=")).iterator();
                while (keyVals.hasNext()) {
                    String key = keyVals.next().trim();
                    if (!keyVals.hasNext()) continue;
                    String value = keyVals.next().trim();
                    ExpansionAwareLayoutOptionData.setOption((IPropertyHolder)holder, key, value);
                }
            }
        }

        public String toString() {
            String collapsed = "collapsed: " + this.toString((IPropertyHolder)this.collapsedValues);
            String expanded = "expanded: " + this.toString((IPropertyHolder)this.expandedValues);
            return "((" + collapsed + ";; " + expanded + "))";
        }

        private String toString(IPropertyHolder properties) {
            String result = new String();
            for (Map.Entry p : properties.getAllProperties().entrySet()) {
                result = String.valueOf(result) + ((IProperty)p.getKey()).getId() + " = " + p.getValue().toString() + ",, ";
            }
            return result.replaceFirst(",, $", "");
        }

        private static void setOption(IPropertyHolder holder, String id, String value) {
            Object obj;
            LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(id);
            if (optionData != null && (obj = optionData.parseValue(value)) != null) {
                holder.setProperty((IProperty)optionData, obj);
            }
        }
    }
}

