/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.syntheses;

import com.google.common.base.Strings;
import de.cau.cs.kieler.klighd.KlighdPlugin;
import de.cau.cs.kieler.klighd.syntheses.AbstractDiagramSynthesis;
import de.cau.cs.kieler.klighd.syntheses.ReinitializingDiagramSynthesisProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.elk.core.util.WrappedException;
import org.osgi.framework.Bundle;

public class GuiceBasedSynthesisFactory
implements IExecutableExtension,
IExecutableExtensionFactory {
    public static final String CLASS_NAME = GuiceBasedSynthesisFactory.class.getCanonicalName();
    private String contributingBundleId;
    private String contributingBundleName;
    private String transformationClassName;

    public static <S> ReinitializingDiagramSynthesisProxy<S> getReinitializingDiagramSynthesisProxy(Class<? extends AbstractDiagramSynthesis<S>> clazz) {
        return new ReinitializingDiagramSynthesisProxy(clazz);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (propertyName.equals("class") && data instanceof String) {
            String string = (String)data;
            int index = string.indexOf(47);
            if (index == -1) {
                this.contributingBundleId = ((RegistryContributor)config.getContributor()).getId();
                this.transformationClassName = string;
            } else {
                this.contributingBundleName = string.substring(0, index).trim();
                this.transformationClassName = string.substring(index + 1).trim();
            }
        }
    }

    public Object create() throws CoreException {
        try {
            Class clazz;
            if (Strings.isNullOrEmpty((String)this.contributingBundleName)) {
                Bundle contributingBundle = KlighdPlugin.getDefault().getBundle().getBundleContext().getBundle(Long.parseLong(this.contributingBundleId));
                clazz = contributingBundle.loadClass(this.transformationClassName);
            } else {
                clazz = Platform.getBundle((String)this.contributingBundleName).loadClass(this.transformationClassName);
            }
            ReinitializingDiagramSynthesisProxy proxy = new ReinitializingDiagramSynthesisProxy(clazz);
            return proxy;
        }
        catch (ClassNotFoundException e) {
            throw new WrappedException("KLighD: Registered diagram synthesis class could not be loaded properly via the " + GuiceBasedSynthesisFactory.class.getSimpleName() + ". Did you miss to provide the related bundle id in the extension (plugin.xml)?", (Throwable)e);
        }
    }
}

