/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.labels.management;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.klighd.labels.management.AbstractKlighdLabelManager;
import de.cau.cs.kieler.klighd.labels.management.LabelManagementUtil;
import de.cau.cs.kieler.klighd.microlayout.Bounds;
import de.cau.cs.kieler.klighd.microlayout.PlacementUtil;
import java.util.ArrayList;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.swt.graphics.FontData;

public class TruncatingLabelManager
extends AbstractKlighdLabelManager {
    private static final String ELLIPSES = "...";
    private TruncationMode truncationMode = TruncationMode.TARGET_WIDTH;
    private boolean appendEllipsis = true;
    private int wordsToSurvive = 1;

    public TruncatingLabelManager truncateAfterFirstLine() {
        this.truncationMode = TruncationMode.FIRST_LINE;
        return this;
    }

    public TruncatingLabelManager truncateAfterFirstWords(int words) {
        if (words <= 0) {
            throw new IllegalArgumentException("words must be > 0.");
        }
        this.truncationMode = TruncationMode.FIRST_WORDS;
        this.wordsToSurvive = words;
        return this;
    }

    public TruncatingLabelManager truncateAfterTargetWidth() {
        this.truncationMode = TruncationMode.TARGET_WIDTH;
        return this;
    }

    public TruncatingLabelManager appendEllipsisToTruncatedText(boolean ellipsis) {
        this.appendEllipsis = ellipsis;
        return this;
    }

    public TruncationMode getTruncationMode() {
        return this.truncationMode;
    }

    @Override
    public AbstractKlighdLabelManager.Result doResizeLabel(ElkLabel label, double targetWidth) {
        if (!this.doWeActuallyHaveToGoAndDoStuff(label, targetWidth)) {
            return AbstractKlighdLabelManager.Result.unmodified();
        }
        switch (this.truncationMode) {
            case FIRST_LINE: {
                return this.firstLine(label, targetWidth);
            }
            case FIRST_WORDS: {
                return this.firstWords(label, targetWidth);
            }
            case TARGET_WIDTH: {
                return this.targetWidth(label, targetWidth);
            }
        }
        assert (false);
        return AbstractKlighdLabelManager.Result.unmodified();
    }

    private AbstractKlighdLabelManager.Result firstLine(ElkLabel label, double targetWidth) {
        int lineBreakIndex = label.getText().indexOf(10);
        if (lineBreakIndex == -1) {
            return AbstractKlighdLabelManager.Result.unmodified();
        }
        String newText = label.getText().substring(0, lineBreakIndex);
        return this.ellipsifyIfRequired(newText);
    }

    private AbstractKlighdLabelManager.Result firstWords(ElkLabel label, double targetWidth) {
        ArrayList components = Lists.newArrayList((Object[])label.getText().split("[\\h\\v]+", this.wordsToSurvive + 1));
        if (components.size() > this.wordsToSurvive) {
            components.remove(this.wordsToSurvive);
        }
        return this.ellipsifyIfRequired(String.join((CharSequence)" ", components));
    }

    private AbstractKlighdLabelManager.Result targetWidth(ElkLabel label, double targetWidth) {
        float ellipseWidth;
        FontData labelFontData = LabelManagementUtil.fontDataFor(label);
        String calculatedText = "";
        float f = ellipseWidth = this.appendEllipsis ? PlacementUtil.estimateTextSize(labelFontData, ELLIPSES).getWidth() : 0.0f;
        if (targetWidth > (double)ellipseWidth) {
            calculatedText = LabelManagementUtil.findFittingString(label.getText(), LabelManagementUtil.fontDataFor(label), targetWidth - (double)ellipseWidth);
            calculatedText = calculatedText.trim();
        }
        return this.ellipsifyIfRequired(calculatedText);
    }

    private boolean doWeActuallyHaveToGoAndDoStuff(ElkLabel label, double targetWidth) {
        if (this.getMode() == AbstractKlighdLabelManager.Mode.ALWAYS_ON && this.truncationMode != TruncationMode.TARGET_WIDTH) {
            return true;
        }
        Bounds textBounds = PlacementUtil.estimateTextSize(LabelManagementUtil.fontDataFor(label), label.getText());
        return (double)textBounds.getWidth() > targetWidth;
    }

    private AbstractKlighdLabelManager.Result ellipsifyIfRequired(String text) {
        if (this.appendEllipsis) {
            return AbstractKlighdLabelManager.Result.modified(String.valueOf(text) + ELLIPSES);
        }
        return AbstractKlighdLabelManager.Result.modified(text);
    }

    public static enum TruncationMode {
        FIRST_LINE,
        FIRST_WORDS,
        TARGET_WIDTH;

    }
}

