/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.labels.management;

import de.cau.cs.kieler.klighd.labels.management.AbstractKlighdLabelManager;
import de.cau.cs.kieler.klighd.labels.management.LabelManagementUtil;
import de.cau.cs.kieler.klighd.microlayout.PlacementUtil;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.swt.graphics.FontData;

public class SoftWrappingLabelManager
extends AbstractKlighdLabelManager {
    @Override
    public AbstractKlighdLabelManager.Result doResizeLabel(ElkLabel label, double targetWidth) {
        FontData font = LabelManagementUtil.fontDataFor(label);
        if ((double)PlacementUtil.estimateTextSize(font, label.getText()).getWidth() > targetWidth) {
            String textWithoutLineBreaks = label.getText().replace("\n", " ");
            String[] words = textWithoutLineBreaks.split(" ");
            StringBuilder resultText = new StringBuilder(label.getText().length());
            double effectiveTargetWidth = Math.max((double)LabelManagementUtil.getWidthOfBiggestWord(font, words), targetWidth);
            int currWordIndex = 0;
            while (currWordIndex < words.length) {
                String currentLineText;
                String testText = currentLineText = words[currWordIndex];
                double lineWidth = 0.0;
                do {
                    currentLineText = testText;
                    if (currWordIndex < words.length - 1) {
                        testText = String.valueOf(currentLineText) + " " + words[++currWordIndex];
                        continue;
                    }
                    testText = " ";
                    ++currWordIndex;
                } while ((lineWidth = (double)PlacementUtil.estimateTextSize(font, testText).getWidth()) < effectiveTargetWidth && currWordIndex < words.length);
                if (currWordIndex < words.length) {
                    resultText.append(currentLineText).append("\n");
                    continue;
                }
                resultText.append(currentLineText);
                break;
            }
            return AbstractKlighdLabelManager.Result.modified(resultText.toString());
        }
        return AbstractKlighdLabelManager.Result.unmodified();
    }
}

