/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.labels.decoration;

import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.krendering.KBackground;
import de.cau.cs.kieler.klighd.krendering.KContainerRendering;
import de.cau.cs.kieler.klighd.krendering.KForeground;
import de.cau.cs.kieler.klighd.krendering.KRectangle;
import de.cau.cs.kieler.klighd.labels.decoration.AbstractDecoratorRenderingProvider;
import de.cau.cs.kieler.klighd.labels.decoration.LabelDecorationConfigurator;
import org.eclipse.elk.core.math.ElkPadding;

public final class RectangleDecorator
extends AbstractDecoratorRenderingProvider {
    private Color backgroundColor = new Color();
    private Color borderColor = null;

    private RectangleDecorator() {
    }

    public static RectangleDecorator create() {
        return new RectangleDecorator();
    }

    public RectangleDecorator withBackground(int r, int g, int b, int a) {
        this.backgroundColor.r = r;
        this.backgroundColor.g = g;
        this.backgroundColor.b = b;
        this.backgroundColor.a = a;
        return this;
    }

    public RectangleDecorator withBackground(java.awt.Color color) {
        this.backgroundColor.r = color.getRed();
        this.backgroundColor.g = color.getGreen();
        this.backgroundColor.b = color.getBlue();
        this.backgroundColor.a = color.getAlpha();
        return this;
    }

    public RectangleDecorator withBorder(int r, int g, int b, int a) {
        if (this.borderColor == null) {
            this.borderColor = new Color();
        }
        this.borderColor.r = r;
        this.borderColor.g = g;
        this.borderColor.b = b;
        this.borderColor.a = a;
        return this;
    }

    public RectangleDecorator withBorder(java.awt.Color color) {
        if (this.borderColor == null) {
            this.borderColor = new Color();
        }
        this.borderColor.r = color.getRed();
        this.borderColor.g = color.getGreen();
        this.borderColor.b = color.getBlue();
        this.borderColor.a = color.getAlpha();
        return this;
    }

    @Override
    public ElkPadding createDecoratorRendering(KContainerRendering container, KLabel label, LabelDecorationConfigurator.LayoutMode layoutMode) {
        KRectangle rectangle = R_FACTORY.createKRectangle();
        container.getChildren().add((Object)rectangle);
        KBackground background = R_FACTORY.createKBackground();
        rectangle.getStyles().add((Object)background);
        background.setColor(this.backgroundColor.r, this.backgroundColor.g, this.backgroundColor.b, this.backgroundColor.a);
        KForeground border = R_FACTORY.createKForeground();
        rectangle.getStyles().add((Object)border);
        if (this.borderColor != null) {
            border.setColor(this.borderColor.r, this.borderColor.g, this.borderColor.b, this.borderColor.a);
        } else {
            border.setColor(0, 0, 0, 0);
        }
        ElkPadding padding = new ElkPadding();
        if (this.borderColor != null) {
            padding.set(2.0, 2.0, 3.0, 2.0);
        } else {
            boolean horizontalPadding = layoutMode != LabelDecorationConfigurator.LayoutMode.VERTICAL;
            boolean verticalPadding = layoutMode != LabelDecorationConfigurator.LayoutMode.HORIZONTAL;
            padding.set((double)(verticalPadding ? 2 : 0), (double)(horizontalPadding ? 2 : 0), (double)(verticalPadding ? 3 : 0), (double)(horizontalPadding ? 2 : 0));
        }
        return padding;
    }

    private static class Color {
        private int r = 255;
        private int g = 255;
        private int b = 255;
        private int a = 220;

        private Color() {
        }
    }
}

