/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.labels.decoration;

import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.krendering.KContainerRendering;
import de.cau.cs.kieler.klighd.krendering.KForeground;
import de.cau.cs.kieler.klighd.krendering.KPolyline;
import de.cau.cs.kieler.klighd.krendering.KPosition;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KXPosition;
import de.cau.cs.kieler.klighd.krendering.KYPosition;
import de.cau.cs.kieler.klighd.labels.decoration.AbstractDecoratorRenderingProvider;
import de.cau.cs.kieler.klighd.labels.decoration.EdgeLabelStyleModifier;
import de.cau.cs.kieler.klighd.labels.decoration.LabelDecorationConfigurator;
import org.eclipse.elk.core.math.ElkPadding;

public final class LinesDecorator
extends AbstractDecoratorRenderingProvider {
    private Color lineColor = new Color();
    private boolean drawBrackets = false;

    private LinesDecorator() {
    }

    public static LinesDecorator create() {
        return new LinesDecorator();
    }

    public LinesDecorator withColor(int r, int g, int b, int a) {
        this.lineColor.r = r;
        this.lineColor.g = g;
        this.lineColor.b = b;
        this.lineColor.a = a;
        return this;
    }

    public LinesDecorator withColor(java.awt.Color color) {
        this.lineColor.r = color.getRed();
        this.lineColor.g = color.getGreen();
        this.lineColor.b = color.getBlue();
        this.lineColor.a = color.getAlpha();
        return this;
    }

    public LinesDecorator withBrackets(boolean brackets) {
        this.drawBrackets = brackets;
        return this;
    }

    @Override
    public ElkPadding createDecoratorRendering(KContainerRendering container, KLabel label, LabelDecorationConfigurator.LayoutMode layoutMode) {
        boolean topBottom = layoutMode != LabelDecorationConfigurator.LayoutMode.HORIZONTAL;
        boolean leftRight = layoutMode != LabelDecorationConfigurator.LayoutMode.VERTICAL;
        ElkPadding padding = new ElkPadding();
        if (topBottom) {
            padding.top = 2.0;
            padding.bottom = 3.0;
            KRendering topLine = this.createTopLine();
            container.getChildren().add((Object)topLine);
            KRendering bottomLine = this.createBottomLine();
            container.getChildren().add((Object)bottomLine);
            if (layoutMode == LabelDecorationConfigurator.LayoutMode.BOTH) {
                EdgeLabelStyleModifier.install(topLine, EdgeLabelStyleModifier.Visibility.SEGMENT_VERTICAL);
                EdgeLabelStyleModifier.install(bottomLine, EdgeLabelStyleModifier.Visibility.SEGMENT_VERTICAL);
            }
        }
        if (leftRight) {
            padding.left = 2.0;
            padding.right = 2.0;
            padding.bottom = Math.max(padding.bottom, 1.0);
            KRendering leftLine = this.createLeftLine();
            container.getChildren().add((Object)leftLine);
            KRendering rightLine = this.createRightLine();
            container.getChildren().add((Object)rightLine);
            if (layoutMode == LabelDecorationConfigurator.LayoutMode.BOTH) {
                EdgeLabelStyleModifier.install(leftLine, EdgeLabelStyleModifier.Visibility.SEGMENT_HORIZONTAL);
                EdgeLabelStyleModifier.install(rightLine, EdgeLabelStyleModifier.Visibility.SEGMENT_HORIZONTAL);
            }
        }
        return padding;
    }

    private KRendering createLeftLine() {
        KPolyline line = this.createInitializedPolyline();
        if (this.drawBrackets) {
            this.addPoint(line, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f));
        }
        this.addPoint(line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f));
        this.addPoint(line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        if (this.drawBrackets) {
            this.addPoint(line, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        }
        this.setPlacement((KRendering)line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f), (KXPosition<?>)this.left(3.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        return line;
    }

    private KRendering createRightLine() {
        KPolyline line = this.createInitializedPolyline();
        if (this.drawBrackets) {
            this.addPoint(line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f));
        }
        this.addPoint(line, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f));
        this.addPoint(line, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        if (this.drawBrackets) {
            this.addPoint(line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        }
        this.setPlacement((KRendering)line, (KXPosition<?>)this.right(3.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f), (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        return line;
    }

    private KRendering createTopLine() {
        KPolyline line = this.createInitializedPolyline();
        if (this.drawBrackets) {
            this.addPoint(line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        }
        this.addPoint(line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f));
        this.addPoint(line, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f));
        if (this.drawBrackets) {
            this.addPoint(line, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        }
        this.setPlacement((KRendering)line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f), (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(3.0f, 0.0f));
        return line;
    }

    private KRendering createBottomLine() {
        KPolyline line = this.createInitializedPolyline();
        if (this.drawBrackets) {
            this.addPoint(line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f));
        }
        this.addPoint(line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        this.addPoint(line, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        if (this.drawBrackets) {
            this.addPoint(line, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f));
        }
        this.setPlacement((KRendering)line, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.bottom(3.0f, 0.0f), (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        return line;
    }

    private KPolyline createInitializedPolyline() {
        KPolyline line = R_FACTORY.createKPolyline();
        KForeground fg = R_FACTORY.createKForeground();
        line.getStyles().add((Object)fg);
        fg.setColor(this.lineColor.r, this.lineColor.g, this.lineColor.b, this.lineColor.a);
        return line;
    }

    private void addPoint(KPolyline line, KXPosition<?> xPos, KYPosition<?> yPos) {
        KPosition pos = R_FACTORY.createKPosition();
        pos.setX(xPos);
        pos.setY(yPos);
        line.getPoints().add((Object)pos);
    }

    private static class Color {
        private int r = 0;
        private int g = 0;
        private int b = 0;
        private int a = 255;

        private Color() {
        }
    }
}

