/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.labels.decoration;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.klighd.kgraph.KEdge;
import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.krendering.KAreaPlacementData;
import de.cau.cs.kieler.klighd.krendering.KBottomPosition;
import de.cau.cs.kieler.klighd.krendering.KContainerRendering;
import de.cau.cs.kieler.klighd.krendering.KInvisibility;
import de.cau.cs.kieler.klighd.krendering.KLeftPosition;
import de.cau.cs.kieler.klighd.krendering.KPlacementData;
import de.cau.cs.kieler.klighd.krendering.KPosition;
import de.cau.cs.kieler.klighd.krendering.KRectangle;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingFactory;
import de.cau.cs.kieler.klighd.krendering.KRightPosition;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.krendering.KTopPosition;
import de.cau.cs.kieler.klighd.krendering.KXPosition;
import de.cau.cs.kieler.klighd.krendering.KYPosition;
import de.cau.cs.kieler.klighd.labels.decoration.IDecoratorRenderingProvider;
import de.cau.cs.kieler.klighd.labels.decoration.ITextRenderingProvider;
import de.cau.cs.kieler.klighd.labels.decoration.RectangleDecorator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeLabelPlacement;

public final class LabelDecorationConfigurator {
    private Predicate<KLabel> labelFilter = label -> true;
    private LayoutMode layoutMode = LayoutMode.BOTH;
    private List<IDecoratorRenderingProvider> decoratorRenderingProviders = Lists.newArrayList();
    private IDecoratorRenderingProvider defaultDecorator = RectangleDecorator.create();
    private ITextRenderingProvider labelTextRenderingProvider = this::createDefaultTextRenderer;
    private boolean inlineLabels = false;
    private KRenderingFactory renderingFactory = KRenderingFactory.eINSTANCE;

    private LabelDecorationConfigurator() {
    }

    public static LabelDecorationConfigurator create() {
        return new LabelDecorationConfigurator();
    }

    public LabelDecorationConfigurator withLabelFilter(Predicate<KLabel> filter) {
        Objects.requireNonNull(filter, "filter cannot be null");
        this.labelFilter = filter;
        return this;
    }

    public LabelDecorationConfigurator withLayoutMode(LayoutMode mode) {
        Objects.requireNonNull(mode, "mode cannot be null");
        this.layoutMode = mode;
        return this;
    }

    public LabelDecorationConfigurator addDecoratorRenderingProvider(IDecoratorRenderingProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        this.decoratorRenderingProviders.add(provider);
        return this;
    }

    public LabelDecorationConfigurator withLabelTextRenderingProvider(ITextRenderingProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        this.labelTextRenderingProvider = provider;
        return this;
    }

    public LabelDecorationConfigurator withInlineLabels(boolean inline) {
        this.inlineLabels = inline;
        return this;
    }

    public void applyToAll(KNode graph, boolean subgraphs) {
        for (KNode child : graph.getChildren()) {
            for (KEdge outgoingEdge : child.getOutgoingEdges()) {
                outgoingEdge.getLabels().stream().forEach(l -> this.applyTo((KLabel)l));
            }
            if (!subgraphs || child.getChildren().isEmpty()) continue;
            this.applyToAll(child, true);
        }
    }

    public void applyTo(KLabel label) {
        if (!this.isAffectedLabel(label)) {
            return;
        }
        this.removeExistingRenderings(label);
        this.setupLayoutProperties(label);
        KContainerRendering container = this.createAndAddContainerRendering(label);
        ElkPadding padding = this.createAndAddDecoratorRenderings(label, container);
        this.createAndAddTextRendering(label, container, padding);
    }

    private boolean isAffectedLabel(KLabel label) {
        if (!(label.eContainer() instanceof KEdge)) {
            return false;
        }
        EdgeLabelPlacement placement = (EdgeLabelPlacement)label.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
        if (placement != EdgeLabelPlacement.CENTER) {
            return false;
        }
        return this.labelFilter.test(label);
    }

    private void removeExistingRenderings(KLabel label) {
        ListIterator dataIterator = label.getData().listIterator();
        while (dataIterator.hasNext()) {
            if (!(dataIterator.next() instanceof KRendering)) continue;
            dataIterator.remove();
        }
    }

    private void setupLayoutProperties(KLabel label) {
        label.setProperty(CoreOptions.EDGE_LABELS_INLINE, (Object)this.inlineLabels);
    }

    private KContainerRendering createAndAddContainerRendering(KLabel label) {
        KRectangle container = this.renderingFactory.createKRectangle();
        label.getData().add((Object)container);
        KInvisibility invisibility = this.renderingFactory.createKInvisibility();
        container.getStyles().add((Object)invisibility);
        invisibility.setInvisible(true);
        return container;
    }

    private ElkPadding createAndAddDecoratorRenderings(KLabel label, KContainerRendering container) {
        boolean needDefaultDecorator = this.decoratorRenderingProviders.isEmpty();
        if (needDefaultDecorator) {
            this.decoratorRenderingProviders.add(this.defaultDecorator);
        }
        ElkPadding padding = new ElkPadding();
        for (IDecoratorRenderingProvider decoratorProvider : this.decoratorRenderingProviders) {
            ElkPadding newPadding = decoratorProvider.createDecoratorRendering(container, label, this.layoutMode);
            padding.left = Math.max(padding.left, newPadding.left);
            padding.right = Math.max(padding.right, newPadding.right);
            padding.top = Math.max(padding.top, newPadding.top);
            padding.bottom = Math.max(padding.bottom, newPadding.bottom);
        }
        if (needDefaultDecorator) {
            this.decoratorRenderingProviders.clear();
        }
        return padding;
    }

    private void createAndAddTextRendering(KLabel label, KContainerRendering container, ElkPadding padding) {
        KRendering textRendering = this.labelTextRenderingProvider.createTextRendering(container, label);
        KLeftPosition left = (KLeftPosition)this.renderingFactory.createKLeftPosition().setPosition((float)padding.left, 0.0f);
        KRightPosition right = (KRightPosition)this.renderingFactory.createKRightPosition().setPosition((float)padding.right, 0.0f);
        KTopPosition top = (KTopPosition)this.renderingFactory.createKTopPosition().setPosition((float)padding.top, 0.0f);
        KBottomPosition bottom = (KBottomPosition)this.renderingFactory.createKBottomPosition().setPosition((float)padding.bottom, 0.0f);
        KPosition topLeft = this.renderingFactory.createKPosition().setPositions((KXPosition)left, (KYPosition)top);
        KPosition bottomRight = this.renderingFactory.createKPosition().setPositions((KXPosition)right, (KYPosition)bottom);
        KAreaPlacementData placementData = this.renderingFactory.createKAreaPlacementData();
        placementData.setTopLeft(topLeft);
        placementData.setBottomRight(bottomRight);
        textRendering.setPlacementData((KPlacementData)placementData);
    }

    private KRendering createDefaultTextRenderer(KContainerRendering container, KLabel label) {
        KText ktext = this.renderingFactory.createKText();
        container.getChildren().add((Object)ktext);
        return ktext;
    }

    public static enum LayoutMode {
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }
}

