/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.labels.decoration;

import com.google.common.math.DoubleMath;
import de.cau.cs.kieler.klighd.IStyleModifier;
import de.cau.cs.kieler.klighd.kgraph.KEdge;
import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.kgraph.KPoint;
import de.cau.cs.kieler.klighd.kgraph.util.KGraphUtil;
import de.cau.cs.kieler.klighd.krendering.KInvisibility;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingFactory;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class EdgeLabelStyleModifier
implements IStyleModifier {
    public static final String ID = "de.cau.cs.kieler.klighd.labels.decoration.EdgeLabelStyleModifier";
    private static final double TOLERANCE = 0.5;
    public static final IProperty<Visibility> STYLE_VISIBILITY = new Property("inlineEdgeLabelStyleVisibility");

    public static void install(KRendering rendering, Visibility visibility) {
        KRenderingFactory factory = KRenderingFactory.eINSTANCE;
        KInvisibility invisibility = factory.createKInvisibility();
        invisibility.setInvisible(false);
        invisibility.setProperty(STYLE_VISIBILITY, (Object)visibility);
        invisibility.setModifierId(ID);
        rendering.getStyles().add((Object)invisibility);
    }

    @Override
    public boolean modify(IStyleModifier.StyleModificationContext context) {
        if (!this.shouldProcess(context)) {
            return false;
        }
        KInvisibility style = (KInvisibility)context.getStyle();
        KLabel label = (KLabel)context.getGraphElement();
        KEdge edge = (KEdge)label.eContainer();
        Direction layoutDirection = this.retrieveLayoutDirection(edge);
        if (layoutDirection == null) {
            return false;
        }
        Visibility visibility = (Visibility)((Object)context.getStyle().getProperty(STYLE_VISIBILITY));
        if (visibility == Visibility.SEGMENT_HORIZONTAL) {
            style.setInvisible(layoutDirection.isVertical());
        } else if (visibility == Visibility.SEGMENT_VERTICAL) {
            style.setInvisible(layoutDirection.isHorizontal());
        } else {
            style.setInvisible(this.computeDirectionalVisibility(edge, label) != visibility);
        }
        return true;
    }

    private boolean shouldProcess(IStyleModifier.StyleModificationContext context) {
        if (!(context.getStyle() instanceof KInvisibility)) {
            return false;
        }
        if (!context.getStyle().hasProperty(STYLE_VISIBILITY)) {
            return false;
        }
        if (!(context.getGraphElement() instanceof KLabel)) {
            return false;
        }
        if (!(context.getGraphElement().eContainer() instanceof KEdge)) {
            return false;
        }
        EdgeLabelPlacement placement = (EdgeLabelPlacement)context.getGraphElement().getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
        return placement == EdgeLabelPlacement.CENTER;
    }

    private Direction retrieveLayoutDirection(KEdge edge) {
        KNode source = edge.getSource();
        KNode target = edge.getTarget();
        KNode graph = null;
        if (source.getParent() == target.getParent()) {
            graph = source.getParent();
        } else if (source.getParent() == target) {
            graph = target;
        } else if (source == target.getParent()) {
            graph = source;
        }
        return graph == null ? null : (Direction)graph.getProperty(CoreOptions.DIRECTION);
    }

    private Visibility computeDirectionalVisibility(KEdge edge, KLabel label) {
        Pair<KPoint, KPoint> labelSegment = this.computeLabelSegmentEndPoints(edge, label);
        if (labelSegment == null) {
            return null;
        }
        KPoint tailPoint = (KPoint)labelSegment.getFirst();
        KPoint headPoint = (KPoint)labelSegment.getSecond();
        if (this.isVerticalLine(headPoint, tailPoint)) {
            if (tailPoint.getY() < headPoint.getY()) {
                return Visibility.DIRECTION_DOWN;
            }
            if (tailPoint.getY() > headPoint.getY()) {
                return Visibility.DIRECTION_UP;
            }
        } else if (this.isHorizontalLine(headPoint, tailPoint)) {
            if (tailPoint.getX() < headPoint.getX()) {
                return Visibility.DIRECTION_RIGHT;
            }
            if (tailPoint.getX() > headPoint.getX()) {
                return Visibility.DIRECTION_LEFT;
            }
        }
        return null;
    }

    private Pair<KPoint, KPoint> computeLabelSegmentEndPoints(KEdge edge, KLabel label) {
        boolean inlineLabel = (Boolean)label.getProperty(CoreOptions.EDGE_LABELS_INLINE);
        double edgeLabelDistance = (Double)KGraphUtil.containedGraph((KEdge)edge).getProperty(CoreOptions.SPACING_EDGE_LABEL);
        Rectangle2D.Float labelRect = new Rectangle2D.Float(label.getXpos(), label.getYpos(), label.getWidth(), label.getHeight());
        ArrayList<KPoint> points = new ArrayList<KPoint>(edge.getBendPoints().size() + 1);
        points.addAll((Collection<KPoint>)edge.getBendPoints());
        points.add(edge.getTargetPoint());
        KPoint prevPoint = edge.getSourcePoint();
        for (KPoint currPoint : points) {
            if (this.isOnSegment(labelRect, prevPoint, currPoint, inlineLabel, edgeLabelDistance + 2.0)) {
                return Pair.of((Object)prevPoint, (Object)currPoint);
            }
            prevPoint = currPoint;
        }
        return null;
    }

    private boolean isOnSegment(Rectangle2D.Float labelRect, KPoint segmentStart, KPoint segmentEnd, boolean inlineLabel, double maxDistance) {
        if (!inlineLabel) {
            if (this.isHorizontalLine(segmentStart, segmentEnd)) {
                if (segmentStart.getY() < labelRect.y) {
                    return (double)(labelRect.y - segmentStart.getY()) < maxDistance;
                }
                return (double)(segmentStart.getY() - labelRect.y - labelRect.height) < maxDistance;
            }
            if (this.isVerticalLine(segmentStart, segmentEnd)) {
                if (segmentStart.getX() < labelRect.x) {
                    return (double)(labelRect.x - segmentStart.getX()) < maxDistance;
                }
                return (double)(segmentStart.getX() - labelRect.x - labelRect.width) < maxDistance;
            }
        }
        return labelRect.intersectsLine(segmentStart.getX(), segmentStart.getY(), segmentEnd.getX(), segmentEnd.getY());
    }

    private boolean isHorizontalLine(KPoint p1, KPoint p2) {
        return DoubleMath.fuzzyEquals((double)p1.getY(), (double)p2.getY(), (double)0.5);
    }

    private boolean isVerticalLine(KPoint p1, KPoint p2) {
        return DoubleMath.fuzzyEquals((double)p1.getX(), (double)p2.getX(), (double)0.5);
    }

    public static enum Visibility {
        SEGMENT_HORIZONTAL,
        SEGMENT_VERTICAL,
        DIRECTION_LEFT,
        DIRECTION_RIGHT,
        DIRECTION_UP,
        DIRECTION_DOWN;

    }
}

