/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.krendering;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.KlighdPlugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class KCustomRenderingWrapperFactory {
    private static KCustomRenderingWrapperFactory instance = null;
    private final Map<Class<?>, Class<?>> typeWrapperMap = Maps.newHashMap();

    public static KCustomRenderingWrapperFactory getInstance() {
        if (instance == null) {
            instance = new KCustomRenderingWrapperFactory();
        }
        return instance;
    }

    private KCustomRenderingWrapperFactory() {
        for (KlighdDataManager.CustomFigureWrapperDescriptor descriptor : KlighdDataManager.getInstance().getCustomFigureWrapperDescriptors()) {
            Class figureClass = null;
            Class wrapperClass = null;
            try {
                if (Klighd.IS_PLATFORM_RUNNING) {
                    Bundle host = Platform.getBundle((String)descriptor.contributor);
                    figureClass = host.loadClass(descriptor.customFigureType);
                    wrapperClass = host.loadClass(descriptor.wrapperType);
                } else {
                    figureClass = Klighd.class.getClassLoader().loadClass(descriptor.customFigureType);
                    wrapperClass = Klighd.class.getClassLoader().loadClass(descriptor.wrapperType);
                }
                this.registerWrapper(figureClass, wrapperClass);
            }
            catch (ClassNotFoundException e) {
                String msgSuffix = Klighd.IS_PLATFORM_RUNNING ? "' via bundle '" + descriptor.contributor + "'." : "'.";
                String msg = figureClass == null ? "Failed to load figure class '" + descriptor.customFigureType + msgSuffix : "Failed to load wrapper class '" + descriptor.wrapperType + msgSuffix;
                Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e));
            }
        }
    }

    public void registerWrapper(Class<?> renderingType, Class<?> wrapperType) {
        this.typeWrapperMap.put(renderingType, wrapperType);
    }

    public <T> T getWrapperInstance(String bundleName, String renderingTypeName, Class<T> frameworkType) {
        Bundle bundle;
        if (Strings.isNullOrEmpty((String)renderingTypeName)) {
            String msg = "KLighD custom rendering wrapper factory: Rendering type name not specified.";
            Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", "KLighD custom rendering wrapper factory: Rendering type name not specified."));
            return null;
        }
        if (Klighd.IS_PLATFORM_RUNNING) {
            if (!Strings.isNullOrEmpty((String)bundleName)) {
                bundle = Platform.getBundle((String)bundleName.replace("\"", ""));
                if (bundle == null) {
                    String msg = "KLighD custom rendering wrapper factory: Bundle named " + bundleName + " was not found.";
                    Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg));
                    return null;
                }
            } else {
                bundle = KlighdPlugin.getDefault().getBundle();
            }
        } else {
            bundle = null;
        }
        Class<?> clazz = null;
        try {
            clazz = bundle != null ? bundle.loadClass(renderingTypeName) : Klighd.class.getClassLoader().loadClass(renderingTypeName);
        }
        catch (ClassNotFoundException e) {
            String msg = "KLighD custom rendering wrapper factory: Error occurred whileloading the custom rendering class " + renderingTypeName + (bundle != null ? " in bundle " + bundleName : "") + ".";
            Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e));
            return null;
        }
        return this.getWrapperInstance((Object)clazz, frameworkType);
    }

    public <S, T> T getWrapperInstance(Class<S> renderingType, Class<T> frameworkType) {
        S figure = this.getInstance(renderingType);
        return figure == null ? null : (T)this.getWrapperInstance(renderingType, figure, frameworkType);
    }

    public <S, T> T getWrapperInstance(S figure, Class<T> frameworkType) {
        return this.getWrapperInstance(figure.getClass(), figure, frameworkType);
    }

    private <S, T> T getWrapperInstance(final Class<S> renderingType, S figure, final Class<T> frameworkType) {
        if (frameworkType.isAssignableFrom(renderingType)) {
            if (renderingType.isInstance(figure)) {
                return frameworkType.cast(figure);
            }
            try {
                return frameworkType.cast(this.getInstance(renderingType));
            }
            catch (Exception e) {
                String msg = "KLighD custom rendering wrapper factory: An error occured while instantiating the requested custom figure type " + renderingType.getName() + ".";
                Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e));
                return null;
            }
        }
        Map.Entry entry = (Map.Entry)Iterables.getFirst(Maps.filterEntries(this.typeWrapperMap, (Predicate)new Predicate<Map.Entry<Class<?>, Class<?>>>(){

            public boolean apply(Map.Entry<Class<?>, Class<?>> entry) {
                return entry.getKey().isAssignableFrom(renderingType) && frameworkType.isAssignableFrom(entry.getValue());
            }
        }).entrySet(), null);
        if (entry != null) {
            try {
                return frameworkType.cast(((Class)entry.getValue()).getConstructor((Class)entry.getKey()).newInstance(figure));
            }
            catch (Exception e) {
                String msg = "KLighD custom rendering wrapper factory: An exception occured while instantiating the required wrapper figure for the requested figure type " + renderingType.getName() + ".";
                Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e));
            }
        }
        return null;
    }

    private <S> S getInstance(Class<S> renderingType) {
        Constructor<S> constructor;
        try {
            constructor = renderingType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String msg = "KLighD custom rendering wrapper factory: An exception occured while revealing the required no-arg constructor of the requested custom figure type " + renderingType.getName() + ".";
            Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e));
            return null;
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            String msg = "KLighD custom rendering wrapper factory: An exception occured while instantiating the requested custom figure type " + renderingType.getName() + ".";
            Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e));
            return null;
        }
    }
}

