/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.internal.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import de.cau.cs.kieler.klighd.internal.util.KlighdInternalProperties;
import de.cau.cs.kieler.klighd.kgraph.EMapPropertyHolder;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KGraphPackage;
import de.cau.cs.kieler.klighd.kgraph.impl.IPropertyToObjectMapImpl;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.util.KlighdPredicates;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.InternalEList;

public class SourceModelTrackingAdapter
extends EContentAdapter {
    private static final Predicate<Object> CANDIDATES = KlighdPredicates.instanceOf(KGraphElement.class, KRendering.class, IPropertyToObjectMapImpl.class);
    private static final IProperty<Object> MODEL_ELEMENT = KlighdInternalProperties.MODEL_ELEMENT;
    private Object mapsMonitor = this;
    private Multimap<Object, EObject> sourceTargetsMap = ArrayListMultimap.create();
    private Map<EObject, Object> targetSourceMap = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSourceElement(EObject viewElement) {
        if (viewElement == null) {
            return null;
        }
        Object object = this.mapsMonitor;
        synchronized (object) {
            return this.targetSourceMap.get(viewElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<EObject> getTargetElements(Object element) {
        if (element == null) {
            return Collections.emptyList();
        }
        Object object = this.mapsMonitor;
        synchronized (object) {
            return this.sourceTargetsMap.get(element);
        }
    }

    public void setTarget(EObject newTarget) {
        this.basicSetTarget((Notifier)newTarget);
        Iterator eContents = this.resolve() ? newTarget.eContents().iterator() : ((InternalEList)newTarget.eContents()).basicIterator();
        UnmodifiableIterator i = Iterators.filter((Iterator)eContents, CANDIDATES);
        while (i.hasNext()) {
            Notifier notifier = (Notifier)i.next();
            this.addAdapter(notifier);
        }
    }

    protected void addAdapter(Notifier notifier) {
        super.addAdapter(notifier);
        this.addTracedElement((EObject)notifier);
    }

    protected void removeAdapter(Notifier notifier) {
        super.removeAdapter(notifier);
        this.removeTracedElement((EObject)notifier);
    }

    protected void handleContainment(Notification notification) {
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (!CANDIDATES.apply(notification.getNewValue()) && !CANDIDATES.apply(notification.getOldValue())) break;
                EObject newValue = (EObject)notification.getNewValue();
                if (newValue instanceof IPropertyToObjectMapImpl && ((IPropertyToObjectMapImpl)newValue).getKey() != MODEL_ELEMENT) {
                    return;
                }
                super.handleContainment(notification);
                break;
            }
            case 5: {
                Iterable newValues = Iterables.filter((Iterable)((Iterable)notification.getNewValue()), CANDIDATES);
                for (Notifier newOne : newValues) {
                    this.addAdapter(newOne);
                }
                break;
            }
            case 6: {
                Iterable oldValues = Iterables.filter((Iterable)((Iterable)notification.getOldValue()), CANDIDATES);
                for (Notifier oldOne : oldValues) {
                    this.removeAdapter(oldOne);
                }
                break;
            }
        }
    }

    public void notifyChanged(Notification notification) {
        Object oldValue;
        EMapPropertyHolder notifier;
        super.notifyChanged(notification);
        switch (notification.getEventType()) {
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                return;
            }
        }
        int type = notification.getEventType();
        Object newValue = notification.getNewValue();
        if (notification.getFeature() == KGraphPackage.eINSTANCE.getEMapPropertyHolder_Properties() && notification.getNotifier() instanceof EMapPropertyHolder) {
            notifier = (EMapPropertyHolder)notification.getNotifier();
        } else if (notification.getNotifier() instanceof IPropertyToObjectMapImpl) {
            notifier = (EMapPropertyHolder)((EObject)notification.getNotifier()).eContainer();
        } else {
            return;
        }
        if (type == 1 && ((IPropertyToObjectMapImpl)notification.getNotifier()).getKey() == MODEL_ELEMENT && newValue != null) {
            this.removeTracedElement((EObject)notifier);
            this.addTracedElement((EObject)notifier);
            return;
        }
        if (type == 3) {
            if (newValue instanceof IPropertyToObjectMapImpl && ((IPropertyToObjectMapImpl)newValue).getKey() == MODEL_ELEMENT) {
                this.addTracedElement((EObject)notifier);
                return;
            }
        } else if (type == 4 && (oldValue = notification.getOldValue()) instanceof IPropertyToObjectMapImpl && ((IPropertyToObjectMapImpl)oldValue).getKey() == MODEL_ELEMENT) {
            this.removeTracedElement((EObject)notifier);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTracedElement(EObject element) {
        Object object = this.mapsMonitor;
        synchronized (object) {
            Object sourceElement = this.internalGetSourceElement(element);
            if (sourceElement != null && !this.sourceTargetsMap.containsEntry(sourceElement, (Object)element)) {
                this.sourceTargetsMap.put(sourceElement, (Object)element);
                this.targetSourceMap.put(element, sourceElement);
            }
        }
    }

    private Object internalGetSourceElement(EObject viewElement) {
        Object model = null;
        if (KGraphPackage.eINSTANCE.getEMapPropertyHolder().isInstance((Object)viewElement)) {
            model = ((EMapPropertyHolder)viewElement).getProperty(MODEL_ELEMENT);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTracedElement(EObject element) {
        Object object = this.mapsMonitor;
        synchronized (object) {
            Object o = this.targetSourceMap.remove(element);
            this.sourceTargetsMap.remove(o, (Object)element);
        }
    }
}

