/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.internal.macrolayout;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.KlighdConstants;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.KlighdOptions;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.internal.ILayoutRecorder;
import de.cau.cs.kieler.klighd.internal.macrolayout.AnchorUtil;
import de.cau.cs.kieler.klighd.internal.util.KlighdInternalProperties;
import de.cau.cs.kieler.klighd.kgraph.KEdge;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KGraphFactory;
import de.cau.cs.kieler.klighd.kgraph.KGraphPackage;
import de.cau.cs.kieler.klighd.kgraph.KIdentifier;
import de.cau.cs.kieler.klighd.kgraph.KInsets;
import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.kgraph.KPoint;
import de.cau.cs.kieler.klighd.kgraph.KPort;
import de.cau.cs.kieler.klighd.kgraph.KShapeLayout;
import de.cau.cs.kieler.klighd.kgraph.util.KGraphUtil;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingFactory;
import de.cau.cs.kieler.klighd.krendering.KRenderingOptions;
import de.cau.cs.kieler.klighd.krendering.KRenderingRef;
import de.cau.cs.kieler.klighd.krendering.KRenderingUtil;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.labels.management.LabelManagementResult;
import de.cau.cs.kieler.klighd.microlayout.Bounds;
import de.cau.cs.kieler.klighd.microlayout.PlacementUtil;
import de.cau.cs.kieler.klighd.util.KlighdPredicates;
import de.cau.cs.kieler.klighd.util.KlighdProperties;
import de.cau.cs.kieler.klighd.util.KlighdSynthesisProperties;
import de.cau.cs.kieler.klighd.util.ModelingUtil;
import de.cau.cs.kieler.klighd.util.RenderingContextData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeType;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkGraphFactory;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphSwitch;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.ui.IWorkbenchPart;

public class KlighdDiagramLayoutConnector
implements IDiagramLayoutConnector {
    public static final Object LAYOUT_DATA_CHANGED_VALUE = new Object();
    public static final Object LAYOUT_DATA_UNCHANGED_VALUE = new Object();
    private static final IProperty<List<KEdge>> EDGES = new Property("krendering.layout.edges");
    private static final IProperty<List<KEdge>> EXCLUDED_EDGES = new Property("krendering.layout.excludedEdges");
    private static final IProperty<IWorkbenchPart> WORKBENCH_PART = new Property("klighd.layout.workbenchPart");
    private static final Predicate<KNode> NODE_FILTER = Predicates.and(RenderingContextData.IS_ACTIVE, KlighdPredicates.kgePropertyPredicate(CoreOptions.NO_LAYOUT, false, true));
    private static final IProperty<Boolean> INITIAL_NODE_SIZE = new Property("klighd.initialNodeSize", (Object)true);

    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        KNode viewModel;
        ViewContext viewContext;
        if (diagramPart instanceof KNode) {
            viewContext = null;
            viewModel = (KNode)diagramPart;
        } else if (diagramPart instanceof ViewContext) {
            viewContext = (ViewContext)((Object)diagramPart);
            viewModel = viewContext.getViewModel();
        } else if (diagramPart instanceof IViewer) {
            viewContext = ((IViewer)diagramPart).getViewContext();
            viewModel = viewContext.getViewModel();
        } else if (workbenchPart instanceof IDiagramWorkbenchPart) {
            viewContext = ((IDiagramWorkbenchPart)workbenchPart).getViewer().getViewContext();
            viewModel = viewContext.getViewModel();
        } else {
            viewContext = null;
            viewModel = null;
        }
        if (viewModel == null) {
            throw new UnsupportedOperationException("Not supported by the KLighD KRendering layout manager: Workbench part " + workbenchPart + ", diagram part " + diagramPart);
        }
        boolean performSizeEstimation = viewContext == null ? true : (Boolean)viewContext.getProperty(KlighdSynthesisProperties.SUPPRESS_SIZE_ESTIMATION) == false;
        LayoutMapping mapping = this.buildLayoutGraph(viewModel, performSizeEstimation, workbenchPart);
        if (viewContext != null) {
            mapping.setProperty(WORKBENCH_PART, (Object)viewContext.getDiagramWorkbenchPart());
            mapping.setProperty(KlighdInternalProperties.RECORDER, (Object)viewContext.getLayoutRecorder());
        }
        return mapping;
    }

    public LayoutMapping buildLayoutGraph(KNode viewModel, boolean performSizeEstimation, IWorkbenchPart workbenchPart) {
        LayoutMapping mapping = new LayoutMapping(workbenchPart);
        mapping.setProperty(EDGES, new LinkedList());
        mapping.setParentElement((Object)viewModel);
        ElkNode layoutGraph = ElkGraphUtil.createGraph();
        this.shapeLayoutToLayoutGraph((KShapeLayout)viewModel, (ElkShape)layoutGraph);
        mapping.getGraphMap().put((Object)layoutGraph, (Object)viewModel);
        mapping.setLayoutGraph(layoutGraph);
        this.processNodes(mapping, viewModel, layoutGraph, performSizeEstimation);
        this.processConnections(mapping, performSizeEstimation);
        return mapping;
    }

    private void processNodes(LayoutMapping mapping, KNode viewModelParent, ElkNode layoutParent, boolean performSizeEstimation) {
        for (KNode node : Iterables.filter((Iterable)viewModelParent.getChildren(), NODE_FILTER)) {
            this.createNode(mapping, node, layoutParent, performSizeEstimation);
        }
    }

    private void createNode(LayoutMapping mapping, KNode node, ElkNode layoutParent, boolean performSizeEstimation) {
        boolean isPopulated;
        ElkNode layoutNode = ElkGraphUtil.createNode((ElkNode)layoutParent);
        KIdentifier id = (KIdentifier)node.getData(KIdentifier.class);
        if (id != null && !Strings.isNullOrEmpty((String)id.getId())) {
            layoutNode.setIdentifier(id.getId());
        }
        Predicate filter = (isPopulated = RenderingContextData.IS_POPULATED.apply((Object)node)) ? KlighdPredicates.isExpandedRendering() : Predicates.not(KlighdPredicates.isExpandedRendering());
        KRendering displayedRendering = (KRendering)Iterators.find((Iterator)Iterators.filter((Iterator)node.getData().iterator(), KRendering.class), (Predicate)filter, (Object)((KRendering)node.getData(KRendering.class)));
        boolean isCompoundNode = isPopulated && Iterables.any((Iterable)node.getChildren(), RenderingContextData.IS_ACTIVE);
        this.shapeLayoutToLayoutGraph((KShapeLayout)node, (ElkShape)layoutNode);
        Bounds minSize = Bounds.of(KlighdConstants.MINIMAL_NODE_BOUNDS);
        boolean minNodeSizeIsSet = node.getProperties().containsKey(KlighdProperties.MINIMAL_NODE_SIZE);
        if (minNodeSizeIsSet) {
            minSize = Bounds.of((KVector)node.getProperty(KlighdProperties.MINIMAL_NODE_SIZE));
        } else if (!isCompoundNode || ((Boolean)node.getProperty(INITIAL_NODE_SIZE)).booleanValue()) {
            minSize = Bounds.max(minSize, Bounds.of(node.getWidth(), node.getHeight()));
        }
        boolean deliver = node.eDeliver();
        node.eSetDeliver(false);
        node.setProperty(KlighdProperties.MINIMAL_NODE_SIZE, (Object)new KVector((double)minSize.getWidth(), (double)minSize.getHeight()));
        node.eSetDeliver(deliver);
        KInsets insets = KGraphFactory.eINSTANCE.createKInsets();
        if (displayedRendering != null) {
            Bounds size = performSizeEstimation ? Bounds.max(minSize, PlacementUtil.estimateSize(displayedRendering, minSize)) : minSize;
            PlacementUtil.calculateInsets(displayedRendering, insets, size);
            KVector theMinSize = new KVector((double)size.getWidth(), (double)size.getHeight());
            node.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)theMinSize);
            if (!isCompoundNode) {
                layoutNode.setDimensions((double)size.getWidth(), (double)size.getHeight());
            }
        } else {
            PlacementUtil.calculateInsets(displayedRendering, insets, minSize);
        }
        node.setInsets(insets);
        node.getProperty(CoreOptions.PADDING);
        if (node.getProperty(KlighdProperties.ROUNDED_RECTANGLE_AUTOPADDING) != null) {
            KVector radii = (KVector)node.getProperty(KlighdProperties.ROUNDED_RECTANGLE_AUTOPADDING);
            double padding = 0.0;
            double EPSILON = 1.0E-5;
            if (radii.x < EPSILON && radii.y >= EPSILON) {
                radii.x = EPSILON;
            } else if (radii.x >= EPSILON && radii.y < EPSILON) {
                radii.y = EPSILON;
            }
            if (!(radii.x < EPSILON) || !(radii.y < EPSILON)) {
                double numerator = radii.x * radii.y * (-Math.sqrt(2.0) * Math.sqrt(radii.x * radii.y) + radii.x + radii.y);
                double denominator = radii.x * radii.x + radii.y * radii.y;
                padding = numerator / denominator;
            }
            node.setProperty(CoreOptions.PADDING, (Object)new ElkPadding(padding));
        }
        layoutParent.getChildren().add((Object)layoutNode);
        mapping.getGraphMap().put((Object)layoutNode, (Object)node);
        for (KPort port : Iterables.filter((Iterable)node.getPorts(), RenderingContextData.IS_ACTIVE)) {
            this.createPort(mapping, port, layoutNode, performSizeEstimation);
        }
        for (KLabel label : Iterables.filter((Iterable)node.getLabels(), RenderingContextData.IS_ACTIVE)) {
            this.createLabel(mapping, label, (ElkGraphElement)layoutNode, performSizeEstimation, false);
        }
        if (isCompoundNode) {
            this.processNodes(mapping, node, layoutNode, performSizeEstimation);
        }
        List edges = (List)mapping.getProperty(EDGES);
        Iterables.addAll((Collection)edges, (Iterable)Iterables.filter((Iterable)node.getOutgoingEdges(), RenderingContextData.IS_ACTIVE));
    }

    private void createPort(LayoutMapping mapping, KPort port, ElkNode layoutNode, boolean estimateLabelSizes) {
        ElkPort layoutPort = ElkGraphUtil.createPort((ElkNode)layoutNode);
        KIdentifier id = (KIdentifier)port.getData(KIdentifier.class);
        if (id != null && !Strings.isNullOrEmpty((String)id.getId())) {
            layoutPort.setIdentifier(id.getId());
        }
        this.shapeLayoutToLayoutGraph((KShapeLayout)port, (ElkShape)layoutPort);
        mapping.getGraphMap().put((Object)layoutPort, (Object)port);
        for (KLabel label : port.getLabels()) {
            this.createLabel(mapping, label, (ElkGraphElement)layoutPort, estimateLabelSizes, false);
        }
    }

    private void processConnections(LayoutMapping mapping, boolean estimateLabelSizes) {
        BiMap graphMap = mapping.getGraphMap().inverse();
        List edges = (List)mapping.getProperty(EDGES);
        for (KEdge edge : edges) {
            if (((Boolean)edge.getProperty(CoreOptions.NO_LAYOUT)).booleanValue()) {
                LinkedList<KEdge> excludedEdges = (LinkedList<KEdge>)mapping.getProperty(EXCLUDED_EDGES);
                if (excludedEdges == null) {
                    excludedEdges = new LinkedList<KEdge>();
                    mapping.setProperty(EXCLUDED_EDGES, excludedEdges);
                }
                excludedEdges.add(edge);
                continue;
            }
            ElkConnectableShape layoutSource = null;
            layoutSource = edge.getSourcePort() != null ? (ElkConnectableShape)graphMap.get((Object)edge.getSourcePort()) : (ElkConnectableShape)graphMap.get((Object)edge.getSource());
            ElkConnectableShape layoutTarget = null;
            layoutTarget = edge.getTargetPort() != null ? (ElkConnectableShape)graphMap.get((Object)edge.getTargetPort()) : (ElkConnectableShape)graphMap.get((Object)edge.getTarget());
            if (layoutSource == null || layoutTarget == null) continue;
            this.createEdge(mapping, edge, layoutSource, layoutTarget, estimateLabelSizes);
        }
    }

    private void createEdge(LayoutMapping mapping, KEdge edge, ElkConnectableShape layoutSource, ElkConnectableShape layoutTarget, boolean estimateLabelSizes) {
        ElkEdge layoutEdge = ElkGraphUtil.createSimpleEdge((ElkConnectableShape)layoutSource, (ElkConnectableShape)layoutTarget);
        KIdentifier id = (KIdentifier)edge.getData(KIdentifier.class);
        if (id != null && !Strings.isNullOrEmpty((String)id.getId())) {
            layoutEdge.setIdentifier(id.getId());
        }
        this.edgeLayoutToLayoutGraph(edge, layoutEdge);
        edge.setProperty(CoreOptions.JUNCTION_POINTS, null);
        edge.setProperty(CoreOptions.EDGE_ROUTING, null);
        mapping.getGraphMap().put((Object)layoutEdge, (Object)edge);
        for (KLabel label : Iterables.filter((Iterable)edge.getLabels(), RenderingContextData.IS_ACTIVE)) {
            this.createLabel(mapping, label, (ElkGraphElement)layoutEdge, estimateLabelSizes, true);
        }
    }

    private void createLabel(LayoutMapping mapping, KLabel label, ElkGraphElement layoutLabeledElement, boolean estimateSize, boolean setFontLayoutOptions) {
        KText kText = (KText)Iterators.getNext((Iterator)Iterators.filter((Iterator)KRenderingUtil.selfAndAllChildren((KRendering)((KRendering)label.getData(KRendering.class))), KText.class), null);
        String labelText = label.getText() != null ? label.getText() : (kText != null ? kText.getText() : "");
        ElkLabel layoutLabel = ElkGraphUtil.createLabel((String)labelText, (ElkGraphElement)layoutLabeledElement);
        KIdentifier id = (KIdentifier)label.getData(KIdentifier.class);
        if (id != null && !Strings.isNullOrEmpty((String)id.getId())) {
            layoutLabel.setIdentifier(id.getId());
        }
        this.shapeLayoutToLayoutGraph((KShapeLayout)label, (ElkShape)layoutLabel);
        KRendering rootRendering = (KRendering)label.getData(KRendering.class);
        if (rootRendering != null) {
            if (estimateSize) {
                Bounds minSize = PlacementUtil.estimateSize(rootRendering, new Bounds(0.0f, 0.0f));
                double minWidth = (double)minSize.getWidth() > layoutLabel.getWidth() ? (double)minSize.getWidth() : layoutLabel.getWidth();
                double minHeight = (double)minSize.getHeight() > layoutLabel.getHeight() ? (double)minSize.getHeight() : layoutLabel.getHeight();
                layoutLabel.setDimensions(minWidth, minHeight);
            }
            if (setFontLayoutOptions) {
                PlacementUtil.fontDataFor(label, true);
            }
            KRenderingRef rootRenderingRef = KRenderingFactory.eINSTANCE.createKRenderingRef();
            rootRenderingRef.setRendering(rootRendering);
            layoutLabel.setProperty(KRenderingOptions.K_RENDERING, (Object)rootRenderingRef);
        }
        mapping.getGraphMap().put((Object)layoutLabel, (Object)label);
    }

    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
        ILayoutRecorder recorder = (ILayoutRecorder)mapping.getProperty(KlighdInternalProperties.RECORDER);
        if (recorder != null) {
            IViewer viewer = (IViewer)((Object)recorder);
            boolean suppressEdgeAdjustment = (Boolean)viewer.getViewContext().getProperty(KlighdSynthesisProperties.SUPPRESS_EDGE_ADJUSTMENT);
            if (viewer.getControl() != null && viewer.getControl().isDisposed()) {
                return;
            }
            recorder.startRecording();
            this.applyLayout(mapping, suppressEdgeAdjustment);
            recorder.stopRecording(this.calcAnimationTime(mapping, settings, false));
        } else {
            this.applyLayout(mapping, false);
        }
    }

    private void applyLayout(final LayoutMapping mapping, final boolean suppressEdgeAdjustment) {
        Set elementMappings = mapping.getGraphMap().entrySet();
        final ArrayList graphLabels = Lists.newArrayList();
        for (Map.Entry elementMapping : elementMappings) {
            ElkGraphElement layoutElement = (ElkGraphElement)elementMapping.getKey();
            final KGraphElement element = (KGraphElement)elementMapping.getValue();
            new ElkGraphSwitch<Boolean>(){

                public Boolean caseElkNode(ElkNode layoutNode) {
                    KNode node = (KNode)element;
                    List<IProperty<?>> propertiesToPreserve = KlighdDataManager.getInstance().getPreservedProperties();
                    for (IProperty<?> property : propertiesToPreserve) {
                        if (!layoutNode.hasProperty(property)) continue;
                        node.setProperty(property, layoutNode.getProperty(property));
                    }
                    KlighdDiagramLayoutConnector.this.shapeToViewModel(mapping, (ElkShape)layoutNode, (KShapeLayout)node, true, true);
                    node.setProperty(INITIAL_NODE_SIZE, (Object)false);
                    node.setProperty(CoreOptions.SCALE_FACTOR, (Object)((Double)layoutNode.getProperty(CoreOptions.SCALE_FACTOR)));
                    return true;
                }

                public Boolean caseElkEdge(ElkEdge layoutEdge) {
                    KEdge edge = (KEdge)element;
                    KlighdDiagramLayoutConnector.this.edgeToViewModel(layoutEdge, edge, mapping, !suppressEdgeAdjustment);
                    return true;
                }

                public Boolean caseElkPort(ElkPort layoutPort) {
                    KPort port = (KPort)element;
                    KlighdDiagramLayoutConnector.this.shapeToViewModel(mapping, (ElkShape)layoutPort, (KShapeLayout)port, false, true);
                    port.setProperty(KlighdProperties.LAYOUT_PORT_SIDE, (Object)((PortSide)layoutPort.getProperty(CoreOptions.PORT_SIDE)));
                    return true;
                }

                public Boolean caseElkLabel(ElkLabel layoutLabel) {
                    graphLabels.add(layoutLabel);
                    return true;
                }
            }.doSwitch((EObject)layoutElement);
        }
        List excludedEdges = (List)mapping.getProperty(EXCLUDED_EDGES);
        if (excludedEdges != null) {
            for (KEdge edge : excludedEdges) {
                if (edge == null || edge.getTarget() == null) continue;
                this.handleExcludedEdge(edge);
            }
        }
        for (ElkLabel layoutLabel : graphLabels) {
            KLabel label = (KLabel)mapping.getGraphMap().get((Object)layoutLabel);
            this.shapeToViewModel(mapping, (ElkShape)layoutLabel, (KShapeLayout)label, false, true);
            LabelManagementResult managementResult = (LabelManagementResult)((Object)layoutLabel.getProperty(KlighdOptions.LABELS_MANAGEMENT_RESULT));
            if (managementResult == LabelManagementResult.UNMANAGED) continue;
            label.setProperty(KlighdOptions.LABELS_TEXT_OVERRIDE, (Object)layoutLabel.getText());
            String origLabelText = label.getText();
            if (origLabelText != null && origLabelText.equals(layoutLabel.getText())) {
                label.setProperty(KlighdProperties.TOOLTIP, null);
                continue;
            }
            label.setProperty(KlighdProperties.TOOLTIP, (Object)origLabelText);
        }
    }

    private void shapeLayoutToLayoutGraph(KShapeLayout sourceShapeLayout, ElkShape targetShape) {
        targetShape.setLocation((double)sourceShapeLayout.getXpos(), (double)sourceShapeLayout.getYpos());
        targetShape.setDimensions((double)sourceShapeLayout.getWidth(), (double)sourceShapeLayout.getHeight());
    }

    private void shapeToViewModel(LayoutMapping mapping, ElkShape sourceShape, KShapeLayout targetShapeLayout, boolean copyPadding, boolean adjustScaling) {
        KNode viewModelNode;
        KInsets parentInsets;
        boolean deliver = targetShapeLayout.eDeliver();
        targetShapeLayout.eSetDeliver(false);
        targetShapeLayout.resetModificationFlag();
        KVector offset = new KVector();
        ElkNode containingGraph = ElkGraphUtil.containingGraph((ElkGraphElement)sourceShape);
        if (copyPadding && containingGraph != null && (parentInsets = (viewModelNode = (KNode)mapping.getGraphMap().get((Object)containingGraph)).getInsets()) != null) {
            offset.add((double)(-parentInsets.getLeft()), (double)(-parentInsets.getTop()));
        }
        if (adjustScaling && containingGraph != null) {
            if (sourceShape instanceof ElkNode) {
                double scale = (Double)sourceShape.getProperty(CoreOptions.SCALE_FACTOR);
                targetShapeLayout.setPos((float)(sourceShape.getX() + offset.x), (float)(sourceShape.getY() + offset.y));
                targetShapeLayout.setSize((float)(sourceShape.getWidth() / scale), (float)(sourceShape.getHeight() / scale));
            } else if (sourceShape instanceof ElkPort || sourceShape instanceof ElkLabel) {
                double scale = (Double)ModelingUtil.eContainerOfType((EObject)sourceShape, ElkNode.class).getProperty(CoreOptions.SCALE_FACTOR);
                targetShapeLayout.setPos((float)(sourceShape.getX() / scale), (float)(sourceShape.getY() / scale));
                targetShapeLayout.setSize((float)(sourceShape.getWidth() / scale), (float)(sourceShape.getHeight() / scale));
                KVector anchor = (KVector)targetShapeLayout.getProperty(CoreOptions.PORT_ANCHOR);
                if (anchor != null) {
                    anchor.x /= scale;
                    anchor.y /= scale;
                }
            }
        } else {
            targetShapeLayout.setPos((float)(sourceShape.getX() + offset.x), (float)(sourceShape.getY() + offset.y));
            targetShapeLayout.setSize((float)sourceShape.getWidth(), (float)sourceShape.getHeight());
        }
        targetShapeLayout.eSetDeliver(deliver);
        if (deliver) {
            Object newValue = targetShapeLayout.isModified() ? LAYOUT_DATA_CHANGED_VALUE : LAYOUT_DATA_UNCHANGED_VALUE;
            targetShapeLayout.eNotify((Notification)new ENotificationImpl((InternalEObject)targetShapeLayout, 1, (EStructuralFeature)KGraphPackage.eINSTANCE.getKShapeLayout_Xpos(), null, newValue));
        }
    }

    private void edgeLayoutToLayoutGraph(KEdge viewModelEdge, ElkEdge layoutEdge) {
        if (viewModelEdge.getSourcePoint() == null) {
            viewModelEdge.setSourcePoint(KGraphFactory.eINSTANCE.createKPoint());
        }
        KInsets parentPadding = this.effectivePaddingForEdge(viewModelEdge);
        ElkEdgeSection layoutEdgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)layoutEdge, (boolean)false, (boolean)true);
        KPoint sourcePoint = viewModelEdge.getSourcePoint();
        if (sourcePoint != null) {
            layoutEdgeSection.setStartLocation((double)sourcePoint.getX(), (double)sourcePoint.getY());
        }
        ListIterator originBendIter = viewModelEdge.getBendPoints().listIterator();
        ListIterator destBendIter = layoutEdgeSection.getBendPoints().listIterator();
        while (originBendIter.hasNext()) {
            ElkBendPoint destPoint;
            KPoint originPoint = (KPoint)originBendIter.next();
            if (destBendIter.hasNext()) {
                destPoint = (ElkBendPoint)destBendIter.next();
            } else {
                destPoint = ElkGraphFactory.eINSTANCE.createElkBendPoint();
                destBendIter.add(destPoint);
            }
            destPoint.set((double)originPoint.getX(), (double)originPoint.getY());
        }
        while (destBendIter.hasNext()) {
            destBendIter.next();
            destBendIter.remove();
        }
        KPoint targetPoint = viewModelEdge.getTargetPoint();
        if (targetPoint != null) {
            layoutEdgeSection.setEndLocation((double)targetPoint.getX(), (double)targetPoint.getY());
        }
        KGraphUtil.toELKGraphCoordinateSystem((ElkEdge)layoutEdge, (KInsets)parentPadding);
    }

    private KInsets effectivePaddingForEdge(KEdge viewModelEdge) {
        KNode relativeNode = KGraphUtil.isDescendant((KNode)viewModelEdge.getTarget(), (KNode)viewModelEdge.getSource()) ? viewModelEdge.getSource() : viewModelEdge.getSource().getParent();
        return relativeNode.getInsets();
    }

    private void edgeToViewModel(ElkEdge layoutEdge, KEdge viewModelEdge, LayoutMapping mapping, boolean adjustments) {
        boolean deliver = viewModelEdge.eDeliver();
        viewModelEdge.eSetDeliver(false);
        if (adjustments) {
            this.adjustEdgeEndpoints(layoutEdge, viewModelEdge);
        }
        KNode kgraphEdgeCoordinatesOrigin = KGraphUtil.containedGraph((KEdge)viewModelEdge);
        KGraphUtil.toKGraphCoordinateSystem((ElkEdge)layoutEdge, (KInsets)kgraphEdgeCoordinatesOrigin.getInsets());
        viewModelEdge.setProperty(CoreOptions.EDGE_TYPE, (Object)((EdgeType)layoutEdge.getProperty(CoreOptions.EDGE_TYPE)));
        viewModelEdge.setProperty(CoreOptions.JUNCTION_POINTS, (Object)((KVectorChain)layoutEdge.getProperty(CoreOptions.JUNCTION_POINTS)));
        ElkEdgeSection layoutEdgeSection = (ElkEdgeSection)layoutEdge.getSections().get(0);
        if (viewModelEdge.getSourcePoint() == null) {
            viewModelEdge.setSourcePoint(KGraphFactory.eINSTANCE.createKPoint());
        }
        boolean sourcePointDeliver = viewModelEdge.getSourcePoint().eDeliver();
        viewModelEdge.getSourcePoint().eSetDeliver(false);
        viewModelEdge.getSourcePoint().setPos((float)layoutEdgeSection.getStartX(), (float)layoutEdgeSection.getStartY());
        viewModelEdge.getSourcePoint().eSetDeliver(sourcePointDeliver);
        ListIterator originBendIter = layoutEdgeSection.getBendPoints().listIterator();
        ListIterator destBendIter = viewModelEdge.getBendPoints().listIterator();
        while (originBendIter.hasNext()) {
            KPoint destPoint;
            ElkBendPoint originPoint = (ElkBendPoint)originBendIter.next();
            if (destBendIter.hasNext()) {
                destPoint = (KPoint)destBendIter.next();
            } else {
                destPoint = KGraphFactory.eINSTANCE.createKPoint();
                destBendIter.add(destPoint);
            }
            destPoint.setPos((float)originPoint.getX(), (float)originPoint.getY());
        }
        while (destBendIter.hasNext()) {
            destBendIter.next();
            destBendIter.remove();
        }
        if (viewModelEdge.getTargetPoint() == null) {
            viewModelEdge.setTargetPoint(KGraphFactory.eINSTANCE.createKPoint());
        }
        boolean targetPointDeliver = viewModelEdge.getTargetPoint().eDeliver();
        viewModelEdge.getTargetPoint().eSetDeliver(false);
        viewModelEdge.getTargetPoint().setPos((float)layoutEdgeSection.getEndX(), (float)layoutEdgeSection.getEndY());
        viewModelEdge.getTargetPoint().eSetDeliver(targetPointDeliver);
        viewModelEdge.eSetDeliver(deliver);
        ENotificationImpl notification = new ENotificationImpl((InternalEObject)viewModelEdge, 1, 4, null, null);
        viewModelEdge.eNotify((Notification)notification);
    }

    private void adjustEdgeEndpoints(ElkEdge layoutEdge, KEdge viewModelEdge) {
        ElkNode containingNode = layoutEdge.getContainingNode();
        ElkEdgeSection edgeSection = (ElkEdgeSection)layoutEdge.getSections().get(0);
        ElkNode source = ElkGraphUtil.getSourceNode((ElkEdge)layoutEdge);
        ElkPort sourcePort = ElkGraphUtil.getSourcePort((ElkEdge)layoutEdge);
        ElkNode target = ElkGraphUtil.getTargetNode((ElkEdge)layoutEdge);
        ElkPort targetPort = ElkGraphUtil.getTargetPort((ElkEdge)layoutEdge);
        KVector sourceVector = new KVector(edgeSection.getStartX(), edgeSection.getStartY());
        ElkUtil.toAbsolute((KVector)sourceVector, (ElkNode)containingNode);
        ElkUtil.toRelative((KVector)sourceVector, (ElkNode)source);
        KRendering sourceRendering = (KRendering)viewModelEdge.getSource().getData(KRendering.class);
        KRendering sourcePortRendering = viewModelEdge.getSourcePort() == null ? null : (KRendering)viewModelEdge.getSourcePort().getData(KRendering.class);
        boolean adjustSourcePortPosition = ElkGraphUtil.isDescendant((ElkNode)target, (ElkNode)source);
        KVector adjustedSource = this.checkAndCopyPoint(sourceVector, source, sourcePort, sourceRendering, sourcePortRendering, adjustSourcePortPosition);
        ElkUtil.toAbsolute((KVector)adjustedSource, (ElkNode)source);
        ElkUtil.toRelative((KVector)adjustedSource, (ElkNode)containingNode);
        edgeSection.setStartLocation(adjustedSource.x, adjustedSource.y);
        KVector targetVector = new KVector(edgeSection.getEndX(), edgeSection.getEndY());
        ElkUtil.toAbsolute((KVector)targetVector, (ElkNode)containingNode);
        ElkUtil.toRelative((KVector)targetVector, (ElkNode)target);
        KRendering targetRendering = (KRendering)viewModelEdge.getTarget().getData(KRendering.class);
        KRendering targetPortRendering = viewModelEdge.getTargetPort() == null ? null : (KRendering)viewModelEdge.getTargetPort().getData(KRendering.class);
        boolean adjustTargetPortPosition = !adjustSourcePortPosition && !KlighdDiagramLayoutConnector.isSibling(source, target);
        KVector adjustedTarget = this.checkAndCopyPoint(targetVector, target, targetPort, targetRendering, targetPortRendering, adjustTargetPortPosition);
        ElkUtil.toAbsolute((KVector)adjustedTarget, (ElkNode)target);
        ElkUtil.toRelative((KVector)adjustedTarget, (ElkNode)containingNode);
        edgeSection.setEndLocation(adjustedTarget.x, adjustedTarget.y);
    }

    public static boolean isSibling(ElkNode node1, ElkNode node2) {
        return node1.getParent() == node2.getParent() && node1.getParent() != null;
    }

    private KVector checkAndCopyPoint(KVector originPoint, ElkNode node, ElkPort port, KRendering nodeRendering, KRendering portRendering, boolean adjustPortPosAndSize) {
        KVector p = originPoint.clone();
        double scale = (Double)node.getProperty(CoreOptions.SCALE_FACTOR);
        if (port == null) {
            p = AnchorUtil.nearestBorderPoint(p, node.getWidth(), node.getHeight(), nodeRendering, scale);
            return p;
        }
        KVector portPos = new KVector(port.getX(), port.getY());
        KVector portSize = new KVector(port.getWidth(), port.getHeight());
        if (adjustPortPosAndSize) {
            portPos.scale(1.0 / scale);
            portSize.scale(1.0 / scale);
        }
        p.sub(portPos);
        p = AnchorUtil.nearestBorderPoint(p, portSize.x, portSize.y, portRendering, scale);
        return p.add(portPos);
    }

    private void handleExcludedEdge(KEdge edge) {
        KPoint sourceKPoint;
        boolean deliver = edge.eDeliver();
        edge.eSetDeliver(false);
        edge.getBendPoints().clear();
        KNode sourceNode = edge.getSource();
        KNode targetNode = edge.getTarget();
        KPort sourcePort = edge.getSourcePort();
        KPort targetPort = edge.getTargetPort();
        boolean targetInSource = KGraphUtil.isDescendant((KNode)targetNode, (KNode)sourceNode);
        KVector sourcePoint = this.toElementBorder(sourceNode, sourcePort, targetNode, targetPort);
        if (targetInSource) {
            if (sourceNode.getInsets() != null) {
                sourcePoint.add((double)(-sourceNode.getInsets().getLeft()), (double)(-sourceNode.getInsets().getTop()));
            }
        } else {
            sourcePoint.add((double)sourceNode.getXpos() * (Double)sourceNode.getProperty(CoreOptions.TOPDOWN_SCALE_FACTOR), (double)sourceNode.getYpos() * (Double)sourceNode.getProperty(CoreOptions.TOPDOWN_SCALE_FACTOR));
        }
        if ((sourceKPoint = edge.getSourcePoint()) == null) {
            sourceKPoint = KGraphFactory.eINSTANCE.createKPoint();
            edge.setSourcePoint(sourceKPoint);
        }
        sourceKPoint.applyVector(sourcePoint);
        KVector targetPoint = this.toElementBorder(targetNode, targetPort, sourceNode, sourcePort);
        targetPoint.add((double)targetNode.getXpos() * (Double)targetNode.getParent().getProperty(CoreOptions.TOPDOWN_SCALE_FACTOR), (double)targetNode.getYpos() * (Double)targetNode.getParent().getProperty(CoreOptions.TOPDOWN_SCALE_FACTOR));
        if (targetInSource) {
            KGraphUtil.toAbsolute((KVector)targetPoint, (KNode)targetNode.getParent());
            KGraphUtil.toRelative((KVector)targetPoint, (KNode)sourceNode);
        } else if (sourceNode.getParent() != targetNode.getParent()) {
            KGraphUtil.toAbsolute((KVector)targetPoint, (KNode)targetNode.getParent());
            KGraphUtil.toRelative((KVector)targetPoint, (KNode)sourceNode.getParent());
        }
        KPoint targetKPoint = edge.getTargetPoint();
        if (targetKPoint == null) {
            targetKPoint = KGraphFactory.eINSTANCE.createKPoint();
            edge.setTargetPoint(targetKPoint);
        }
        targetKPoint.applyVector(targetPoint);
        edge.eSetDeliver(deliver);
        edge.eNotify((Notification)new ENotificationImpl((InternalEObject)edge, 1, 4, null, null));
    }

    private KVector toElementBorder(KNode centerNode, KPort centerPort, KNode remoteNode, KPort remotePort) {
        KVector point = new KVector();
        if (remotePort == null) {
            point.x = remoteNode.getWidth() / 2.0f;
            point.y = remoteNode.getHeight() / 2.0f;
        } else {
            point.x = remotePort.getXpos() + remotePort.getWidth() / 2.0f;
            point.y = remotePort.getYpos() + remotePort.getHeight() / 2.0f;
        }
        point.add((double)remoteNode.getXpos(), (double)remoteNode.getYpos());
        if (centerNode.getParent() != remoteNode.getParent()) {
            KGraphUtil.toAbsolute((KVector)point, (KNode)remoteNode.getParent());
            KGraphUtil.toRelative((KVector)point, (KNode)centerNode.getParent());
        }
        point.add((double)(-centerNode.getXpos()), (double)(-centerNode.getYpos()));
        if (centerPort == null) {
            point = AnchorUtil.collideTowardsCenter(point, centerNode.getWidth(), centerNode.getHeight(), (KRendering)centerNode.getData(KRendering.class));
        } else {
            point.add((double)(-centerPort.getXpos()), (double)(-centerPort.getYpos()));
            point = AnchorUtil.collideTowardsCenter(point, centerPort.getWidth(), centerPort.getHeight(), (KRendering)centerPort.getData(KRendering.class));
            point.add((double)centerPort.getXpos(), (double)centerPort.getYpos());
        }
        return point;
    }

    private int calcAnimationTime(LayoutMapping mapping, IPropertyHolder settings, boolean viewerNotVisible) {
        boolean animate = (Boolean)settings.getProperty(CoreOptions.ANIMATE);
        if (animate) {
            int factor;
            int maxTime;
            int minTime = (Integer)settings.getProperty(CoreOptions.MIN_ANIM_TIME);
            if (minTime < 0) {
                minTime = 0;
            }
            if ((maxTime = ((Integer)settings.getProperty(CoreOptions.MAX_ANIM_TIME)).intValue()) < minTime) {
                maxTime = minTime;
            }
            if ((factor = ((Integer)settings.getProperty(CoreOptions.ANIM_TIME_FACTOR)).intValue()) > 0) {
                int graphSize = KlighdDiagramLayoutConnector.countNodes(mapping.getLayoutGraph());
                int time = minTime + (int)((double)factor * Math.sqrt(graphSize));
                return time <= maxTime ? time : maxTime;
            }
            return minTime;
        }
        return 0;
    }

    private static int countNodes(ElkNode node) {
        int count = 0;
        for (ElkNode child : node.getChildren()) {
            count += KlighdDiagramLayoutConnector.countNodes(child) + 1;
        }
        return count;
    }
}

