/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.filtering.parser;

import de.cau.cs.kieler.klighd.filtering.AndConnective;
import de.cau.cs.kieler.klighd.filtering.FalseConnective;
import de.cau.cs.kieler.klighd.filtering.GreaterEqualsConnective;
import de.cau.cs.kieler.klighd.filtering.GreaterThanConnective;
import de.cau.cs.kieler.klighd.filtering.LessEqualsConnective;
import de.cau.cs.kieler.klighd.filtering.LessThanConnective;
import de.cau.cs.kieler.klighd.filtering.LogicEqualConnective;
import de.cau.cs.kieler.klighd.filtering.NegationConnective;
import de.cau.cs.kieler.klighd.filtering.NumericAdditionConnective;
import de.cau.cs.kieler.klighd.filtering.NumericConstantConnective;
import de.cau.cs.kieler.klighd.filtering.NumericDivisionConnective;
import de.cau.cs.kieler.klighd.filtering.NumericEqualConnective;
import de.cau.cs.kieler.klighd.filtering.NumericMultiplicationConnective;
import de.cau.cs.kieler.klighd.filtering.NumericNotEqualConnective;
import de.cau.cs.kieler.klighd.filtering.NumericResult;
import de.cau.cs.kieler.klighd.filtering.NumericSubtractionConnective;
import de.cau.cs.kieler.klighd.filtering.OrConnective;
import de.cau.cs.kieler.klighd.filtering.SemanticFilterRule;
import de.cau.cs.kieler.klighd.filtering.SemanticFilterTag;
import de.cau.cs.kieler.klighd.filtering.TrueConnective;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

public class SemanticFilterRuleParser {
    private static List<String> OPERATORS = new ArrayList<String>(Arrays.asList("*", "/", "+", "-", "=", "!=", ">=", ">", "<=", "<", "||", "&&", "!"));
    private static Map<String, Integer> PRECEDENCES = new HashMap<String, Integer>(){
        {
            this.put("*", 10);
            this.put("/", 10);
            this.put("+", 9);
            this.put("-", 9);
            this.put("=", 7);
            this.put("!=", 7);
            this.put(">=", 8);
            this.put(">", 8);
            this.put("<=", 8);
            this.put("<", 8);
            this.put("||", 3);
            this.put("&&", 4);
            this.put("!", 6);
        }
    };

    private SemanticFilterRule convertAST(Node ast) throws InvalidSyntaxException {
        try {
            SemanticFilterRule result;
            switch (ast.token) {
                case "*": {
                    result = new NumericMultiplicationConnective((NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(0))), (NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(1))));
                    break;
                }
                case "/": {
                    result = new NumericDivisionConnective((NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(0))), (NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(1))));
                    break;
                }
                case "+": {
                    result = new NumericAdditionConnective((NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(0))), (NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(1))));
                    break;
                }
                case "-": {
                    result = new NumericSubtractionConnective((NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(0))), (NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(1))));
                    break;
                }
                case "=": {
                    if (ast.type == 0) {
                        result = new LogicEqualConnective(this.convertAST(((OperatorNode)ast).getChildren().get(0)), this.convertAST(((OperatorNode)ast).getChildren().get(1)));
                        break;
                    }
                    result = new NumericEqualConnective((NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(0))), (NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(1))));
                    break;
                }
                case "!=": {
                    result = new NumericNotEqualConnective((NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(0))), (NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(1))));
                    break;
                }
                case ">=": {
                    result = new GreaterEqualsConnective((NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(0))), (NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(1))));
                    break;
                }
                case ">": {
                    result = new GreaterThanConnective((NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(0))), (NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(1))));
                    break;
                }
                case "<=": {
                    result = new LessEqualsConnective((NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(0))), (NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(1))));
                    break;
                }
                case "<": {
                    result = new LessThanConnective((NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(0))), (NumericResult)((Object)this.convertAST(((OperatorNode)ast).getChildren().get(1))));
                    break;
                }
                case "||": {
                    result = new OrConnective(this.convertAST(((OperatorNode)ast).getChildren().get(0)), this.convertAST(((OperatorNode)ast).getChildren().get(1)));
                    break;
                }
                case "&&": {
                    result = new AndConnective(this.convertAST(((OperatorNode)ast).getChildren().get(0)), this.convertAST(((OperatorNode)ast).getChildren().get(1)));
                    break;
                }
                case "!": {
                    result = new NegationConnective(this.convertAST(((OperatorNode)ast).getChildren().get(0)));
                    break;
                }
                case "true": {
                    result = new TrueConnective();
                    break;
                }
                case "false": {
                    result = new FalseConnective();
                }
                default: {
                    result = ast.token.charAt(0) == '$' || ast.token.charAt(0) == '#' ? new SemanticFilterTag(ast.token.substring(1)) : new NumericConstantConnective(Double.valueOf(ast.token));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new InvalidSyntaxException("Syntax error.");
        }
    }

    /*
     * Unable to fully structure code
     */
    public SemanticFilterRule parse(String ruleString) throws InvalidSyntaxException {
        tokenizer = new StringTokenizer(ruleString);
        operatorStack = new Stack<OperatorNode>();
        outputStack = new Stack<Node>();
        while (tokenizer.hasMoreTokens()) {
            block8: {
                token = tokenizer.nextToken();
                if (SemanticFilterRuleParser.OPERATORS.contains(token)) {
                    while (!(operatorStack.isEmpty() || operatorStack.peek().token.equals("(") || SemanticFilterRuleParser.PRECEDENCES.get(operatorStack.peek().token) <= SemanticFilterRuleParser.PRECEDENCES.get(token) && (SemanticFilterRuleParser.PRECEDENCES.get(operatorStack.peek().token) != SemanticFilterRuleParser.PRECEDENCES.get(token) || token.equals("!")))) {
                        this.popOperator(operatorStack, outputStack);
                    }
                    operatorStack.push(new OperatorNode(token, -1));
                    continue;
                }
                if (token.equals("(")) {
                    operatorStack.push(new OperatorNode(token, -1));
                    continue;
                }
                if (!token.equals(")")) break block8;
                if (!operatorStack.isEmpty()) ** GOTO lbl23
                throw new InvalidSyntaxException("Mismatched parentheses.");
lbl-1000:
                // 1 sources

                {
                    if (operatorStack.isEmpty()) {
                        throw new InvalidSyntaxException("Mismatched parentheses.");
                    }
                    this.popOperator(operatorStack, outputStack);
lbl23:
                    // 2 sources

                    ** while (!operatorStack.peek().token.equals((Object)"("))
                }
lbl24:
                // 1 sources

                operatorStack.pop();
                continue;
            }
            if (token.startsWith("#") || token.equals("true") || token.equals("false")) {
                outputStack.push(new OperandNode(token, 0));
                continue;
            }
            outputStack.push(new OperandNode(token, 1));
        }
        while (!operatorStack.isEmpty()) {
            this.popOperator(operatorStack, outputStack);
        }
        return this.convertAST((Node)outputStack.pop());
    }

    private void popOperator(Stack<OperatorNode> operatorStack, Stack<Node> outputStack) throws InvalidSyntaxException {
        OperatorNode operator = operatorStack.pop();
        if (operator.token.equals("(") || operator.token.equals(")")) {
            throw new InvalidSyntaxException("Mismatched parentheses.");
        }
        if (operator.token.equals("!")) {
            Node operand = outputStack.pop();
            operator.addChild(operand);
            operator.type = 0;
            outputStack.push(operator);
        } else {
            Node operand1 = outputStack.pop();
            Node operand2 = outputStack.pop();
            operator.addChild(operand2);
            operator.addChild(operand1);
            if (operand1.type != operand2.type) {
                throw new InvalidSyntaxException("Mixed use of boolean and numeric types in operator " + operator.token + ".");
            }
            operator.type = operand1.type;
            outputStack.push(operator);
        }
    }

    public class InvalidSyntaxException
    extends Exception {
        public InvalidSyntaxException(String message) {
            super(message);
        }
    }

    private abstract class Node {
        public String token;
        public int type;

        public Node(String token, int type) {
            this.token = token;
            this.type = type;
        }
    }

    private class OperandNode
    extends Node {
        public OperandNode(String token, int type) {
            super(token, type);
        }
    }

    private class OperatorNode
    extends Node {
        private List<Node> children;

        public List<Node> getChildren() {
            return this.children;
        }

        public OperatorNode(String token, int type) {
            super(token, type);
            this.children = new ArrayList<Node>();
        }

        public OperatorNode(String token, int type, List<Node> children) {
            super(token, type);
            this.children = children;
        }

        public void addChild(Node child) {
            this.children.add(child);
        }
    }
}

