/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.filtering;

import de.cau.cs.kieler.klighd.filtering.AndConnective;
import de.cau.cs.kieler.klighd.filtering.FalseConnective;
import de.cau.cs.kieler.klighd.filtering.IdentityConnective;
import de.cau.cs.kieler.klighd.filtering.OrConnective;
import de.cau.cs.kieler.klighd.filtering.SemanticFilterRule;

public abstract class SemanticFilterRuleUtil {
    public static SemanticFilterRule getBigOrConnective(SemanticFilterRule ... operands) {
        return SemanticFilterRuleUtil.getBigOrConnective(null, operands);
    }

    public static SemanticFilterRule getBigOrConnective(String ruleName, SemanticFilterRule ... operands) {
        if (operands.length <= 0) {
            return new FalseConnective();
        }
        if (operands.length <= 1) {
            return SemanticFilterRuleUtil.addRuleName(ruleName, operands[0]);
        }
        OrConnective bigOr = new OrConnective(operands[0], operands[1], ruleName);
        int i = 2;
        while (i < operands.length) {
            bigOr.rightOperand = new OrConnective(bigOr.rightOperand, operands[i]);
            ++i;
        }
        return bigOr;
    }

    public static SemanticFilterRule getBigAndConnective(SemanticFilterRule ... operands) {
        return SemanticFilterRuleUtil.getBigAndConnective(null, operands);
    }

    public static SemanticFilterRule getBigAndConnective(String ruleName, SemanticFilterRule ... operands) {
        if (operands.length <= 0) {
            return new FalseConnective();
        }
        if (operands.length <= 1) {
            return SemanticFilterRuleUtil.addRuleName(ruleName, operands[0]);
        }
        AndConnective bigAnd = new AndConnective(operands[0], operands[1], ruleName);
        int i = 2;
        while (i < operands.length) {
            bigAnd.rightOperand = new AndConnective(bigAnd.rightOperand, operands[i]);
            ++i;
        }
        return bigAnd;
    }

    public static SemanticFilterRule addRuleName(String ruleName, SemanticFilterRule rule) {
        return new IdentityConnective(rule, ruleName);
    }
}

