/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.actions;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.klighd.IAction;
import de.cau.cs.kieler.klighd.KlighdOptions;
import de.cau.cs.kieler.klighd.kgraph.KEdge;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.core.options.CoreOptions;

public class FocusAndContextAction
implements IAction {
    public static final String ID = "de.cau.cs.kieler.klighd.actions.FocusAndContextAction";
    private KGraphElement lastSelectedElement = null;

    @Override
    public final IAction.ActionResult execute(IAction.ActionContext context) {
        KGraphElement selectedElement = context.getKGraphElement();
        if (selectedElement == this.lastSelectedElement) {
            return IAction.ActionResult.createResult(false);
        }
        this.focusElement(this.lastSelectedElement, false);
        this.focusElement(selectedElement, true);
        this.lastSelectedElement = selectedElement;
        return IAction.ActionResult.createResult(true);
    }

    private void focusElement(KGraphElement element, boolean focus) {
        if (element != null) {
            List<KGraphElement> furtherFocussedElements;
            this.focusGraphElement(element, focus);
            if (element instanceof KLabeledGraphElement) {
                this.focusGraphElementLabels((KLabeledGraphElement)element, focus);
            }
            if ((furtherFocussedElements = this.determineFocussedElements(element)) != null) {
                furtherFocussedElements.stream().forEach(e -> this.focusElement((KGraphElement)e, focus));
            }
        }
    }

    protected List<KGraphElement> determineFocussedElements(KGraphElement element) {
        if (element instanceof KNode) {
            KNode node = (KNode)element;
            ArrayList result = Lists.newArrayList();
            result.addAll(node.getPorts());
            for (KEdge edge : node.getIncomingEdges()) {
                if (!((Boolean)edge.getSource().getProperty(CoreOptions.COMMENT_BOX)).booleanValue()) continue;
                result.add(edge.getSource());
            }
            return result;
        }
        return null;
    }

    private void focusGraphElement(KGraphElement element, boolean focus) {
        element.setProperty(KlighdOptions.LABELS_ELEMENT_IN_FOCUS, (Object)focus);
    }

    private void focusGraphElementLabels(KLabeledGraphElement element, boolean focus) {
        for (KLabel label : element.getLabels()) {
            this.focusGraphElement((KGraphElement)label, focus);
        }
    }
}

