/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import de.cau.cs.kieler.klighd.IAction;
import de.cau.cs.kieler.klighd.KlighdPreferences;
import de.cau.cs.kieler.klighd.ViewContext;

public enum ZoomStyle {
    NONE,
    ZOOM_TO_ACTUAL_SIZE,
    ZOOM_TO_FIT,
    ZOOM_TO_FIT_CONTENT,
    ZOOM_TO_FOCUS,
    ZOOM_TO_FOCUS_OR_INCREASE_TO_FIT,
    ZOOM_TO_STAY;

    private static ZoomStyle zoomToFocusStyle;

    static {
        zoomToFocusStyle = null;
    }

    public static ZoomStyle getZoomToFocusStyle() {
        if (zoomToFocusStyle == null) {
            zoomToFocusStyle = KlighdPreferences.getZoomToFocusStyle();
        }
        return zoomToFocusStyle;
    }

    public static ZoomStyle create(boolean zoomToActualSize, boolean zoomToFit, boolean zoomToFocus) {
        return ZoomStyle.create(zoomToActualSize, zoomToFit, false, zoomToFocus, false);
    }

    public static ZoomStyle create(boolean zoomToActualSize, boolean zoomToFit, boolean zoomToFitContent, boolean zoomToFocus) {
        return ZoomStyle.create(zoomToActualSize, zoomToFit, zoomToFitContent, zoomToFocus, false);
    }

    public static ZoomStyle create(boolean zoomToActualSize, boolean zoomToFit, boolean zoomToFitContent, boolean zoomToFocus, boolean zoomToStay) {
        if (zoomToActualSize) {
            return ZOOM_TO_ACTUAL_SIZE;
        }
        if (zoomToFitContent) {
            return ZOOM_TO_FIT_CONTENT;
        }
        if (zoomToFit) {
            return ZOOM_TO_FIT;
        }
        if (zoomToFocus) {
            return KlighdPreferences.getZoomToFocusStyle();
        }
        if (zoomToStay) {
            return ZOOM_TO_STAY;
        }
        return NONE;
    }

    public static ZoomStyle create(IAction.ActionResult actionResult, ViewContext viewContext) {
        boolean zoomToActualSize = actionResult.getZoomToActualSize() != null ? actionResult.getZoomToActualSize() : false;
        boolean zoomToFit = actionResult.getZoomToFit() != null ? actionResult.getZoomToFit().booleanValue() : viewContext.isZoomToFit();
        boolean zoomToFitContent = actionResult.getZoomToFitContent() != null ? actionResult.getZoomToFitContent().booleanValue() : viewContext.isZoomToFitContent();
        boolean zoomToFocus = actionResult.getZoomToFocus() != null ? actionResult.getZoomToFocus().booleanValue() : viewContext.isZoomToFocus();
        boolean zoomToStay = actionResult.getZoomToStay() != null ? actionResult.getZoomToStay().booleanValue() : viewContext.isZoomToStay();
        return ZoomStyle.create(zoomToActualSize, zoomToFit, zoomToFitContent, zoomToFocus, zoomToStay);
    }

    public static ZoomStyle valueOf(String string) {
        return Enum.valueOf(ZoomStyle.class, string);
    }
}

