/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.klighd.DisplayedActionData;
import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.ISourceProxy;
import de.cau.cs.kieler.klighd.IUpdateStrategy;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.IViewerProvider;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.KlighdPreferences;
import de.cau.cs.kieler.klighd.SynthesisOption;
import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.internal.ILayoutRecorder;
import de.cau.cs.kieler.klighd.internal.ISynthesis;
import de.cau.cs.kieler.klighd.internal.util.KlighdInternalProperties;
import de.cau.cs.kieler.klighd.internal.util.SourceModelTrackingAdapter;
import de.cau.cs.kieler.klighd.kgraph.KGraphData;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KGraphPackage;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.kgraph.util.KGraphUtil;
import de.cau.cs.kieler.klighd.syntheses.DuplicatingDiagramSynthesis;
import de.cau.cs.kieler.klighd.util.KlighdProperties;
import de.cau.cs.kieler.klighd.util.KlighdSynthesisProperties;
import de.cau.cs.kieler.klighd.viewers.ContextViewer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.core.util.WrappedException;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class ViewContext
extends MapPropertyHolder {
    private static final long serialVersionUID = -431994394109554393L;
    private transient IWorkbenchPart sourceWorkbenchPart = null;
    private IDiagramWorkbenchPart diagramWorkbenchPart;
    private transient IViewerProvider viewerProvider = null;
    private transient IUpdateStrategy updateStrategy = null;
    private transient ISynthesis diagramSynthesis = null;
    private transient ISynthesis duplicator = null;
    private Object businessModel = null;
    private SourceModelTrackingAdapter tracer = new SourceModelTrackingAdapter();
    private KNode viewModel = this.createViewModel();
    private IViewer viewer = null;
    private ILayoutRecorder layoutRecorder = null;
    private ZoomStyle zoomStyle = KlighdPreferences.getPreferredZoomStyle();
    private final Predicate<ISynthesis> synthesisFilter = this.createSynthesisFilter(null);
    private List<SynthesisOption> synthesisOptions = Lists.newLinkedList();
    private Map<SynthesisOption, Object> synthesisOptionConfig = Maps.newHashMap();
    private final List<ViewContext> childViewContexts = Lists.newLinkedList();

    public ViewContext(IDiagramWorkbenchPart diagramPart, Object inputModel) {
        this.diagramWorkbenchPart = diagramPart;
        this.businessModel = inputModel;
        this.viewModel.eAdapters().add((Object)this.tracer);
    }

    public ViewContext(ViewContext otherContext, Object inputModel) {
        this.businessModel = inputModel;
        if (otherContext != null) {
            this.synthesisOptionConfig.putAll(otherContext.synthesisOptionConfig);
        }
    }

    private KNode createViewModel() {
        return KGraphUtil.createInitializedNode();
    }

    public ViewContext configure() {
        return this.configure((IPropertyHolder)KlighdSynthesisProperties.emptyConfig());
    }

    public ViewContext configure(IPropertyHolder propertyHolder) {
        final KlighdDataManager data = KlighdDataManager.getInstance();
        String synthesisId = (String)propertyHolder.getProperty(KlighdSynthesisProperties.REQUESTED_DIAGRAM_SYNTHESIS);
        this.diagramSynthesis = data.getDiagramSynthesisById(synthesisId);
        if (this.diagramSynthesis == null) {
            if (this.businessModel instanceof ISourceProxy) {
                ISourceProxy proxy = (ISourceProxy)this.businessModel;
                this.diagramSynthesis = proxy.execute(new Function<Object, ISynthesis>(){

                    public ISynthesis apply(Object input) {
                        return (ISynthesis)Iterables.getFirst((Iterable)Iterables.filter(data.getAvailableSyntheses(input.getClass()), ViewContext.this.createSynthesisFilter(input)), null);
                    }
                });
            } else {
                this.diagramSynthesis = (ISynthesis)Iterables.getFirst((Iterable)Iterables.filter(data.getAvailableSyntheses(this.businessModel.getClass()), this.synthesisFilter), null);
            }
        }
        if (this.diagramSynthesis != null) {
            this.synthesisOptions.addAll(this.diagramSynthesis.getDisplayedSynthesisOptions());
            for (SynthesisOption option : this.synthesisOptions) {
                if (this.synthesisOptionConfig.containsKey(option)) continue;
                this.configureOption(option, option.getInitialValue());
            }
            Map config = (Map)propertyHolder.getProperty(KlighdSynthesisProperties.SYNTHESIS_OPTION_CONFIG);
            if (config != null) {
                for (Map.Entry entry : config.entrySet()) {
                    this.configureOption((SynthesisOption)entry.getKey(), entry.getValue());
                }
            }
        }
        String updateStrategyId = (String)propertyHolder.getProperty(KlighdSynthesisProperties.REQUESTED_UPDATE_STRATEGY);
        this.updateStrategy = data.getUpdateStrategyById(updateStrategyId);
        if (this.updateStrategy == null) {
            this.updateStrategy = data.getHighestPriorityUpdateStrategy();
        }
        String viewerProviderId = (String)propertyHolder.getProperty(KlighdSynthesisProperties.REQUESTED_VIEWER_PROVIDER);
        this.viewerProvider = data.getViewerProviderById(viewerProviderId);
        if (this.viewerProvider == null) {
            this.viewerProvider = (IViewerProvider)Iterables.getFirst(data.getAvailableViewerProviders(), null);
        }
        this.copyProperties(propertyHolder);
        return this;
    }

    private Predicate<ISynthesis> createSynthesisFilter(final Object input) {
        return new Predicate<ISynthesis>(){

            public boolean apply(ISynthesis synthesis) {
                Object model = input != null ? input : ViewContext.this.businessModel;
                try {
                    return synthesis.supports(model, ViewContext.this);
                }
                catch (WrappedException e) {
                    Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", e.getMessage(), e.getCause()));
                    return false;
                }
            }
        };
    }

    public IViewer createViewer(ContextViewer parentViewer, Composite parent) {
        if (this.viewerProvider != null) {
            this.viewer = this.viewerProvider.createViewer(parentViewer, parent);
            if (this.viewer instanceof ILayoutRecorder) {
                this.layoutRecorder = (ILayoutRecorder)((Object)this.viewer);
            }
            this.viewer.setModel(this.viewModel, true);
            return this.viewer;
        }
        return null;
    }

    public boolean update() {
        return this.update(null);
    }

    public boolean update(Object sourceModel) {
        return this.update(sourceModel, this.updateStrategy);
    }

    public boolean update(Object sourceModel, IPropertyHolder properties) {
        IUpdateStrategy strategy;
        if (properties != null) {
            String usId = (String)properties.getProperty(KlighdSynthesisProperties.REQUESTED_UPDATE_STRATEGY);
            strategy = KlighdDataManager.getInstance().getUpdateStrategyById(usId);
        } else {
            strategy = null;
        }
        return this.update(sourceModel, strategy);
    }

    public boolean update(Object model, IUpdateStrategy theUpdateStrategy) {
        return this.update(model, theUpdateStrategy, (IPropertyHolder)KlighdSynthesisProperties.emptyConfig());
    }

    public boolean update(Object model, IUpdateStrategy theUpdateStrategy, IPropertyHolder properties) {
        KNode newViewModel;
        IUpdateStrategy chosenUpdateStrategy;
        Map config;
        this.childViewContexts.clear();
        if (model != null && model != this.businessModel) {
            this.businessModel = model;
            if (this.diagramSynthesis == null || !this.synthesisMatches(this.diagramSynthesis, this.businessModel)) {
                this.configure(properties);
            }
        }
        if (properties != null && (config = (Map)properties.getProperty(KlighdSynthesisProperties.SYNTHESIS_OPTION_CONFIG)) != null) {
            for (Map.Entry entry : config.entrySet()) {
                this.configureOption((SynthesisOption)entry.getKey(), entry.getValue());
            }
        }
        Object sourceModel = this.businessModel;
        IUpdateStrategy iUpdateStrategy = chosenUpdateStrategy = theUpdateStrategy != null ? theUpdateStrategy : this.updateStrategy;
        if (!chosenUpdateStrategy.requiresDiagramSynthesisReRun(this)) {
            newViewModel = this.viewModel;
        } else if (this.diagramSynthesis != null) {
            final ISynthesis synthesis = this.diagramSynthesis;
            try {
                if (sourceModel instanceof ISourceProxy) {
                    newViewModel = ((ISourceProxy)sourceModel).execute(new Function<Object, KNode>(){

                        public KNode apply(Object input) {
                            return synthesis.transform(input, ViewContext.this);
                        }
                    });
                }
                newViewModel = synthesis.transform(sourceModel, this);
            }
            catch (Exception e) {
                String msg = "KLighD: Execution of diagram synthesis " + synthesis.getClass().getCanonicalName().toString() + " failed for input model " + sourceModel.toString() + ".";
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e));
                return false;
            }
        } else if (sourceModel instanceof KNode) {
            if (this.duplicator == null) {
                this.duplicator = new DuplicatingDiagramSynthesis();
            }
            newViewModel = this.duplicator.transform(sourceModel, this);
        } else {
            String msg = "KLighD: Could not create a diagram of provided input model " + sourceModel + ".";
            Klighd.handle((IStatus)new Status(2, "de.cau.cs.kieler.klighd", msg));
            return false;
        }
        chosenUpdateStrategy.update(this.viewModel, newViewModel, this);
        KNode clipNode = (KNode)this.getProperty(KlighdProperties.CLIP);
        if (clipNode != null && this.getViewer() != null) {
            this.getViewer().clip(clipNode);
        }
        return true;
    }

    private boolean synthesisMatches(ISynthesis synthesis, Object model) {
        final Class<?> inputType = synthesis.getInputDataType();
        if (model instanceof ISourceProxy) {
            return ((ISourceProxy)model).execute(new Function<Object, Boolean>(){

                public Boolean apply(Object theModel) {
                    return inputType.isAssignableFrom(theModel.getClass());
                }
            });
        }
        return inputType.isAssignableFrom(model.getClass());
    }

    public IDiagramWorkbenchPart getDiagramWorkbenchPart() {
        return this.diagramWorkbenchPart;
    }

    public void setSourceWorkbenchPart(IWorkbenchPart theSourceWorkbenchPart) {
        this.sourceWorkbenchPart = theSourceWorkbenchPart;
    }

    public IWorkbenchPart getSourceWorkbenchPart() {
        return this.sourceWorkbenchPart;
    }

    public ISynthesis getDiagramSynthesis() {
        return this.diagramSynthesis;
    }

    public Object getInputModel() {
        return this.businessModel;
    }

    public IUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public KNode getViewModel() {
        return this.viewModel;
    }

    public IViewer getViewer() {
        return this.viewer;
    }

    public ILayoutRecorder getLayoutRecorder() {
        return this.layoutRecorder;
    }

    public ZoomStyle getZoomStyle() {
        return this.zoomStyle;
    }

    public boolean isZoomToFit() {
        return this.zoomStyle == ZoomStyle.ZOOM_TO_FIT;
    }

    public boolean isZoomToFitContent() {
        return this.zoomStyle == ZoomStyle.ZOOM_TO_FIT_CONTENT;
    }

    public boolean isZoomToFocus() {
        return !this.isZoomToFit() && !this.isZoomToFitContent() && this.zoomStyle == ZoomStyle.getZoomToFocusStyle();
    }

    public boolean isZoomToStay() {
        return this.zoomStyle == ZoomStyle.ZOOM_TO_STAY;
    }

    public void setZoomStyle(ZoomStyle zoomStyle) {
        this.zoomStyle = zoomStyle;
    }

    public void associateSourceTargetPair(Object source, EObject target) {
        if (KGraphPackage.eINSTANCE.getKGraphData().isInstance((Object)target)) {
            ((KGraphData)target).setProperty(KlighdInternalProperties.MODEL_ELEMENT, source);
        } else if (KGraphPackage.eINSTANCE.getKGraphElement().isInstance((Object)target)) {
            ((KGraphElement)target).setProperty(KlighdInternalProperties.MODEL_ELEMENT, source);
        }
    }

    public Object getSourceElement(EObject viewElement) {
        if (viewElement == null) {
            return null;
        }
        return this.tracer.getSourceElement(viewElement);
    }

    public Collection<EObject> getTargetElements(Object element) {
        if (element == null) {
            return Collections.emptyList();
        }
        return this.tracer.getTargetElements(element);
    }

    public <T extends EObject> T getTargetElement(Object element, Class<T> ofType) {
        if (element == null) {
            return null;
        }
        Collection<EObject> targetCollection = this.getTargetElements(element);
        if (targetCollection == null || targetCollection.isEmpty()) {
            return null;
        }
        if (ofType == null) {
            EObject res = (EObject)Iterables.getFirst(targetCollection, null);
            return (T)res;
        }
        return (T)((EObject)Iterables.getFirst((Iterable)Iterables.filter(targetCollection, ofType), null));
    }

    public List<SynthesisOption> getDisplayedSynthesisOptions() {
        return this.synthesisOptions;
    }

    public Object getOptionValue(SynthesisOption option) {
        if (option == null) {
            throw new IllegalArgumentException("KLighD transformation option handling: The transformation " + this.diagramSynthesis + " attempted to evaluate the transformation option \"null\".");
        }
        if (this.synthesisOptionConfig.containsKey(option)) {
            return this.synthesisOptionConfig.get(option);
        }
        return option.getInitialValue();
    }

    public void configureOption(SynthesisOption option, Object value) {
        if (option != null && option.isSeparator()) {
            return;
        }
        if (option == null) {
            throw new IllegalArgumentException("KLighD transformation option handling: Attempted to configure illegal option (" + (option == null ? null : option.getName()) + "), which is not introduced by the transformation " + this.diagramSynthesis + ".");
        }
        if (value == null) {
            this.synthesisOptionConfig.remove(option);
        } else {
            this.synthesisOptionConfig.put(option, value);
        }
    }

    public List<DisplayedActionData> getDisplayedActions() {
        if (this.diagramSynthesis != null) {
            return this.diagramSynthesis.getDisplayedActions();
        }
        return Collections.emptyList();
    }

    public List<Pair<IProperty<?>, List<?>>> getDisplayedLayoutOptions() {
        if (this.diagramSynthesis != null) {
            return this.diagramSynthesis.getDisplayedLayoutOptions();
        }
        return Collections.emptyList();
    }

    public List<? extends IGraphElementVisitor> getAdditionalLayoutConfigs() {
        if (this.diagramSynthesis != null) {
            return this.diagramSynthesis.getAdditionalLayoutConfigs(this.viewModel, this);
        }
        return Collections.emptyList();
    }

    public List<ViewContext> getChildViewContexts(boolean recursive) {
        if (recursive) {
            LinkedList recursiveVCs = Lists.newLinkedList();
            for (ViewContext vc : this.childViewContexts) {
                recursiveVCs.add(vc);
                recursiveVCs.addAll(vc.getChildViewContexts(true));
            }
            return recursiveVCs;
        }
        return this.childViewContexts;
    }

    public void addChildViewContext(ViewContext child) {
        this.childViewContexts.add(child);
    }
}

