/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import com.google.common.base.Strings;
import de.cau.cs.kieler.klighd.IKlighdPreferenceStore;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.internal.preferences.KlighdPlainPreferenceStore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

public final class KlighdPreferences {
    public static final String ANIMATE_LAYOUT = "de.cau.cs.kieler.klighd.preferences.animateLayout";
    public static final boolean ANIMATE_LAYOUT_DEFAULT = true;
    public static final String ZOOM_STYLE = "de.cau.cs.kieler.klighd.preferences.zoomStyle";
    public static final String ZOOM_STYLE_DEFAULT;
    public static final String ZOOM_TO_FOCUS_STYLE = "de.cau.cs.kieler.klighd.preferences.zoomToFocusStyle";
    public static final String ZOOM_TO_FOCUS_STYLE_DEFAULT;
    public static final String ZOOM_ON_WORKBENCHPART_CHANGE = "de.cau.cs.kieler.klighd.preferences.zoomOnWorkBenchPartChange";
    public static final boolean ZOOM_ON_WORKBENCHPART_CHANGE_DEFAULT = false;
    public static final String MAGNIFICATION_LENS_ENABLED = "de.cau.cs.kieler.klighd.preferences.magnificationLensEnabled";
    public static final boolean MAGNIFICATION_LENS_ENABLED_DEFAULT = true;
    public static final String MAGNIFICATION_LENS_WIDTH = "de.cau.cs.kieler.klighd.preferences.magnificationLensWidth";
    public static final int MAGNIFICATION_LENS_WIDTH_DEFAULT = 400;
    public static final String MAGNIFICATION_LENS_HEIGHT = "de.cau.cs.kieler.klighd.preferences.magnificationLensHeight";
    public static final int MAGNIFICATION_LENS_HEIGHT_DEFAULT = 400;
    public static final String MAGNIFICATION_LENS_SCALE = "de.cau.cs.kieler.klighd.preferences.magnificationLensScale";
    public static final int MAGNIFICATION_LENS_SCALE_DEFAULT = 200;
    public static final String ADVANCED_PANNING_MODE = "de.cau.cs.kieler.klighd.preferences.advancedPanning";
    public static final boolean ADVANCED_PANNING_MODE_DEFAULT = false;
    public static final String EXPAND_SIDE_BAR = "de.cau.cs.kieler.klighd.preferences.expandSideBar";
    public static final boolean EXPAND_SIDE_BAR_DEFAULT = true;
    public static final String SHOW_ZOOM_CONFIG_BUTTONS = "de.cau.cs.kieler.klighd.preferences.showZoomConfigButtons";
    public static final boolean SHOW_ZOOM_CONFIG_BUTTONS_DEFAULT = true;
    public static final String USER_ZOOMING_MINIMAL_LEVEL = "de.cau.cs.kieler.klighd.preferences.userZoomingMinimalLevel";
    public static final Number USER_ZOOMING_MINIMAL_LEVEL_DEFAULT;
    public static final String USER_ZOOMING_MAXIMAL_LEVEL = "de.cau.cs.kieler.klighd.preferences.userZoomingMaximalLevel";
    public static final Number USER_ZOOMING_MAXIMAL_LEVEL_DEFAULT;
    public static final IKlighdPreferenceStore STORE;

    static {
        Bundle klighdUi;
        ZOOM_STYLE_DEFAULT = ZoomStyle.ZOOM_TO_FIT.name();
        ZOOM_TO_FOCUS_STYLE_DEFAULT = ZoomStyle.ZOOM_TO_FOCUS_OR_INCREASE_TO_FIT.name();
        USER_ZOOMING_MINIMAL_LEVEL_DEFAULT = null;
        USER_ZOOMING_MAXIMAL_LEVEL_DEFAULT = null;
        IKlighdPreferenceStore theStore = new KlighdPlainPreferenceStore();
        if (Klighd.IS_PLATFORM_RUNNING && (klighdUi = Platform.getBundle((String)"de.cau.cs.kieler.klighd.ui")) != null) {
            try {
                Class clazz = klighdUi.loadClass("de.cau.cs.kieler.klighd.ui.internal.preferences.KlighdPlatformPreferenceStore");
                theStore = (IKlighdPreferenceStore)clazz.getDeclaredField("INSTANCE").get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", "Accessing the JFace-based preference store failed with an exception.", (Throwable)e));
            }
        }
        STORE = theStore;
    }

    private KlighdPreferences() {
    }

    public static IKlighdPreferenceStore getPreferenceStore() {
        return STORE;
    }

    public static boolean isAnimateLayout() {
        return STORE.getBoolean(ANIMATE_LAYOUT);
    }

    public static ZoomStyle getPreferredZoomStyle() {
        return ZoomStyle.valueOf(STORE.getString(ZOOM_STYLE));
    }

    public static ZoomStyle getZoomToFocusStyle() {
        return ZoomStyle.valueOf(STORE.getString(ZOOM_TO_FOCUS_STYLE));
    }

    public static boolean isAdvancedPanningMode() {
        return STORE.getBoolean(ADVANCED_PANNING_MODE);
    }

    public static boolean isExpandSideBar() {
        return STORE.getBoolean(EXPAND_SIDE_BAR);
    }

    public static boolean isShowZoomConfigButtons() {
        return STORE.getBoolean(SHOW_ZOOM_CONFIG_BUTTONS);
    }

    public static boolean isMagnificationLensEnabled() {
        return STORE.getBoolean(MAGNIFICATION_LENS_ENABLED);
    }

    public static boolean isZoomOnWorkbenchpartChange() {
        return STORE.getBoolean(ZOOM_ON_WORKBENCHPART_CHANGE);
    }

    public static double getUserZoomingMinimalLevel(double defaultValue) {
        String config = STORE.getString(USER_ZOOMING_MINIMAL_LEVEL);
        return Strings.isNullOrEmpty((String)config) ? defaultValue : STORE.getDouble(USER_ZOOMING_MINIMAL_LEVEL);
    }

    public static double getUserZoomingMaximalLevel(double defaultValue) {
        String config = STORE.getString(USER_ZOOMING_MAXIMAL_LEVEL);
        return Strings.isNullOrEmpty((String)config) ? defaultValue : STORE.getDouble(USER_ZOOMING_MAXIMAL_LEVEL);
    }

    public static void registerPrefChangeListener(Widget widget, final IEclipsePreferences.IPreferenceChangeListener listener) {
        STORE.addPreferenceChangeListener(listener);
        if (widget == null) {
            return;
        }
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                STORE.removePreferenceChangeListener(listener);
                e.widget.removeDisposeListener((DisposeListener)this);
            }
        });
    }
}

