/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import com.google.common.base.Throwables;
import org.eclipse.core.runtime.IStatus;

public interface IKlighdStatusManager {
    public static final int NONE = 0;
    public static final int LOG = 1;
    public static final int SHOW = 2;
    public static final int BLOCK = 4;

    public void handle(IStatus var1, int var2);

    public static class Impl
    implements IKlighdStatusManager {
        private static Impl instance = new Impl();

        private Impl() {
        }

        static IKlighdStatusManager getInstance() {
            return instance;
        }

        @Override
        public void handle(IStatus status, int style) {
            String msg;
            String prefix;
            if (status == null) {
                throw new IllegalArgumentException("IStatusManager.Impl: Argument 'status' of 'handle(IStatus, int)' must not be 'null'!");
            }
            switch (status.getSeverity()) {
                case 4: {
                    prefix = "ERROR: ";
                    break;
                }
                case 2: {
                    prefix = "WARNING: ";
                    break;
                }
                case 1: {
                    prefix = "INFO: ";
                    break;
                }
                default: {
                    return;
                }
            }
            String string = msg = status.getException() == null ? status.getMessage() : status.getException().getMessage();
            if (msg != null && !msg.isEmpty()) {
                System.out.println(String.valueOf(prefix) + msg);
            }
            if (status.getException() != null) {
                System.out.println(Throwables.getStackTraceAsString((Throwable)status.getException()));
            }
        }
    }
}

