/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import de.cau.cs.kieler.klighd.KlighdConstants;
import de.cau.cs.kieler.klighd.ViewContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;

public interface IDiagramExporter {
    public IStatus export(Control var1, ExportData var2);

    public static class ExportData {
        private final ViewContext viewContext;
        private final String format;
        private final OutputStream stream;
        private final IPath path;
        private final boolean isWorkspacePath;
        private final boolean isCameraViewport;
        private final boolean applyCameraZoomLevel;
        private final int scale;
        private final boolean isTextAsShapes;
        private final boolean isEmbedFonts;
        private final boolean isSetTextLengths;
        private final String description;
        private final String css;
        private final String additionalRootData;
        private final TilingData tilingInfo;
        private final boolean transparentBackground;
        private final RGB backgroundColor;

        private ExportData(ExportDataBuilder builder) {
            this.viewContext = builder.viewContext;
            this.format = builder.format;
            this.stream = builder.stream;
            this.path = builder.path;
            this.isWorkspacePath = builder.isWorkspacePath;
            this.isCameraViewport = builder.isCameraViewport;
            this.applyCameraZoomLevel = builder.applyCameraZoomLevel;
            this.scale = builder.scale;
            this.isTextAsShapes = builder.isTextAsShapes;
            this.isEmbedFonts = builder.isEmbedFonts;
            this.isSetTextLengths = builder.isSetTextLengths;
            this.description = builder.description;
            this.css = builder.css;
            this.additionalRootData = builder.additionalRootData;
            this.tilingInfo = builder.tilingInfo;
            this.transparentBackground = builder.transparentBackground;
            this.backgroundColor = builder.backgroundColor;
        }

        public ViewContext viewContext() {
            return this.viewContext;
        }

        public String format() {
            return this.format;
        }

        public IPath path() {
            return this.path;
        }

        public boolean workspacePath() {
            return this.isWorkspacePath;
        }

        public boolean cameraViewport() {
            return this.isCameraViewport;
        }

        public boolean applyCameraZoomLevel() {
            return this.applyCameraZoomLevel;
        }

        public int scale() {
            return this.scale;
        }

        public boolean textAsShapes() {
            return this.isTextAsShapes;
        }

        public boolean embedFonts() {
            return this.isEmbedFonts;
        }

        public boolean setTextLengths() {
            return this.isSetTextLengths;
        }

        public String description() {
            return this.description;
        }

        public String css() {
            return this.css;
        }

        public String additionalRootData() {
            return this.additionalRootData;
        }

        public TilingData tilingInfo() {
            return this.tilingInfo;
        }

        public boolean transparentBackground() {
            return this.transparentBackground;
        }

        public RGB backgroundColor() {
            return this.backgroundColor;
        }

        public OutputStream createOutputStream() throws IOException {
            if (this.stream != null) {
                return this.stream;
            }
            return this.createOutputStream(this.path);
        }

        public OutputStream createOutputStream(int row, int col) throws IOException {
            if (this.path == null) {
                throw new IllegalStateException("Export not tileable.");
            }
            String ext = this.path.getFileExtension();
            String name = String.valueOf(this.path.removeFileExtension().lastSegment()) + "_" + row + "-" + col;
            IPath aPath = this.path.removeLastSegments(1).append(name).addFileExtension(ext);
            return this.createOutputStream(aPath);
        }

        private OutputStream createOutputStream(IPath aPath) throws IOException {
            if (this.isWorkspacePath) {
                URI fileURI = URI.createPlatformResourceURI((String)aPath.toOSString(), (boolean)true);
                OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(fileURI);
                return outputStream;
            }
            File file = new File(aPath.toString());
            FileOutputStream outputStream = new FileOutputStream(file);
            return outputStream;
        }
    }

    public static class ExportDataBuilder {
        private final ViewContext viewContext;
        private final String format;
        private final OutputStream stream;
        private final IPath path;
        private final boolean isWorkspacePath;
        private boolean isCameraViewport = false;
        private boolean applyCameraZoomLevel = false;
        private int scale = 1;
        private boolean isTextAsShapes = false;
        private boolean isEmbedFonts = false;
        private boolean isSetTextLengths = false;
        private String description = null;
        private String css = null;
        private String additionalRootData = null;
        private TilingData tilingInfo = TilingData.createNonTiledData();
        private boolean transparentBackground = false;
        private RGB backgroundColor = KlighdConstants.WHITE;

        public ExportDataBuilder(ViewContext viewContext, String format, OutputStream stream) {
            this.viewContext = viewContext;
            this.format = format;
            this.stream = stream;
            this.path = null;
            this.isWorkspacePath = false;
        }

        public ExportDataBuilder(ViewContext viewContext, String format, IPath path, boolean isWorkspacePath) {
            this.viewContext = viewContext;
            this.format = format;
            this.stream = null;
            this.path = path;
            this.isWorkspacePath = isWorkspacePath;
        }

        public ExportDataBuilder cameraViewport(boolean cameraViewport) {
            this.isCameraViewport = cameraViewport;
            return this;
        }

        public ExportDataBuilder applyCameraZoomLevel(boolean applyCameraZoomLevel) {
            this.applyCameraZoomLevel = applyCameraZoomLevel;
            return this;
        }

        public ExportDataBuilder scale(int theScale) {
            this.scale = theScale;
            return this;
        }

        public ExportDataBuilder textAsShapes(boolean textAsShapes) {
            this.isTextAsShapes = textAsShapes;
            return this;
        }

        public ExportDataBuilder embedFonts(boolean embedFonts) {
            this.isEmbedFonts = embedFonts;
            return this;
        }

        public ExportDataBuilder setTextLengths(boolean setTextLengths) {
            this.isSetTextLengths = setTextLengths;
            return this;
        }

        public ExportDataBuilder description(String theDescription) {
            this.description = theDescription;
            return this;
        }

        public ExportDataBuilder css(String theCss) {
            this.css = theCss;
            return this;
        }

        public ExportDataBuilder additionalRootData(String theAdditionalRootData) {
            this.additionalRootData = theAdditionalRootData;
            return this;
        }

        public ExportDataBuilder tilingInfo(TilingData theTilingInfo) {
            if (this.path == null && !TilingData.NON_TILED.equals(theTilingInfo)) {
                throw new IllegalStateException("Tiling not supported with stream export objects");
            }
            this.tilingInfo = theTilingInfo;
            return this;
        }

        public ExportDataBuilder transparentBackground(boolean theTransparentBackground) {
            this.transparentBackground = theTransparentBackground;
            return this;
        }

        public ExportDataBuilder backgroundColor(RGB theBackgroundColor) {
            this.backgroundColor = theBackgroundColor;
            return this;
        }

        public ExportData build() {
            return new ExportData(this);
        }
    }

    public static final class TilingData {
        public static final TilingData NON_TILED = new TilingData();
        public final int maxWidth;
        public final int maxHeight;
        public final int cols;
        public final int rows;
        public final boolean isTiled;
        public final boolean isMaxsize;

        private TilingData(int maxWidth, int maxHeight, int rows, int cols, boolean tiled, boolean isMaxsize) {
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.rows = rows;
            this.cols = cols;
            this.isTiled = tiled;
            this.isMaxsize = isMaxsize;
        }

        private TilingData() {
            this(-1, -1, 1, 1, false, false);
        }

        public static TilingData createNonTiledData() {
            return NON_TILED;
        }

        public static TilingData createTiledData(int rows, int cols) {
            return new TilingData(-1, -1, Math.max(1, rows), Math.max(1, cols), rows > 1 || cols > 1, false);
        }

        public static TilingData createMaxSizeTiledData(int maxWidth, int maxHeight) {
            return new TilingData(Math.max(1, maxWidth), Math.max(1, maxHeight), 1, 1, true, true);
        }
    }
}

