/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import de.cau.cs.kieler.klighd.IKlighdPreferenceStore;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.KlighdPreferences;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KGraphPackage;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.Trigger;
import de.cau.cs.kieler.klighd.util.ModelingUtil;
import de.cau.cs.kieler.klighd.viewers.ContextViewer;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Point;

public interface IAction {
    public ActionResult execute(ActionContext var1);

    public static class ActionContext {
        private IViewer viewer = null;
        private Trigger trigger = null;
        private KGraphElement kgraphElement = null;
        private KRendering rendering = null;

        public ActionContext(IViewer v, Trigger t, KGraphElement kge, KRendering r) {
            this.viewer = v;
            this.trigger = t;
            this.kgraphElement = kge;
            this.rendering = r;
        }

        public IViewer getActiveViewer() {
            return this.viewer;
        }

        public ContextViewer getContextViewer() {
            return this.viewer.getContextViewer();
        }

        public ViewContext getViewContext() {
            return this.viewer.getViewContext();
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public KGraphElement getKGraphElement() {
            if (this.kgraphElement == null) {
                this.kgraphElement = (KGraphElement)ModelingUtil.eContainerOfType((EObject)this.rendering, KGraphPackage.eINSTANCE.getKGraphElement());
            }
            return this.kgraphElement;
        }

        public KNode getKNode() {
            return (KNode)ModelingUtil.eContainerOrSelfOfType((EObject)this.getKGraphElement(), KGraphPackage.eINSTANCE.getKNode());
        }

        public KRendering getKRendering() {
            return this.rendering;
        }

        public <T> T getDomainElement(KNode viewElement) {
            return (T)this.viewer.getViewContext().getSourceElement((EObject)viewElement);
        }

        public Point2D getDiagramRelativeMousePos() {
            return null;
        }

        public Point2D getCanvasRelativeMousePos() {
            return null;
        }

        public Point getControlRelativeMousePos() {
            return null;
        }

        public Point getDisplayRelativeMousePos() {
            return null;
        }
    }

    public static final class ActionResult {
        private static final IKlighdPreferenceStore STORE = KlighdPreferences.getPreferenceStore();
        private List<LayoutConfigurator> layoutConfigs = null;
        private boolean needsSynthesis = false;
        private boolean actionPerformed = true;
        private Boolean animateLayout = null;
        private Boolean zoomToActualSize = null;
        private Boolean zoomToFit = null;
        private Boolean zoomToFitContent = null;
        private Boolean zoomToFocus = null;
        private Boolean zoomToStay = null;
        private KGraphElement focus = null;
        private KVector previousPosition = null;

        private ActionResult(boolean theActionPerformed) {
            this.actionPerformed = theActionPerformed;
        }

        private ActionResult(boolean theActionPerformed, List<LayoutConfigurator> theConfigs) {
            this.actionPerformed = theActionPerformed;
            this.layoutConfigs = theConfigs;
        }

        public static ActionResult createResult(boolean actionRequiresLayout, LayoutConfigurator ... config) {
            if (actionRequiresLayout) {
                return new ActionResult(actionRequiresLayout, Arrays.asList(config));
            }
            return new ActionResult(actionRequiresLayout).dontZoom();
        }

        public static ActionResult createResult(boolean actionRequiresLayout) {
            if (actionRequiresLayout) {
                return new ActionResult(actionRequiresLayout);
            }
            return new ActionResult(actionRequiresLayout).dontZoom();
        }

        public ActionResult doSynthesis() {
            this.needsSynthesis = true;
            this.actionPerformed = true;
            return this;
        }

        public ActionResult doAnimateLayout() {
            this.animateLayout = true;
            return this;
        }

        public ActionResult dontAnimateLayout() {
            this.animateLayout = false;
            return this;
        }

        public ActionResult doZoomToActualSize() {
            this.zoomToActualSize = true;
            this.zoomToFit = null;
            this.zoomToFitContent = null;
            this.zoomToFocus = null;
            this.zoomToStay = null;
            return this;
        }

        public ActionResult dontZoomToActualSize() {
            this.zoomToActualSize = false;
            return this;
        }

        public ActionResult doZoomToFit() {
            this.zoomToActualSize = null;
            this.zoomToFit = true;
            this.zoomToFitContent = null;
            this.zoomToFocus = null;
            this.zoomToStay = null;
            return this;
        }

        public ActionResult doZoomToFitContent() {
            this.zoomToActualSize = null;
            this.zoomToFit = null;
            this.zoomToFitContent = true;
            this.zoomToFocus = null;
            this.zoomToStay = null;
            return this;
        }

        public ActionResult dontZoomToFit() {
            this.zoomToFit = false;
            return this;
        }

        public ActionResult doZoomToFocus() {
            this.zoomToActualSize = null;
            this.zoomToFit = null;
            this.zoomToFitContent = null;
            this.zoomToFocus = true;
            this.zoomToStay = null;
            return this;
        }

        public ActionResult doZoomToFocus(KNode focusNode) {
            this.zoomToActualSize = null;
            this.zoomToFit = null;
            this.zoomToFitContent = null;
            this.zoomToFocus = true;
            this.zoomToStay = null;
            this.focus = focusNode;
            return this;
        }

        public ActionResult dontZoomToFocus() {
            this.zoomToFocus = false;
            return this;
        }

        public ActionResult doZoomToStay(KVector previousPosition, KGraphElement focusElement) {
            this.zoomToActualSize = null;
            this.zoomToFit = null;
            this.zoomToFitContent = null;
            this.zoomToFocus = null;
            this.zoomToStay = true;
            this.previousPosition = previousPosition;
            this.focus = focusElement;
            return this;
        }

        public ActionResult dontZoomZoStay() {
            this.zoomToStay = false;
            return this;
        }

        public ActionResult dontZoom() {
            this.zoomToActualSize = false;
            this.zoomToFit = false;
            this.zoomToFitContent = false;
            this.zoomToFocus = false;
            this.zoomToStay = false;
            return this;
        }

        public List<LayoutConfigurator> getLayoutConfigs() {
            return this.layoutConfigs;
        }

        public boolean getNeedsSynthesis() {
            return this.needsSynthesis;
        }

        public boolean getActionPerformed() {
            return this.actionPerformed;
        }

        public boolean getAnimateLayout() {
            return this.animateLayout != null ? this.animateLayout.booleanValue() : STORE.getBoolean("de.cau.cs.kieler.klighd.preferences.animateLayout");
        }

        public Boolean getZoomToActualSize() {
            return this.zoomToActualSize;
        }

        public Boolean getZoomToFit() {
            return this.zoomToFit;
        }

        public Boolean getZoomToFitContent() {
            return this.zoomToFitContent;
        }

        public Boolean getZoomToFocus() {
            return this.zoomToFocus;
        }

        public Boolean getZoomToStay() {
            return this.zoomToStay;
        }

        public KNode getFocusNode() {
            if (this.focus instanceof KNode) {
                return (KNode)this.focus;
            }
            return null;
        }

        public KGraphElement getFocusElement() {
            return this.focus;
        }

        public KVector getPreviousPosition() {
            return this.previousPosition;
        }
    }
}

