/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.viewers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import de.cau.cs.kieler.klighd.IKlighdSelection;
import de.cau.cs.kieler.klighd.IViewChangeListener;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.KlighdTreeSelection;
import de.cau.cs.kieler.klighd.ViewChangeType;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.internal.IDiagramOutlinePage;
import de.cau.cs.kieler.klighd.internal.ILayoutRecorder;
import de.cau.cs.kieler.klighd.internal.util.KlighdInternalProperties;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingPackage;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.util.KlighdPredicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ContextViewer
implements IViewer,
ILayoutRecorder,
ISelectionProvider,
IDiagramOutlinePage.Provider {
    private Composite diagramComposite;
    private IViewer currentViewer;
    private ViewContext currentViewContext = null;
    private ILayoutRecorder layoutRecorder;
    private static final String NON_DISPLAY_ERROR_MSG = "KLighD: Application attempted to traverse an Iterator provided by IViewer.##. Evaluations of those Iterators must be performed by the display (UI) thread for integrity reasons.";
    private final Function<Object, EObject> getViews = new Function<Object, EObject>(){

        public EObject apply(Object semanticElement) {
            Object diagramElement = ContextViewer.this.getViewContext().getTargetElement(semanticElement, null);
            return KlighdPredicates.isSelectable().apply(diagramElement) ? diagramElement : null;
        }
    };
    private static final Function<EObject, Iterable<KRendering>> AS_RENDERING = new Function<EObject, Iterable<KRendering>>(){

        public Iterable<KRendering> apply(EObject eo) {
            if (KRenderingPackage.eINSTANCE.getKRendering().isInstance((Object)eo)) {
                return Collections.singleton((KRendering)eo);
            }
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)eo.eContents(), KRendering.class));
        }
    };
    private KlighdTreeSelection diagramSelection = KlighdTreeSelection.EMPTY;
    private IKlighdSelection selection = this.diagramSelection;
    private Set<ISelectionChangedListener> selectionListeners = Sets.newLinkedHashSet();

    public ContextViewer(Composite parent) {
        this.diagramComposite = parent;
    }

    protected synchronized void setViewer(IViewer viewer) {
        IViewer objViewer;
        if (this.currentViewer != null) {
            this.currentViewer.getControl().dispose();
            this.currentViewer = null;
        }
        this.currentViewer = objViewer = viewer;
        this.diagramComposite.layout();
        if (this.currentViewer instanceof ILayoutRecorder) {
            this.layoutRecorder = (ILayoutRecorder)((Object)this.currentViewer);
        }
    }

    @Override
    public IDiagramOutlinePage getDiagramOutlinePage() {
        if (this.currentViewer instanceof IDiagramOutlinePage.Provider) {
            return ((IDiagramOutlinePage.Provider)((Object)this.currentViewer)).getDiagramOutlinePage();
        }
        return null;
    }

    @Override
    public void startRecording() {
        if (this.layoutRecorder != null) {
            this.layoutRecorder.startRecording();
        }
    }

    @Override
    public void stopRecording(int animationTime) {
        if (this.layoutRecorder != null) {
            this.layoutRecorder.stopRecording(animationTime);
        }
    }

    @Override
    public void stopRecording(ZoomStyle zoomStyle, KGraphElement focusElement, int animationTime) {
        this.stopRecording(zoomStyle, focusElement, null, animationTime);
    }

    @Override
    public void stopRecording(ZoomStyle zoomStyle, KGraphElement focusElement, KVector previousPosition, int animationTime) {
        if (this.layoutRecorder != null) {
            this.layoutRecorder.stopRecording(zoomStyle, focusElement, previousPosition, animationTime);
        }
    }

    @Override
    public ContextViewer getContextViewer() {
        return this;
    }

    @Override
    public void setModel(Object model) {
        this.setModel(model, false);
    }

    @Override
    public synchronized void setModel(Object model, boolean sync) {
        if (model instanceof ViewContext) {
            ViewContext viewContext;
            this.currentViewContext = viewContext = (ViewContext)((Object)model);
            this.setViewer(viewContext.createViewer(this, this.diagramComposite));
            this.notifySelectionListeners(new KlighdTreeSelection(this.currentViewContext, new TreePath[0]));
        }
    }

    @Override
    public ViewContext getViewContext() {
        return this.currentViewContext;
    }

    @Override
    public Control getControl() {
        return this.currentViewer != null ? this.currentViewer.getControl() : null;
    }

    public ViewContext getCurrentViewContext() {
        return this.currentViewContext;
    }

    public IViewer getActiveViewer() {
        return this.currentViewer;
    }

    @Override
    public void addViewChangeListener(IViewChangeListener listener, ViewChangeType ... eventTypes) {
        if (this.currentViewer != null) {
            if (listener != null) {
                this.currentViewer.addViewChangeListener(listener, eventTypes);
            }
        } else {
            throw new RuntimeException("KLighD: Registering the " + listener.getClass().getCanonicalName() + " is not possible, since the actual diagram viewer is not initialized yet.");
        }
    }

    @Override
    public void addViewChangeListener(IViewChangeListener listener, EnumSet<ViewChangeType> eventTypes) {
        if (this.currentViewer != null) {
            if (listener != null) {
                this.currentViewer.addViewChangeListener(listener, eventTypes);
            }
        } else {
            throw new RuntimeException("KLighD: Registering the " + listener.getClass().getCanonicalName() + " is not possible, since the actual diagram viewer is not initialized yet.");
        }
    }

    @Override
    public void removeViewChangeListener(IViewChangeListener listener) {
        if (listener != null && this.currentViewer != null) {
            this.currentViewer.removeViewChangeListener(listener);
        }
    }

    @Override
    public boolean isDisplayed(Object semanticElement, boolean checkParents) {
        KNode diagramNode = this.getViewContext().getTargetElement(semanticElement, KNode.class);
        if (diagramNode instanceof KGraphElement) {
            return this.currentViewer.isDisplayed((KGraphElement)diagramNode, checkParents);
        }
        return false;
    }

    @Override
    public boolean isDisplayed(KGraphElement diagramElement, boolean checkParents) {
        return this.currentViewer.isDisplayed(diagramElement, checkParents);
    }

    @Override
    public boolean isVisible(Object semanticElement, boolean checkParents) {
        KNode diagramNode = this.getViewContext().getTargetElement(semanticElement, KNode.class);
        if (diagramNode instanceof KGraphElement) {
            return this.currentViewer.isVisible((KGraphElement)diagramNode, checkParents);
        }
        return false;
    }

    @Override
    public boolean isVisible(KGraphElement diagramElement, boolean checkParents) {
        return this.currentViewer.isVisible(diagramElement, checkParents);
    }

    private static void checkValidThread(String msgReplacement) {
        if (Klighd.IS_PLATFORM_RUNNING && PlatformUI.isWorkbenchRunning() && Display.getCurrent() == null) {
            throw new RuntimeException(NON_DISPLAY_ERROR_MSG.replace("##", msgReplacement));
        }
    }

    @Override
    public Iterator<KNode> getVisibleDiagramNodes() {
        KNode clip;
        final IViewer activeViewer = this.getActiveViewer();
        if (!activeViewer.isVisible((KGraphElement)(clip = activeViewer.getClip()), false)) {
            return Collections.emptyIterator();
        }
        return new AbstractTreeIterator<KNode>(clip){
            private static final long serialVersionUID = 1021356500841593549L;

            protected Iterator<? extends KNode> getChildren(Object object) {
                ContextViewer.checkValidThread("getVisibleDiagramNodes()");
                return Iterators.filter((Iterator)((KNode)object).getChildren().iterator(), (Predicate)new Predicate<KNode>(){

                    public boolean apply(KNode input) {
                        return activeViewer.isVisible((KGraphElement)input, false);
                    }
                });
            }
        };
    }

    @Override
    public Iterator<KGraphElement> getVisibleDiagramElements() {
        KNode clip;
        IViewer activeViewer = this.getActiveViewer();
        if (!activeViewer.isVisible((KGraphElement)(clip = activeViewer.getClip()), false)) {
            return Collections.emptyIterator();
        }
        return new AbstractTreeIterator<KGraphElement>((KGraphElement)clip, activeViewer){
            private static final long serialVersionUID = 1021356500841593549L;
            private Predicate<EObject> filter;
            {
                this.filter = new Predicate<EObject>(){

                    public boolean apply(EObject input) {
                        return input instanceof KGraphElement && iViewer.isVisible((KGraphElement)input, false);
                    }
                };
            }

            protected Iterator<? extends KGraphElement> getChildren(Object object) {
                ContextViewer.checkValidThread("getVisibleDiagramElements()");
                Iterator candidates = object instanceof KNode ? Iterators.concat((Iterator)((EObject)object).eContents().iterator(), (Iterator)((KNode)object).getIncomingEdges().iterator()) : ((EObject)object).eContents().iterator();
                UnmodifiableIterator res = Iterators.filter((Iterator)candidates, this.filter);
                return res;
            }
        };
    }

    @Override
    public void zoomToFocus(Object semanticElement, int duration) {
        KNode diagramNode = this.getViewContext().getTargetElement(semanticElement, KNode.class);
        if (diagramNode instanceof KNode) {
            this.currentViewer.zoomToFocus(diagramNode, duration);
        }
    }

    @Override
    public void zoomToFocus(KNode diagramElement, int duration) {
        this.currentViewer.zoomToFocus(diagramElement, duration);
    }

    @Override
    public void zoomToLevel(float zoomLevel, int duration) {
        if (this.currentViewer != null) {
            this.currentViewer.zoomToLevel(zoomLevel, duration);
        }
    }

    @Override
    public void zoom(ZoomStyle style, int duration) {
        if (this.currentViewer != null) {
            this.currentViewer.zoom(style, duration);
        }
    }

    @Override
    public float getZoomLevel() {
        if (this.currentViewer != null) {
            return this.currentViewer.getZoomLevel();
        }
        return 1.0f;
    }

    @Override
    public boolean isExpanded(Object semanticElement) {
        KNode diagramNode = this.getViewContext().getTargetElement(semanticElement, KNode.class);
        if (diagramNode instanceof KNode) {
            return this.currentViewer.isExpanded(diagramNode);
        }
        return false;
    }

    @Override
    public boolean isExpanded(KNode diagramElement) {
        return this.currentViewer.isExpanded(diagramElement);
    }

    @Override
    public void collapse(Object semanticElement) {
        KNode diagramNode = this.getViewContext().getTargetElement(semanticElement, KNode.class);
        if (diagramNode instanceof KNode) {
            this.currentViewer.collapse(diagramNode);
        }
    }

    @Override
    public void collapse(KNode diagramElement) {
        this.currentViewer.collapse(diagramElement);
    }

    @Override
    public void expand(Object semanticElement) {
        KNode diagramNode = this.getViewContext().getTargetElement(semanticElement, KNode.class);
        if (diagramNode instanceof KNode) {
            this.currentViewer.expand(diagramNode);
        }
    }

    @Override
    public void expand(KNode diagramElement) {
        this.currentViewer.expand(diagramElement);
    }

    @Override
    public void toggleExpansion(Object semanticElement) {
        KNode diagramNode = this.getViewContext().getTargetElement(semanticElement, KNode.class);
        if (diagramNode instanceof KNode) {
            this.currentViewer.toggleExpansion(diagramNode);
        }
    }

    @Override
    public void toggleExpansion(KNode diagramElement) {
        this.currentViewer.toggleExpansion(diagramElement);
    }

    @Override
    public void hide(Object semanticElement) {
        KGraphElement diagramElement = this.getViewContext().getTargetElement(semanticElement, KGraphElement.class);
        if (diagramElement instanceof KGraphElement) {
            this.currentViewer.hide(diagramElement);
        }
    }

    @Override
    public void hide(KGraphElement diagramElement) {
        this.currentViewer.hide(diagramElement);
    }

    @Override
    public void show(Object semanticElement) {
        KGraphElement diagramElement = this.getViewContext().getTargetElement(semanticElement, KGraphElement.class);
        if (diagramElement instanceof KGraphElement) {
            this.currentViewer.show(diagramElement);
        }
    }

    @Override
    public void show(KGraphElement diagramElement) {
        this.currentViewer.show(diagramElement);
    }

    @Override
    public void clip(Object semanticElement) {
        if (semanticElement == null) {
            this.currentViewer.clip(this.getViewContext().getViewModel());
            return;
        }
        KGraphElement diagramElement = this.getViewContext().getTargetElement(semanticElement, KGraphElement.class);
        if (diagramElement instanceof KNode) {
            this.currentViewer.clip((KNode)diagramElement);
        }
    }

    @Override
    public void clip(Object semanticElement, Boolean hideClipNodePorts, Boolean hideClipNodeLabels) {
        if (semanticElement == null) {
            this.currentViewer.clip(this.getViewContext().getViewModel(), hideClipNodePorts, hideClipNodeLabels);
            return;
        }
        KGraphElement diagramElement = this.getViewContext().getTargetElement(semanticElement, KGraphElement.class);
        if (diagramElement instanceof KNode) {
            this.currentViewer.clip((KNode)diagramElement, hideClipNodePorts, hideClipNodeLabels);
        }
    }

    @Override
    public void clip(KNode diagramElement) {
        if (diagramElement == null) {
            this.currentViewer.clip(this.getViewContext().getViewModel());
        } else {
            this.currentViewer.clip(diagramElement);
        }
    }

    @Override
    public void clip(KNode diagramElement, Boolean hideClipNodePorts, Boolean hideClipNodeLabels) {
        if (diagramElement == null) {
            this.currentViewer.clip(this.getViewContext().getViewModel(), hideClipNodePorts, hideClipNodeLabels);
        } else {
            this.currentViewer.clip(diagramElement, hideClipNodePorts, hideClipNodeLabels);
        }
    }

    @Override
    public KNode getClip() {
        return this.currentViewer.getClip();
    }

    @Override
    public void scale(Object semanticElement, double scale) {
        KGraphElement diagramElement = this.getViewContext().getTargetElement(semanticElement, KGraphElement.class);
        if (diagramElement instanceof KNode) {
            this.currentViewer.scale((KNode)diagramElement, scale);
        }
    }

    @Override
    public void scale(KNode diagramElement, double scale) {
        this.currentViewer.scale(diagramElement, scale);
    }

    @Override
    public double getScale(Object semanticElement) {
        KNode diagramNode = this.getViewContext().getTargetElement(semanticElement, KNode.class);
        if (diagramNode instanceof KNode) {
            return this.currentViewer.getScale(diagramNode);
        }
        return 1.0;
    }

    @Override
    public double getScale(KNode diagramElement) {
        return this.currentViewer.getScale(diagramElement);
    }

    @Override
    public void reveal(Object semanticElement, int duration) {
        KGraphElement diagramElement = this.getViewContext().getTargetElement(semanticElement, KGraphElement.class);
        if (diagramElement instanceof KGraphElement) {
            this.currentViewer.centerOn(diagramElement, duration);
        }
    }

    @Override
    public void reveal(KGraphElement diagramElement, int duration) {
        if (this.currentViewer != null) {
            this.currentViewer.reveal(diagramElement, duration);
        }
    }

    @Override
    public void centerOn(Object semanticElement, int duration) {
        KGraphElement diagramElement = this.getViewContext().getTargetElement(semanticElement, KGraphElement.class);
        if (diagramElement instanceof KGraphElement) {
            this.currentViewer.centerOn(diagramElement, duration);
        }
    }

    @Override
    public void centerOn(KGraphElement diagramElement, int duration) {
        if (this.currentViewer != null) {
            this.currentViewer.centerOn(diagramElement, duration);
        }
    }

    @Override
    public void panToTopLeftCorner(Object semanticElement, int duration) {
        KGraphElement diagramElement = this.getViewContext().getTargetElement(semanticElement, KGraphElement.class);
        if (diagramElement instanceof KNode) {
            this.currentViewer.panToTopLeftCorner((KNode)diagramElement, duration);
        }
    }

    @Override
    public void panToTopLeftCorner(KNode diagramElement, int duration) {
        if (this.currentViewer != null) {
            this.currentViewer.panToTopLeftCorner(diagramElement, duration);
        }
    }

    @Override
    public void panDiagramToTopLeftCorner(int duration) {
        if (this.currentViewer != null) {
            this.currentViewer.panDiagramToTopLeftCorner(duration);
        }
    }

    @Override
    public void toggleSelectionOf(Object semanticElement) {
        EObject diagramElement = (EObject)this.getViews.apply(semanticElement);
        if (diagramElement != null) {
            this.toggleSelectionOfDiagramElements(Collections.singleton(diagramElement));
        }
    }

    @Override
    public void toggleSelectionOf(KGraphElement diagramElement) {
        this.toggleSelectionOfDiagramElements(Collections.singleton(diagramElement));
    }

    @Override
    public void toggleSelectionOf(KText diagramElement) {
        this.toggleSelectionOfDiagramElements(Collections.singleton(diagramElement));
    }

    @Override
    public void toggleSelectionOfSemanticElements(Set<Object> semanticElements) {
        this.toggleSelectionOfDiagramElements(Sets.newHashSet((Iterable)Iterables.transform(semanticElements, this.getViews)));
    }

    @Override
    public void toggleSelectionOfDiagramElements(Set<? extends EObject> toBeToggled) {
        KlighdTreeSelection diagSelection = this.getDiagramSelection();
        ArrayList theSelection = Lists.newArrayList((Iterable)Iterables.filter((Iterable)(diagSelection != null ? diagSelection : KlighdTreeSelection.EMPTY), EObject.class));
        for (EObject diagramElement : Sets.filter(toBeToggled, KlighdPredicates.isSelectable())) {
            boolean removed = theSelection.remove(diagramElement);
            if (removed) continue;
            theSelection.add(diagramElement);
        }
        this.updateSelection(theSelection);
    }

    @Override
    public void resetSelectionTo(Object semanticElement) {
        EObject diagramElement = (EObject)this.getViews.apply(semanticElement);
        this.updateSelection(Collections.singleton(diagramElement));
    }

    @Override
    public void resetSelectionTo(KGraphElement diagramElement) {
        this.updateSelection(Collections.singleton(diagramElement));
    }

    @Override
    public void resetSelectionTo(KText diagramElement) {
        this.updateSelection(Collections.singleton(diagramElement));
    }

    @Override
    public void resetSelectionToSemanticElements(Iterable<? extends Object> semanticElements) {
        this.updateSelection(Iterables.transform(semanticElements, this.getViews));
    }

    @Override
    public void resetSelectionToDiagramElements(Iterable<? extends EObject> diagramElements) {
        this.updateSelection(Iterables.filter(diagramElements, KlighdPredicates.isSelectable()));
    }

    private void updateSelection(Iterable<? extends EObject> diagramElements) {
        KlighdTreeSelection diagSelection = this.getDiagramSelection();
        ArrayList currentlySelected = diagSelection != null ? Lists.newArrayList((Iterable)Iterables.filter((Iterable)diagSelection, EObject.class)) : Collections.emptyList();
        ArrayList toBeSelected = Lists.newArrayList((Iterable)Iterables.filter(diagramElements, (Predicate)Predicates.notNull()));
        for (KRendering r : Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)currentlySelected, KlighdPredicates.notIn(toBeSelected)), AS_RENDERING))) {
            r.setProperty(KlighdInternalProperties.SELECTED, (Object)false);
        }
        for (KRendering r : Iterables.concat((Iterable)Iterables.transform((Iterable)toBeSelected, AS_RENDERING))) {
            r.setProperty(KlighdInternalProperties.SELECTED, (Object)true);
        }
        this.createSelection(toBeSelected);
    }

    protected void createSelection(Collection<EObject> elements) {
        this.notifySelectionListeners(new KlighdTreeSelection(this.getViewContext(), elements));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySelectionListeners(IKlighdSelection theSelection) {
        Set<ISelectionChangedListener> set = this.selectionListeners;
        synchronized (set) {
            this.selection = theSelection;
            if (theSelection instanceof KlighdTreeSelection) {
                this.diagramSelection = (KlighdTreeSelection)theSelection;
            } else {
                this.resetSelectionHighlighting();
                this.diagramSelection = null;
            }
            if (!this.selectionListeners.isEmpty()) {
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)theSelection);
                for (ISelectionChangedListener listener : this.selectionListeners) {
                    listener.selectionChanged(event);
                }
            }
        }
    }

    private void resetSelectionHighlighting() {
        Iterable currentSelection = Iterables.filter((Iterable)this.getDiagramSelection(), EObject.class);
        if (currentSelection != null) {
            for (KRendering r : Iterables.concat((Iterable)Iterables.transform((Iterable)currentSelection, AS_RENDERING))) {
                r.setProperty(KlighdInternalProperties.SELECTED, (Object)false);
            }
        }
    }

    @Override
    public KlighdTreeSelection getDiagramSelection() {
        return this.diagramSelection;
    }

    @Override
    public IKlighdSelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        String msg = "KLighD: Setting the selection in KLighD viewers via ISelectionProvider.setSelection(...) is not supported.";
        throw new UnsupportedOperationException("KLighD: Setting the selection in KLighD viewers via ISelectionProvider.setSelection(...) is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        Set<ISelectionChangedListener> set = this.selectionListeners;
        synchronized (set) {
            this.selectionListeners.add(listener);
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        Set<ISelectionChangedListener> set = this.selectionListeners;
        synchronized (set) {
            this.selectionListeners.remove(listener);
        }
    }
}

