/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.viewers;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import de.cau.cs.kieler.klighd.IKlighdSelection;
import de.cau.cs.kieler.klighd.IViewChangeListener;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.KlighdTreeSelection;
import de.cau.cs.kieler.klighd.ViewChangeType;
import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.krendering.KText;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractViewer
implements IViewer {
    private SetMultimap<ViewChangeType, IViewChangeListener> viewChangeListeners;
    private Map<IViewChangeListener, Map<ViewChangeType, Long>> notificationSuppressions;
    private SetMultimap<ViewChangeType, IViewChangeListener> viewChangeListenersView;

    @Override
    public void setModel(Object model) {
        this.setModel(model, false);
    }

    @Override
    public void setModel(Object model, boolean sync) {
        if (model instanceof KNode) {
            this.setModel((KNode)model, sync);
        }
    }

    public abstract void setModel(KNode var1, boolean var2);

    @Override
    public void addViewChangeListener(IViewChangeListener listener, ViewChangeType ... eventTypes) {
        EnumSet<ViewChangeType> types;
        if (listener == null) {
            return;
        }
        Collection<ViewChangeType> collection = types = eventTypes != null && eventTypes.length != 0 ? Arrays.asList(eventTypes) : ViewChangeType.all();
        if (Iterables.any(types, (Predicate)Predicates.isNull())) {
            String msg = "KLighD viewer: found 'null' value in provided list of 'ViewChangeType's during registration of an 'IViewChangeListener'";
            throw new IllegalArgumentException("KLighD viewer: found 'null' value in provided list of 'ViewChangeType's during registration of an 'IViewChangeListener'");
        }
        this.addViewChangeListener(listener, (Iterable<ViewChangeType>)types);
    }

    @Override
    public void addViewChangeListener(IViewChangeListener listener, EnumSet<ViewChangeType> eventTypes) {
        if (listener == null) {
            return;
        }
        EnumSet<ViewChangeType> types = eventTypes != null && !eventTypes.isEmpty() ? eventTypes : ViewChangeType.all();
        this.addViewChangeListener(listener, (Iterable<ViewChangeType>)types);
    }

    private void addViewChangeListener(IViewChangeListener listener, Iterable<ViewChangeType> eventTypes) {
        if (this.viewChangeListeners == null) {
            this.viewChangeListeners = HashMultimap.create();
            this.notificationSuppressions = Maps.newHashMap();
        }
        for (ViewChangeType t : eventTypes) {
            this.viewChangeListeners.put((Object)t, (Object)listener);
        }
        this.viewChangeListenersView = null;
    }

    @Override
    public void removeViewChangeListener(IViewChangeListener listener) {
        if (listener != null && this.viewChangeListeners != null) {
            Iterator listeners = this.viewChangeListeners.values().iterator();
            while (listeners.hasNext()) {
                if (listeners.next() != listener) continue;
                listeners.remove();
            }
            this.notificationSuppressions.remove(listener);
            this.viewChangeListenersView = null;
        }
    }

    protected Multimap<ViewChangeType, IViewChangeListener> getViewChangeListeners() {
        if (this.viewChangeListenersView == null) {
            this.viewChangeListenersView = Multimaps.unmodifiableSetMultimap(this.viewChangeListeners);
        }
        return this.viewChangeListenersView;
    }

    protected void notifyViewChangeListeners(ViewChangeType type, KGraphElement affectedElement, Rectangle2D viewPort, double diagramScale) {
        if (this.viewChangeListeners == null) {
            return;
        }
        IViewChangeListener.ViewChange change = new IViewChangeListener.ViewChange(this, type, affectedElement, viewPort, diagramScale);
        long time = System.currentTimeMillis();
        for (IViewChangeListener listener : this.viewChangeListeners.get((Object)type)) {
            Long suppressionDeadline;
            Map<ViewChangeType, Long> earlierSuppressions = this.notificationSuppressions.get(listener);
            if (earlierSuppressions != null && (suppressionDeadline = earlierSuppressions.get((Object)type)) != null) {
                long suppressionDeadlineValue = suppressionDeadline;
                if (suppressionDeadlineValue == 0L) {
                    earlierSuppressions.remove((Object)type);
                    continue;
                }
                if (suppressionDeadlineValue >= time) continue;
                if (suppressionDeadlineValue < time) {
                    earlierSuppressions.remove((Object)type);
                }
            }
            listener.viewChanged(change);
            Map<ViewChangeType, Long> listenersSuppressionConfig = change.obtainAndResetNotificationSuppressionConfig();
            if (listenersSuppressionConfig == null) continue;
            this.updateSuppressionData(listener, listenersSuppressionConfig);
        }
    }

    private void updateSuppressionData(IViewChangeListener listener, Map<ViewChangeType, Long> declaredSuppressionConfig) {
        Map<ViewChangeType, Long> currentConfig = this.notificationSuppressions.get(listener);
        if (currentConfig == null) {
            this.notificationSuppressions.put(listener, declaredSuppressionConfig);
            return;
        }
        for (Map.Entry<ViewChangeType, Long> entry : declaredSuppressionConfig.entrySet()) {
            ViewChangeType type = entry.getKey();
            Long currentDeadline = currentConfig.get((Object)type);
            if (currentDeadline == null) {
                currentConfig.put(type, entry.getValue());
                continue;
            }
            if (currentDeadline >= entry.getValue()) continue;
            currentConfig.put(type, entry.getValue());
        }
    }

    protected void updateSelection(IKlighdSelection selection) {
        this.getContextViewer().notifySelectionListeners(selection);
    }

    @Override
    public boolean isDisplayed(Object semanticElement, boolean checkParents) {
        return this.getContextViewer().isVisible(semanticElement, false);
    }

    @Override
    public boolean isVisible(Object semanticElement, boolean checkParents) {
        return this.getContextViewer().isVisible(semanticElement, false);
    }

    @Override
    public Iterator<KNode> getVisibleDiagramNodes() {
        return this.getContextViewer().getVisibleDiagramNodes();
    }

    @Override
    public Iterator<KGraphElement> getVisibleDiagramElements() {
        return this.getContextViewer().getVisibleDiagramElements();
    }

    @Override
    public void reveal(Object semanticElement, int duration) {
        this.getContextViewer().reveal(semanticElement, duration);
    }

    @Override
    public void centerOn(Object semanticElement, int duration) {
        this.getContextViewer().centerOn(semanticElement, duration);
    }

    @Override
    public void panToTopLeftCorner(Object semanticElement, int duration) {
        this.getContextViewer().panToTopLeftCorner(semanticElement, duration);
    }

    @Override
    public void zoomToLevel(float zoomLevel, int duration) {
        this.getContextViewer().zoomToLevel(zoomLevel, duration);
    }

    @Override
    public void zoomToFocus(Object semanticElement, int duration) {
        this.getContextViewer().zoomToFocus(semanticElement, duration);
    }

    @Override
    public void zoom(ZoomStyle style, int duration) {
        this.getContextViewer().zoom(style, duration);
    }

    @Override
    public boolean isExpanded(Object semanticElement) {
        return this.getContextViewer().isExpanded(semanticElement);
    }

    @Override
    public void collapse(Object semanticElement) {
        this.getContextViewer().collapse(semanticElement);
    }

    @Override
    public void expand(Object semanticElement) {
        this.getContextViewer().expand(semanticElement);
    }

    @Override
    public void toggleExpansion(Object semanticElement) {
        this.getContextViewer().toggleExpansion(semanticElement);
    }

    @Override
    public void hide(Object semanticElement) {
        this.getContextViewer().hide(semanticElement);
    }

    @Override
    public void show(Object semanticElement) {
        this.getContextViewer().show(semanticElement);
    }

    @Override
    public void clip(Object semanticElement) {
        this.getContextViewer().clip(semanticElement);
    }

    @Override
    public void clip(Object semanticElement, Boolean hideClipNodePorts, Boolean hideClipNodeLabels) {
        this.getContextViewer().clip(semanticElement, hideClipNodePorts, hideClipNodeLabels);
    }

    @Override
    public void scale(Object semanticElement, double scale) {
        this.getContextViewer().scale(semanticElement, scale);
    }

    @Override
    public double getScale(Object semanticElement) {
        return this.getContextViewer().getScale(semanticElement);
    }

    @Override
    public IKlighdSelection getSelection() {
        return this.getContextViewer().getSelection();
    }

    @Override
    public KlighdTreeSelection getDiagramSelection() {
        return this.getContextViewer().getDiagramSelection();
    }

    @Override
    public void toggleSelectionOf(Object semanticElement) {
        this.getContextViewer().toggleSelectionOf(semanticElement);
    }

    @Override
    public void toggleSelectionOf(KGraphElement diagramElement) {
        this.getContextViewer().toggleSelectionOf(diagramElement);
    }

    @Override
    public void toggleSelectionOf(KText diagramElement) {
        this.getContextViewer().toggleSelectionOf(diagramElement);
    }

    @Override
    public void toggleSelectionOfSemanticElements(Set<Object> diagramElements) {
        this.getContextViewer().toggleSelectionOfSemanticElements(diagramElements);
    }

    @Override
    public void toggleSelectionOfDiagramElements(Set<? extends EObject> diagramElements) {
        this.getContextViewer().toggleSelectionOfDiagramElements(diagramElements);
    }

    @Override
    public void resetSelectionTo(Object semanticElement) {
        this.getContextViewer().resetSelectionTo(semanticElement);
    }

    @Override
    public void resetSelectionTo(KGraphElement diagramElement) {
        this.getContextViewer().resetSelectionTo(diagramElement);
    }

    @Override
    public void resetSelectionTo(KText diagramElement) {
        this.getContextViewer().resetSelectionTo(diagramElement);
    }

    @Override
    public void resetSelectionToSemanticElements(Iterable<? extends Object> diagramElements) {
        this.getContextViewer().resetSelectionToSemanticElements(diagramElements);
    }

    @Override
    public void resetSelectionToDiagramElements(Iterable<? extends EObject> diagramElements) {
        this.getContextViewer().resetSelectionToDiagramElements(diagramElements);
    }
}

