/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.util;

import java.awt.geom.Point2D;
import org.eclipse.elk.core.util.Pair;

public final class MathUtil {
    private MathUtil() {
    }

    public static Pair<Integer, Point2D> getSegmentStartIndexAndPoint(Point2D[] points, double locationAbsolute, double locationRelative) {
        if (points.length == 0) {
            return new Pair((Object)-1, (Object)new Point2D.Double(0.0, 0.0));
        }
        if (points.length == 1) {
            return new Pair((Object)0, (Object)((Point2D)points[0].clone()));
        }
        Point2D.Double point = new Point2D.Double();
        double totalDistance = 0.0;
        int i = 0;
        while (i < points.length - 1) {
            totalDistance += points[i].distance(points[i + 1]);
            ++i;
        }
        int k = -1;
        double searchDistance = locationRelative * totalDistance + locationAbsolute;
        double currentDistance = 0.0;
        int i2 = 0;
        while (i2 < points.length - 1) {
            double d = points[i2].distance(points[i2 + 1]);
            if (!(d <= 0.0)) {
                if (currentDistance + d >= searchDistance) {
                    k = i2;
                    double rD = searchDistance - currentDistance;
                    ((Point2D)point).setLocation(points[i2].getX() + rD * (points[i2 + 1].getX() - points[i2].getX()) / d, points[i2].getY() + rD * (points[i2 + 1].getY() - points[i2].getY()) / d);
                    break;
                }
                currentDistance += d;
            }
            ++i2;
        }
        if (k < 0) {
            if (locationRelative < 0.5) {
                k = 0;
                point.setLocation(points[0]);
            } else {
                k = points.length - 2;
                point.setLocation(points[k]);
            }
        }
        return new Pair((Object)k, (Object)point);
    }

    public static Point2D getPoint(Point2D[] points, double locationRelative) {
        return (Point2D)MathUtil.getSegmentStartIndexAndPoint(points, 0.0, locationRelative).getSecond();
    }

    public static double angle(Point2D p0, Point2D p1) {
        double xD = p1.getX() - p0.getX();
        double yD = p1.getY() - p0.getY();
        return Math.atan2(yD, xD);
    }

    public static double getLength(Point2D[] points) {
        if (points.length == 0) {
            return 0.0;
        }
        Point2D lastBend = points[0];
        double currentLength = 0.0;
        int i = 1;
        while (i < points.length) {
            Point2D currentBend = points[i];
            currentLength += lastBend.distance(currentBend);
            lastBend = currentBend;
            ++i;
        }
        return currentLength;
    }
}

