/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.syntheses;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import de.cau.cs.kieler.klighd.DisplayedActionData;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.SynthesisOption;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.internal.ISynthesis;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.krendering.ViewSynthesisShared;
import de.cau.cs.kieler.klighd.syntheses.AbstractDiagramSynthesis;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.core.util.WrappedException;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ReinitializingDiagramSynthesisProxy<S>
implements ISynthesis {
    private final Class<? extends AbstractDiagramSynthesis<S>> transformationClass;
    private final Module transformationClassBinding;
    private final ViewSynthesisScope synthesisScope;
    private AbstractDiagramSynthesis<S> transformationDelegate = null;

    ReinitializingDiagramSynthesisProxy(final Class<? extends AbstractDiagramSynthesis<S>> clazz) {
        this.transformationClass = clazz;
        this.synthesisScope = new ViewSynthesisScope(clazz);
        this.transformationClassBinding = new Module(){

            public void configure(Binder binder) {
                binder.bind(ResourceSet.class).to(ResourceSetImpl.class);
                binder.bind(new TypeLiteral<AbstractDiagramSynthesis<?>>(){}).to(clazz);
                binder.bindScope(ViewSynthesisShared.class, (Scope)ReinitializingDiagramSynthesisProxy.this.synthesisScope);
            }
        };
    }

    public AbstractDiagramSynthesis<S> getDelegate() {
        if (this.transformationDelegate == null) {
            this.transformationDelegate = this.getNewDelegateInstance();
        }
        return this.transformationDelegate;
    }

    private AbstractDiagramSynthesis<S> getNewDelegateInstance() {
        AbstractDiagramSynthesis res;
        try {
            res = (AbstractDiagramSynthesis)Guice.createInjector((Module[])new Module[]{this.transformationClassBinding}).getInstance(this.transformationClass);
        }
        catch (Exception e) {
            String nl = Klighd.LINE_SEPARATOR;
            String msg = "KLighD: Cannot instantiate " + this.transformationClass.getCanonicalName() + "." + nl + "Is that class free of compiler errors?" + nl + "Does it extend " + AbstractDiagramSynthesis.class.getCanonicalName() + "?" + nl + "See exception trace below.";
            throw new WrappedException(msg, (Throwable)e);
        }
        return res;
    }

    @Override
    public Class<?> getInputDataType() {
        if (this.transformationDelegate == null) {
            this.transformationDelegate = this.getNewDelegateInstance();
        }
        return this.transformationDelegate.getInputDataType();
    }

    @Override
    public boolean supports(Object model, ViewContext viewContext) {
        if (this.transformationDelegate == null) {
            this.transformationDelegate = this.getNewDelegateInstance();
        }
        return this.transformationDelegate.supports(model, viewContext);
    }

    @Override
    public KNode transform(Object model, ViewContext viewContext) {
        this.transformationDelegate = this.getNewDelegateInstance();
        KNode result = this.transformationDelegate.transform(model, viewContext);
        this.transformationDelegate = null;
        this.synthesisScope.clear();
        return result;
    }

    @Override
    public List<DisplayedActionData> getDisplayedActions() {
        if (this.transformationDelegate == null) {
            this.transformationDelegate = this.getNewDelegateInstance();
        }
        return this.transformationDelegate.getDisplayedActions();
    }

    @Override
    public List<SynthesisOption> getDisplayedSynthesisOptions() {
        if (this.transformationDelegate == null) {
            this.transformationDelegate = this.getNewDelegateInstance();
        }
        return this.transformationDelegate.getDisplayedSynthesisOptions();
    }

    @Override
    public Function<String, Void> getTextUpdateFunction(KText kText, KGraphElement element) {
        if (this.transformationDelegate == null) {
            return this.getNewDelegateInstance().getTextUpdateFunction(kText, element);
        }
        return this.transformationDelegate.getTextUpdateFunction(kText, element);
    }

    @Override
    public List<Pair<IProperty<?>, List<?>>> getDisplayedLayoutOptions() {
        if (this.transformationDelegate == null) {
            this.transformationDelegate = this.getNewDelegateInstance();
        }
        return this.transformationDelegate.getDisplayedLayoutOptions();
    }

    @Override
    public List<? extends IGraphElementVisitor> getAdditionalLayoutConfigs(KNode viewModel, ViewContext viewContext) {
        if (this.transformationDelegate == null) {
            this.transformationDelegate = this.getNewDelegateInstance();
        }
        return this.transformationDelegate.getAdditionalLayoutConfigs(viewModel, viewContext);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.getNewDelegateInstance() + ")";
    }

    private class ViewSynthesisScope
    implements Scope {
        private Class<? extends AbstractDiagramSynthesis<S>> mainTransformationClazz = null;
        private Set<Object> instances = Sets.newHashSet();

        ViewSynthesisScope(Class<? extends AbstractDiagramSynthesis<S>> themainTransformationClazz) {
            this.mainTransformationClazz = themainTransformationClazz;
        }

        private void clear() {
            this.instances.clear();
        }

        public <U> Provider<U> scope(final Key<U> key, final Provider<U> unscoped) {
            return new Provider<U>(){

                public U get() {
                    Class theClazzToBeInjected = key.getTypeLiteral().getRawType();
                    Object instance = null;
                    if (theClazzToBeInjected != ViewSynthesisScope.this.mainTransformationClazz && AbstractDiagramSynthesis.class.isAssignableFrom(theClazzToBeInjected)) {
                        ViewSynthesisScope.this.instances.clear();
                    } else {
                        instance = Iterables.getFirst((Iterable)Iterables.filter(ViewSynthesisScope.this.instances, (Class)theClazzToBeInjected), null);
                        if (instance != null) {
                            return instance;
                        }
                    }
                    instance = unscoped.get();
                    ViewSynthesisScope.this.instances.add(instance);
                    return instance;
                }

                public String toString() {
                    return String.format("%s[%s]", unscoped, ViewSynthesisScope.this);
                }
            };
        }

        public String toString() {
            return "KLighD.ViewSynthesisShared";
        }
    }
}

