/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.syntheses;

import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.kgraph.KPort;
import de.cau.cs.kieler.klighd.krendering.KAreaPlacementData;
import de.cau.cs.kieler.klighd.krendering.KBackground;
import de.cau.cs.kieler.klighd.krendering.KBottomPosition;
import de.cau.cs.kieler.klighd.krendering.KContainerRendering;
import de.cau.cs.kieler.klighd.krendering.KDecoratorPlacementData;
import de.cau.cs.kieler.klighd.krendering.KInvisibility;
import de.cau.cs.kieler.klighd.krendering.KLeftPosition;
import de.cau.cs.kieler.klighd.krendering.KLineStyle;
import de.cau.cs.kieler.klighd.krendering.KLineWidth;
import de.cau.cs.kieler.klighd.krendering.KPlacementData;
import de.cau.cs.kieler.klighd.krendering.KPosition;
import de.cau.cs.kieler.klighd.krendering.KRectangle;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingFactory;
import de.cau.cs.kieler.klighd.krendering.KRightPosition;
import de.cau.cs.kieler.klighd.krendering.KRoundedRectangle;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.krendering.KTopPosition;
import de.cau.cs.kieler.klighd.krendering.KXPosition;
import de.cau.cs.kieler.klighd.krendering.KYPosition;
import de.cau.cs.kieler.klighd.krendering.LineStyle;
import de.cau.cs.kieler.klighd.util.ExpansionAwareLayoutOption;
import de.cau.cs.kieler.klighd.util.KlighdProperties;
import de.cau.cs.kieler.klighd.util.KlighdSemanticDiagramData;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public final class DiagramSyntheses {
    private static final String NO_VIEWCONTEXT_ERROR_MSG = "KLighD: Failed to set the initial diagram clip in XX: No ViewContext is available.";
    private static final String NO_DECORATOR_ERROR_MSG = "KLighD: Only decorator renderings and KTexts can be made not selectable.";
    private static final float SELECTION_RECTANGLE_CORNER_SIZE = 3.0f;
    private static final float SELECTION_RECTANGLE_ENLARGEMENT = 3.0f;
    private static final int SELECTION_COLOR_R = 180;
    private static final int SELECTION_COLOR_G = 213;
    private static final int SELECTION_COLOR_B = 255;

    private DiagramSyntheses() {
    }

    public static <S extends KGraphElement, T> S setLayoutOption(S element, IProperty<T> option, T value) {
        element.setProperty(option, value);
        return element;
    }

    public static <S extends KGraphElement> S setLayoutOption(S element, String optionId, Object value) {
        LayoutOptionData option = LayoutMetaDataService.getInstance().getOptionData(optionId);
        if (option != null) {
            Object realValue = value;
            if (value instanceof String) {
                realValue = option.parseValue((String)value);
            }
            element.setProperty((IProperty)option, realValue);
        }
        return element;
    }

    public static <S extends KGraphElement> S setLayoutOptions(S element, Map<IProperty<?>, ?> optionValueMap) {
        if (optionValueMap != null) {
            for (Map.Entry<IProperty<?>, ?> entry : optionValueMap.entrySet()) {
                IProperty<?> key = entry.getKey();
                element.setProperty(key, entry.getValue());
            }
        }
        return element;
    }

    public static Pair<IProperty<?>, List<?>> specifyLayoutOption(IProperty<?> prop, List<?> values) {
        return Pair.of(prop, values);
    }

    public static Pair<IProperty<?>, List<?>> specifyLayoutOption(String layoutOptionId, List<?> values) {
        LayoutOptionData option = LayoutMetaDataService.getInstance().getOptionData(layoutOptionId);
        if (option != null) {
            return DiagramSyntheses.specifyLayoutOption(option, values);
        }
        throw new IllegalArgumentException("Could not resolve the layout option '" + layoutOptionId + "' using ELK's layout option service. " + "Make sure the layout option exists and is properly registered with ELK.");
    }

    public static <T> KNode setExpansionAwareLayoutOption(KNode node, IProperty<T> option, T collapsedValue, T expandedValue) {
        ExpansionAwareLayoutOption.setProperty((IPropertyHolder)node, option, collapsedValue, expandedValue);
        return node;
    }

    public static <T> KPort setExpansionAwareLayoutOption(KPort port, IProperty<T> option, T collapsedValue, T expandedValue) {
        ExpansionAwareLayoutOption.setProperty((IPropertyHolder)port, option, collapsedValue, expandedValue);
        return port;
    }

    public static <T extends KRendering> T setAsCollapsedView(T krendering) {
        krendering.getProperties().removeKey(KlighdProperties.EXPANDED_RENDERING);
        krendering.setProperty(KlighdProperties.COLLAPSED_RENDERING, (Object)true);
        return krendering;
    }

    public static <T extends KRendering> T setAsExpandedView(T krendering) {
        krendering.getProperties().removeKey(KlighdProperties.COLLAPSED_RENDERING);
        krendering.setProperty(KlighdProperties.EXPANDED_RENDERING, (Object)true);
        return krendering;
    }

    public static <S extends KGraphElement> S setUpperVisibilityScaleBound(S kgraphElement, Number upperBound) {
        kgraphElement.setProperty(KlighdProperties.VISIBILITY_SCALE_UPPER_BOUND, (Object)upperBound);
        return kgraphElement;
    }

    public static <S extends KGraphElement> S setLowerVisibilityScaleBound(S kgraphElement, Number lowerBound) {
        kgraphElement.setProperty(KlighdProperties.VISIBILITY_SCALE_LOWER_BOUND, (Object)lowerBound);
        return kgraphElement;
    }

    public static <T extends KRendering> T setUpperVisibilityScaleBound(T krendering, Number upperBound) {
        krendering.setProperty(KlighdProperties.VISIBILITY_SCALE_UPPER_BOUND, (Object)upperBound);
        return krendering;
    }

    public static <T extends KRendering> T setLowerVisibilityScaleBound(T krendering, Number lowerBound) {
        krendering.setProperty(KlighdProperties.VISIBILITY_SCALE_LOWER_BOUND, (Object)lowerBound);
        return krendering;
    }

    public static <S extends KGraphElement> S setUpperVisibilityHeightBound(S kgraphElement, Number upperBound) {
        kgraphElement.setProperty(KlighdProperties.VISIBILITY_HEIGHT_UPPER_BOUND, (Object)upperBound);
        return kgraphElement;
    }

    public static <S extends KGraphElement> S setLowerVisibilityHeightBound(S kgraphElement, Number lowerBound) {
        kgraphElement.setProperty(KlighdProperties.VISIBILITY_HEIGHT_LOWER_BOUND, (Object)lowerBound);
        return kgraphElement;
    }

    public static <T extends KRendering> T setUpperVisibilityHeightBound(T krendering, Number upperBound) {
        krendering.setProperty(KlighdProperties.VISIBILITY_HEIGHT_UPPER_BOUND, (Object)upperBound);
        return krendering;
    }

    public static <T extends KRendering> T setLowerVisibilityHeightBound(T krendering, Number lowerBound) {
        krendering.setProperty(KlighdProperties.VISIBILITY_HEIGHT_LOWER_BOUND, (Object)lowerBound);
        return krendering;
    }

    public static <S extends KGraphElement> S setUpperVisibilityWidthBound(S kgraphElement, Number upperBound) {
        kgraphElement.setProperty(KlighdProperties.VISIBILITY_WIDTH_UPPER_BOUND, (Object)upperBound);
        return kgraphElement;
    }

    public static <S extends KGraphElement> S setLowerVisibilityWidthBound(S kgraphElement, Number lowerBound) {
        kgraphElement.setProperty(KlighdProperties.VISIBILITY_WIDTH_LOWER_BOUND, (Object)lowerBound);
        return kgraphElement;
    }

    public static <T extends KRendering> T setUpperVisibilityWidthBound(T krendering, Number upperBound) {
        krendering.setProperty(KlighdProperties.VISIBILITY_WIDTH_UPPER_BOUND, (Object)upperBound);
        return krendering;
    }

    public static <T extends KRendering> T setLowerVisibilityWidthBound(T krendering, Number lowerBound) {
        krendering.setProperty(KlighdProperties.VISIBILITY_WIDTH_LOWER_BOUND, (Object)lowerBound);
        return krendering;
    }

    public static <T extends KRendering> T setPropagateVisibilityBoundsToChildren(T krendering, boolean propagateToChildren) {
        krendering.setProperty(KlighdProperties.VISIBILITY_PROPAGATE_TO_CHILDREN, (Object)propagateToChildren);
        return krendering;
    }

    public static <T extends KRendering> T propagateVisibilityBoundsToChildren(T krendering) {
        return DiagramSyntheses.setPropagateVisibilityBoundsToChildren(krendering, true);
    }

    public static <T extends KRendering> T excludedFromOutline(T krendering) {
        krendering.setProperty(KlighdProperties.OUTLINE_INVISIBLE, (Object)true);
        return krendering;
    }

    public static <T extends KRendering> T excludedFromExportedImages(T krendering) {
        krendering.setProperty(KlighdProperties.EXPORTED_IMAGE_INVISIBLE, (Object)true);
        return krendering;
    }

    public static <T extends KRendering> T excludedFromPrintouts(T krendering) {
        krendering.setProperty(KlighdProperties.PRINTOUT_INVISIBLE, (Object)true);
        return krendering;
    }

    public static <T extends KRendering> T excludedFromExportedImagesAndPrintouts(T krendering) {
        krendering.setProperty(KlighdProperties.EXPORTED_IMAGE_INVISIBLE, (Object)true);
        krendering.setProperty(KlighdProperties.PRINTOUT_INVISIBLE, (Object)true);
        return krendering;
    }

    public static KNode initiallyCollapse(KNode node) {
        node.setProperty(KlighdProperties.EXPAND, (Object)false);
        return node;
    }

    public static KNode initiallyExpand(KNode node) {
        node.setProperty(KlighdProperties.EXPAND, (Object)true);
        return node;
    }

    public static <S extends KGraphElement> S initiallyHide(S kge) {
        kge.setProperty(KlighdProperties.SHOW, (Object)false);
        return kge;
    }

    public static <S extends KGraphElement> S initiallyShow(S kge) {
        kge.setProperty(KlighdProperties.SHOW, (Object)true);
        return kge;
    }

    public static KNode initiallyScale(KNode node, double scale) {
        node.setProperty(CoreOptions.SCALE_FACTOR, (Object)scale);
        return node;
    }

    public static KNode initiallyClipTo(ViewContext viewContext, KNode node) {
        return DiagramSyntheses.initiallyClipTo(node, viewContext);
    }

    public static KNode initiallyClipTo(KNode node, ViewContext viewContext) {
        if (viewContext == null) {
            throw new RuntimeException(NO_VIEWCONTEXT_ERROR_MSG);
        }
        viewContext.setProperty(KlighdProperties.CLIP, node);
        return node;
    }

    public static <S extends KGraphElement> S suppressSelectability(S kge) {
        kge.setProperty(KlighdProperties.NOT_SELECTABLE, (Object)true);
        return kge;
    }

    public static KText suppressSelectability(KText kText) {
        kText.setProperty(KlighdProperties.NOT_SELECTABLE, (Object)true);
        return kText;
    }

    public static KRendering suppressSelectablility(KRendering kRendering) {
        if (!(kRendering.getPlacementData() instanceof KDecoratorPlacementData)) {
            throw new IllegalArgumentException(NO_DECORATOR_ERROR_MSG);
        }
        kRendering.setProperty(KlighdProperties.NOT_SELECTABLE, (Object)true);
        return kRendering;
    }

    public static <S extends KGraphElement> S setSemanticData(S kge, KlighdSemanticDiagramData data) {
        kge.setProperty(KlighdProperties.SEMANTIC_DATA, (Object)data);
        return kge;
    }

    public static <T extends KRendering> T setSemanticData(T krendering, KlighdSemanticDiagramData data) {
        krendering.setProperty(KlighdProperties.SEMANTIC_DATA, (Object)data);
        return krendering;
    }

    public static <S extends KGraphElement> S setTooltip(S kge, String tooltip) {
        kge.setProperty(KlighdProperties.TOOLTIP, (Object)tooltip);
        return kge;
    }

    public static <T extends KRendering> T setTooltip(T krendering, String tooltip) {
        krendering.setProperty(KlighdProperties.TOOLTIP, (Object)tooltip);
        return krendering;
    }

    public static KContainerRendering addRenderingWithStandardSelectionWrapper(KGraphElement kge, KRendering ren) {
        KContainerRendering selectionRendering = DiagramSyntheses.wrapWithStandardNodeSelectionRendering(ren);
        kge.getData().add((Object)selectionRendering);
        return selectionRendering;
    }

    public static KContainerRendering wrapWithStandardNodeSelectionRendering(KRendering ren) {
        int selectionR = 180;
        int selectionG = 213;
        int selectionB = 255;
        Display display = Display.getCurrent();
        if (display != null) {
            Color selectionColor = display.getSystemColor(26);
            selectionR = selectionColor.getRed();
            selectionG = selectionColor.getGreen();
            selectionB = selectionColor.getBlue();
        }
        KRenderingFactory factory = KRenderingFactory.eINSTANCE;
        KRectangle containerRendering = factory.createKRectangle();
        KInvisibility containerInvisibility = factory.createKInvisibility();
        containerInvisibility.setInvisible(true);
        containerRendering.getStyles().add((Object)containerInvisibility);
        KRoundedRectangle selectionRectangle = factory.createKRoundedRectangle();
        selectionRectangle.setCornerWidth(3.0f);
        selectionRectangle.setCornerHeight(3.0f);
        containerRendering.getChildren().add((Object)selectionRectangle);
        KBackground selectionRectangleBackground = factory.createKBackground();
        selectionRectangleBackground.setColor(selectionR, selectionG, selectionB);
        selectionRectangle.getStyles().add((Object)selectionRectangleBackground);
        KLineStyle selectionRectangleLineStyle = factory.createKLineStyle();
        selectionRectangleLineStyle.setLineStyle(LineStyle.DASH);
        selectionRectangle.getStyles().add((Object)selectionRectangleLineStyle);
        KLineWidth selectionRectangleLineWidth = factory.createKLineWidth();
        selectionRectangleLineWidth.setLineWidth(1.0f);
        selectionRectangle.getStyles().add((Object)selectionRectangleLineWidth);
        KInvisibility selectionVisibility = factory.createKInvisibility();
        selectionVisibility.setInvisible(true);
        selectionRectangle.getStyles().add((Object)selectionVisibility);
        selectionVisibility = factory.createKInvisibility();
        selectionVisibility.setInvisible(false);
        selectionVisibility.setSelection(true);
        selectionRectangle.getStyles().add((Object)selectionVisibility);
        KTopPosition topPosition = (KTopPosition)factory.createKTopPosition().setPosition(-3.0f, 0.0f);
        KLeftPosition leftPosition = (KLeftPosition)factory.createKLeftPosition().setPosition(-3.0f, 0.0f);
        KPosition topLeftPosition = factory.createKPosition().setPositions((KXPosition)leftPosition, (KYPosition)topPosition);
        KBottomPosition bottomPosition = (KBottomPosition)factory.createKBottomPosition().setPosition(-3.0f, 0.0f);
        KRightPosition rightPosition = (KRightPosition)factory.createKRightPosition().setPosition(-3.0f, 0.0f);
        KPosition bottomRightPosition = factory.createKPosition().setPositions((KXPosition)rightPosition, (KYPosition)bottomPosition);
        KAreaPlacementData areaPlacementData = factory.createKAreaPlacementData();
        areaPlacementData.setTopLeft(topLeftPosition);
        areaPlacementData.setBottomRight(bottomRightPosition);
        selectionRectangle.setPlacementData((KPlacementData)areaPlacementData);
        if (ren != null) {
            containerRendering.getChildren().add((Object)ren);
        }
        return containerRendering;
    }
}

