/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.syntheses;

import com.google.common.base.Function;
import de.cau.cs.kieler.klighd.DisplayedActionData;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.SynthesisOption;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.internal.ISynthesis;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.kgraph.KPort;
import de.cau.cs.kieler.klighd.krendering.KRenderingFactory;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.syntheses.DiagramSyntheses;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractDiagramSynthesis<S>
implements ISynthesis {
    private ViewContext currentContext = null;
    private boolean triedToInferClasses = false;
    private Class<?> sourceModelClass = null;
    private static final String TRANSFORM_METHOD_NAME = "transform";
    protected static final KRenderingFactory RENDERING_FACTORY = KRenderingFactory.eINSTANCE;
    private static final String NO_VIEWCONTEXT_ERROR_MSG = "KLighD: Failed to set the initial diagram clip in XX: No ViewContext is available.";

    @Override
    public Class<?> getInputDataType() {
        if (!this.triedToInferClasses) {
            this.inferInputDataType();
        }
        return this.sourceModelClass;
    }

    protected void inferInputDataType() {
        this.triedToInferClasses = true;
        Method transformMethod = null;
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getReturnType().equals(KNode.class) && method.getName().equals(TRANSFORM_METHOD_NAME) && !method.isBridge() && method.getParameterTypes().length == 1) {
                if (transformMethod == null) {
                    transformMethod = method;
                } else {
                    String msg = "KLighD " + this.getClass().getSimpleName() + " diagram synthesis init: found multiple methods named " + "\"transform\" requiring a single parameter and returning a KNode." + Klighd.LINE_SEPARATOR + "KLighD's automatic source data type resolution requires exactly one " + "\"transform\" method implementing the abstract one required by the " + "super class." + Klighd.LINE_SEPARATOR + "Alternatively provide the input data type by overriding " + "\"getInputDataType()\".";
                    Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg));
                    transformMethod = null;
                    break;
                }
            }
            ++n2;
        }
        if (transformMethod != null) {
            this.sourceModelClass = transformMethod.getParameterTypes()[0];
        }
    }

    @Override
    public boolean supports(Object model, ViewContext viewContext) {
        if (this.getInputDataType().isInstance(model)) {
            Object input = model;
            return this.supports(input);
        }
        return false;
    }

    public boolean supports(S model) {
        return true;
    }

    @Override
    public final KNode transform(Object model, ViewContext viewContext) {
        this.use(viewContext);
        Object input = model;
        KNode result = this.transform(input);
        this.use(null);
        return result;
    }

    public abstract KNode transform(S var1);

    public <T extends EObject> T associateWith(T derived, Object source) {
        this.currentContext.associateSourceTargetPair(source, derived);
        return derived;
    }

    public <D extends EObject> D putToLookUpWith(D derived, Object source) {
        return this.associateWith(derived, source);
    }

    @Override
    public List<SynthesisOption> getDisplayedSynthesisOptions() {
        return Collections.emptyList();
    }

    @Override
    public List<Pair<IProperty<?>, List<?>>> getDisplayedLayoutOptions() {
        return Collections.emptyList();
    }

    protected Pair<IProperty<?>, List<?>> specifyLayoutOption(IProperty<?> prop, List<?> values) {
        return DiagramSyntheses.specifyLayoutOption(prop, values);
    }

    protected Pair<IProperty<?>, List<?>> specifyLayoutOption(String layoutOptionId, List<?> values) {
        return DiagramSyntheses.specifyLayoutOption(layoutOptionId, values);
    }

    @Override
    public List<DisplayedActionData> getDisplayedActions() {
        return Collections.emptyList();
    }

    @Override
    public List<? extends IGraphElementVisitor> getAdditionalLayoutConfigs(KNode viewModel, ViewContext viewContext) {
        return this.getAdditionalLayoutConfigs(viewModel);
    }

    public List<? extends IGraphElementVisitor> getAdditionalLayoutConfigs(KNode viewModel) {
        return this.getAdditionalLayoutConfigs();
    }

    public List<? extends IGraphElementVisitor> getAdditionalLayoutConfigs() {
        return new ArrayList();
    }

    @Override
    public Function<String, Void> getTextUpdateFunction(KText kText, KGraphElement element) {
        return null;
    }

    protected final KNode initiallyClipTo(KNode node) {
        return this.setInitialClipTo(this.getUsedContext(), node);
    }

    protected final KNode setInitialClipTo(ViewContext viewContext, KNode node) {
        if (viewContext != null) {
            return DiagramSyntheses.initiallyClipTo(viewContext, node);
        }
        throw new RuntimeException(NO_VIEWCONTEXT_ERROR_MSG.replace("XX", this.getClass().getName()));
    }

    protected final <R extends KGraphElement, T> R setLayoutOption(R element, IProperty<T> option, T value) {
        return DiagramSyntheses.setLayoutOption(element, option, value);
    }

    public static <R extends KGraphElement> R setLayoutOptions(R element, Map<IProperty<?>, ?> optionValueMap) {
        return DiagramSyntheses.setLayoutOptions(element, optionValueMap);
    }

    protected final <T> KNode setExpansionAwareLayoutOption(KNode node, IProperty<T> option, T collapsedValue, T expandedValue) {
        return DiagramSyntheses.setExpansionAwareLayoutOption(node, option, collapsedValue, expandedValue);
    }

    protected final <T> KPort setExpansionAwareLayoutOption(KPort port, IProperty<T> option, T collapsedValue, T expandedValue) {
        return DiagramSyntheses.setExpansionAwareLayoutOption(port, option, collapsedValue, expandedValue);
    }

    public void use(ViewContext viewContext) {
        this.currentContext = viewContext;
    }

    public ViewContext getUsedContext() {
        return this.currentContext;
    }

    public Object getObjectValue(SynthesisOption option) {
        return this.getUsedContext().getOptionValue(option);
    }

    public boolean getBooleanValue(SynthesisOption option) {
        Object result = this.getUsedContext().getOptionValue(option);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new IllegalArgumentException("KLighD transformation option handling: The transformation " + this + " attempted to evaluate the non-Boolean valued transformation option " + option.getName() + " expecting a Boolean value.");
    }

    public int getIntValue(SynthesisOption option) {
        Object result = this.getUsedContext().getOptionValue(option);
        if (result == null) {
            return 0;
        }
        if (result instanceof Float) {
            return ((Float)result).intValue();
        }
        if (result instanceof Integer) {
            return (Integer)result;
        }
        throw new IllegalArgumentException("KLighD transformation option handling: The transformation " + this + " attempted to evaluate the non-Integer valued transformation option " + option.getName() + " expecting a int value.");
    }

    public float getFloatValue(SynthesisOption option) {
        Object result = this.getUsedContext().getOptionValue(option);
        if (result == null) {
            return 0.0f;
        }
        if (result instanceof Float) {
            return ((Float)result).floatValue();
        }
        throw new IllegalArgumentException("KLighD transformation option handling: The transformation " + this + " attempted to evaluate the non-Float valued transformation option " + option.getName() + " expecting a float value.");
    }
}

