/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.microlayout;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.KlighdConstants;
import de.cau.cs.kieler.klighd.KlighdOptions;
import de.cau.cs.kieler.klighd.internal.util.KlighdInternalProperties;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KInsets;
import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.kgraph.PersistentEntry;
import de.cau.cs.kieler.klighd.krendering.KAreaPlacementData;
import de.cau.cs.kieler.klighd.krendering.KChildArea;
import de.cau.cs.kieler.klighd.krendering.KContainerRendering;
import de.cau.cs.kieler.klighd.krendering.KFontBold;
import de.cau.cs.kieler.klighd.krendering.KFontItalic;
import de.cau.cs.kieler.klighd.krendering.KFontName;
import de.cau.cs.kieler.klighd.krendering.KFontSize;
import de.cau.cs.kieler.klighd.krendering.KGridPlacement;
import de.cau.cs.kieler.klighd.krendering.KImage;
import de.cau.cs.kieler.klighd.krendering.KLeftPosition;
import de.cau.cs.kieler.klighd.krendering.KPlacement;
import de.cau.cs.kieler.klighd.krendering.KPlacementData;
import de.cau.cs.kieler.klighd.krendering.KPointPlacementData;
import de.cau.cs.kieler.klighd.krendering.KPolyline;
import de.cau.cs.kieler.klighd.krendering.KPosition;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingPackage;
import de.cau.cs.kieler.klighd.krendering.KRenderingRef;
import de.cau.cs.kieler.klighd.krendering.KRenderingUtil;
import de.cau.cs.kieler.klighd.krendering.KStyle;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.krendering.KTextUtil;
import de.cau.cs.kieler.klighd.krendering.KTopPosition;
import de.cau.cs.kieler.klighd.krendering.KXPosition;
import de.cau.cs.kieler.klighd.krendering.KYPosition;
import de.cau.cs.kieler.klighd.krendering.util.KRenderingSwitch;
import de.cau.cs.kieler.klighd.microlayout.Bounds;
import de.cau.cs.kieler.klighd.microlayout.GridPlacementUtil;
import de.cau.cs.kieler.klighd.util.Iterables2;
import de.cau.cs.kieler.klighd.util.KlighdProperties;
import de.cau.cs.kieler.klighd.util.ModelingUtil;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public final class PlacementUtil {
    private static final KRenderingPackage KRENDERING_PACKAGE = KRenderingPackage.eINSTANCE;
    private static final float PT_TO_PX_FACTOR = KlighdConstants.DEFAULT_DISPLAY_DPI / 72.0f;
    private static final Predicate<KStyle> FILTER = new Predicate<KStyle>(){

        public boolean apply(KStyle style) {
            return style.isPropagateToChildren();
        }
    };
    private static final Map<FontData, Font> FONT_CACHE = Maps.newHashMap();
    private static GC gc = null;
    private static GC asyncGC = null;
    private static Point displayScale = null;
    private static BufferedImage bi = new BufferedImage(1, 1, 2);
    private static Graphics2D fmg = bi.createGraphics();
    private static final int PIMARY = 0;
    private static final int SECONDARY = 1;
    private static final int FIRST_OFFSET = 100;
    private static final int PIMARY_PIMARY = 0;
    private static final int PIMARY_SECONDARY = 1;
    private static final int SECONDARY_PIMARY = 100;
    private static final int SECONDARY_SECONDARY = 101;

    private PlacementUtil() {
    }

    public static Point2D.Float evaluateKPosition(KPosition position, Rectangle2D parentBounds, boolean topLeft) {
        return PlacementUtil.evaluateKPosition(position, Bounds.of(parentBounds), topLeft).toPoint2D();
    }

    public static Point evaluateKPosition(KPosition position, Bounds parentBounds, boolean topLeft) {
        float width = parentBounds.getWidth();
        float height = parentBounds.getHeight();
        Point point = new Point(0.0f, 0.0f);
        KXPosition xPos = topLeft ? KRenderingUtil.toNonNullLeftPosition((KXPosition)position.getX()) : KRenderingUtil.toNonNullRightPosition((KXPosition)position.getX());
        KYPosition yPos = topLeft ? KRenderingUtil.toNonNullTopPosition((KYPosition)position.getY()) : KRenderingUtil.toNonNullBottomPosition((KYPosition)position.getY());
        point.x = xPos instanceof KLeftPosition ? xPos.getRelative() * width + xPos.getAbsolute() : width - xPos.getRelative() * width - xPos.getAbsolute();
        point.y = yPos instanceof KTopPosition ? yPos.getRelative() * height + yPos.getAbsolute() : height - yPos.getRelative() * height - yPos.getAbsolute();
        return point;
    }

    public static Bounds evaluateAreaPlacement(KAreaPlacementData dpd, Rectangle2D parentBounds) {
        return PlacementUtil.evaluateAreaPlacement(dpd, Bounds.of(parentBounds));
    }

    public static Bounds evaluateAreaPlacement(KAreaPlacementData dpd, Bounds parentBounds) {
        if (dpd == null) {
            return new Bounds(parentBounds);
        }
        return PlacementUtil.evaluateAreaPlacement(dpd.getTopLeft(), dpd.getBottomRight(), parentBounds);
    }

    static Bounds evaluateAreaPlacement(KPosition topLeft, KPosition bottomRight, Bounds parentBounds) {
        Point topLeftPoint = topLeft == null ? new Point(0.0f, 0.0f) : PlacementUtil.evaluateKPosition(topLeft, parentBounds, true);
        Point bottomRightPoint = bottomRight == null ? new Point(parentBounds.getWidth(), parentBounds.getHeight()) : PlacementUtil.evaluateKPosition(bottomRight, parentBounds, false);
        return new Bounds(topLeftPoint.x, topLeftPoint.y, bottomRightPoint.x - topLeftPoint.x, bottomRightPoint.y - topLeftPoint.y);
    }

    public static Bounds evaluatePointPlacement(KRendering rendering, KPointPlacementData ppd, Rectangle2D parentBounds) {
        return PlacementUtil.evaluatePointPlacement(rendering, ppd, Bounds.of(parentBounds));
    }

    public static Bounds evaluatePointPlacement(KRendering rendering, KPointPlacementData ppd, Bounds parentBounds) {
        return PlacementUtil.evaluatePointPlacement(ppd, PlacementUtil.basicEstimateSize(rendering, Bounds.of(0.0f, 0.0f)), parentBounds);
    }

    public static Bounds evaluatePointPlacement(KPointPlacementData ppd, Bounds ownBounds, Rectangle2D parentBounds) {
        return PlacementUtil.evaluatePointPlacement(ppd, ownBounds, Bounds.of(parentBounds));
    }

    public static Bounds evaluatePointPlacement(KPointPlacementData ppd, Bounds ownBounds, Bounds parentBounds) {
        float y0;
        float x0;
        if (ppd == null) {
            return new Bounds(parentBounds.getWidth(), parentBounds.getHeight());
        }
        float width = Math.max(ownBounds.getWidth(), ppd.getMinWidth());
        float height = Math.max(ownBounds.getHeight(), ppd.getMinHeight());
        KPosition ref = ppd.getReferencePoint();
        Point refPoint = ref == null ? new Point(0.0f, 0.0f) : PlacementUtil.evaluateKPosition(ref, parentBounds, true);
        switch (ppd.getHorizontalAlignment()) {
            case CENTER: {
                x0 = refPoint.x - width / 2.0f;
                break;
            }
            case RIGHT: {
                x0 = refPoint.x - width;
                break;
            }
            default: {
                x0 = refPoint.x;
            }
        }
        switch (ppd.getVerticalAlignment()) {
            case BOTTOM: {
                y0 = refPoint.y - height;
                break;
            }
            case CENTER: {
                y0 = refPoint.y - height / 2.0f;
                break;
            }
            default: {
                y0 = refPoint.y;
            }
        }
        return Bounds.of(x0, y0, width, height);
    }

    public static Point2D[] evaluatePolylinePlacement(KPolyline line, Bounds parentBounds) {
        if (line.getPoints() == null || line.getPoints().isEmpty()) {
            return new Point2D[]{new Point2D.Float(0.0f, 0.0f)};
        }
        Point2D[] points = new Point2D[line.getPoints().size()];
        int i = 0;
        for (KPosition point : line.getPoints()) {
            points[i++] = PlacementUtil.evaluateKPosition(point, parentBounds, true).toPoint2D();
        }
        return points;
    }

    public static Bounds estimateSize(KNode node) {
        KRendering nodeRendering = (KRendering)node.getData(KRendering.class);
        if (nodeRendering != null) {
            return PlacementUtil.estimateSize(nodeRendering, new Bounds(node.getWidth(), node.getHeight()));
        }
        return new Bounds(0.0f, 0.0f);
    }

    public static Bounds estimateSize(KLabel label) {
        KRendering labelRendering = (KRendering)label.getData(KRendering.class);
        if (labelRendering != null) {
            return PlacementUtil.estimateSize(labelRendering, new Bounds(label.getWidth(), label.getHeight()));
        }
        return PlacementUtil.estimateTextSize(null, label.getText());
    }

    public static Bounds estimateSize(KRendering rendering, Bounds givenBounds) {
        Bounds bounds;
        KPlacementData placementData = KRenderingUtil.getPlacementData((KRendering)rendering);
        int placementDataType = placementData != null ? placementData.eClass().getClassifierID() : -1;
        switch (placementDataType) {
            case 19: 
            case 20: {
                bounds = PlacementUtil.estimateAreaPlacedChildSize(rendering, (KAreaPlacementData)placementData, givenBounds);
                break;
            }
            case 45: {
                bounds = PlacementUtil.estimatePointPlacedChildSize(rendering, (KPointPlacementData)placementData);
                break;
            }
            default: {
                bounds = PlacementUtil.basicEstimateSize(rendering, givenBounds);
            }
        }
        if (rendering instanceof KImage) {
            Bounds imageSize = PlacementUtil.estimateImageSize((KImage)rendering, bounds);
            return imageSize;
        }
        return bounds;
    }

    public static Bounds basicEstimateSize(KRendering rendering, Bounds givenBounds) {
        int id = KRENDERING_PACKAGE.getKText().isInstance((Object)rendering) ? 15 : (KRENDERING_PACKAGE.getKContainerRendering().isInstance((Object)rendering) ? 9 : (KRENDERING_PACKAGE.getKChildArea().isInstance((Object)rendering) ? 14 : (KRENDERING_PACKAGE.getKRenderingRef().isInstance((Object)rendering) ? 13 : 1)));
        switch (id) {
            case 15: {
                return PlacementUtil.estimateTextSize((KText)rendering);
            }
            case 14: {
                return new Bounds(0.0f, 0.0f);
            }
            case 13: {
                return PlacementUtil.basicEstimateSize(((KRenderingRef)rendering).getRendering(), givenBounds);
            }
            case 9: {
                KContainerRendering container = (KContainerRendering)rendering;
                int placementId = container.getChildPlacement() != null ? container.getChildPlacement().eClass().getClassifierID() : -1;
                switch (placementId) {
                    case 17: {
                        return GridPlacementUtil.estimateGridSize(container, givenBounds);
                    }
                }
                Bounds maxSize = new Bounds(givenBounds);
                for (KRendering child : container.getChildren()) {
                    Bounds childSize = PlacementUtil.estimateSize(child, givenBounds);
                    Bounds.max(maxSize, childSize);
                }
                if (container instanceof KPolyline) {
                    Bounds pb = PlacementUtil.evaluatePolylineBounds((KPolyline)rendering, maxSize);
                    Bounds.max(maxSize, pb);
                }
                return maxSize;
            }
        }
        return givenBounds;
    }

    public static Bounds estimateImageSize(KImage image, Bounds imageSize) {
        int pdType;
        KRendering clipShape = image.getClipShape();
        if (clipShape == null) {
            return imageSize;
        }
        KPlacementData pd = image.getPlacementData();
        int n = pdType = pd == null ? 0 : pd.eClass().getClassifierID();
        if (pdType == 45) {
            int cpdType;
            KPlacementData cpd = clipShape.getPlacementData();
            int n2 = cpdType = cpd == null ? 0 : cpd.eClass().getClassifierID();
            if (cpdType == 45) {
                return PlacementUtil.estimatePointPlacedChildSize(clipShape, (KPointPlacementData)cpd);
            }
            if (cpdType == 20) {
                KPointPlacementData ppd = (KPointPlacementData)pd;
                return PlacementUtil.calculateBounds(null, Bounds.of(ppd.getMinWidth(), ppd.getMinHeight()), null, clipShape);
            }
            return imageSize;
        }
        if (pdType == 20) {
            boolean heightModEnabled;
            KAreaPlacementData apd = (KAreaPlacementData)pd;
            KPosition tl = apd.getTopLeft();
            KPosition br = apd.getBottomRight();
            boolean widthModEnabled = tl != null && br != null && tl.getX().eClass() == br.getX().eClass();
            boolean bl = heightModEnabled = tl != null && br != null && tl.getY().eClass() == br.getY().eClass();
            if (widthModEnabled) {
                if (tl.getX().eClass().getClassifierID() == 29) {
                    imageSize.width -= tl.getX().getAbsolute();
                    imageSize.x = 0.0f;
                } else {
                    imageSize.width -= br.getX().getAbsolute();
                    imageSize.x = 0.0f;
                }
            }
            if (heightModEnabled) {
                if (tl.getY().eClass().getClassifierID() == 31) {
                    imageSize.height -= tl.getY().getAbsolute();
                    imageSize.y = 0.0f;
                } else {
                    imageSize.height -= br.getY().getAbsolute();
                    imageSize.y = 0.0f;
                }
            }
            return PlacementUtil.calculateBounds(null, imageSize, null, clipShape);
        }
        return imageSize;
    }

    public static FontData fontDataFor(KLabel kLabel) {
        return PlacementUtil.fontDataFor(kLabel, false);
    }

    public static FontData fontDataFor(KLabel kLabel, boolean setFontLayoutOptions) {
        KRendering rootRendering = (KRendering)Iterators.getNext(ModelingUtil.eAllContentsOfType2((EObject)kLabel, KRendering.class), null);
        UnmodifiableIterator kTexts = Iterators.filter((Iterator)KRenderingUtil.selfAndAllChildren((KRendering)rootRendering), KText.class);
        KText kText = (KText)Iterators.getNext((Iterator)kTexts, null);
        if (setFontLayoutOptions) {
            return PlacementUtil.fontDataFor(kText, (KGraphElement)kLabel);
        }
        return PlacementUtil.fontDataFor(kText, null);
    }

    public static FontData fontDataFor(KText kText) {
        return PlacementUtil.fontDataFor(kText, null);
    }

    private static FontData fontDataFor(KText kText, KGraphElement graphElement) {
        KFontName kFontName = null;
        KFontSize kFontSize = null;
        KFontBold kFontBold = null;
        KFontItalic kFontItalic = null;
        if (kText != null) {
            LinkedList styles = Lists.newLinkedList((Iterable)kText.getStyles());
            for (KRendering k : Iterables2.toIterable(Iterators.filter(ModelingUtil.eAllContainers((EObject)kText), KRendering.class))) {
                Iterables.addAll((Collection)styles, (Iterable)Iterables.filter((Iterable)k.getStyles(), FILTER));
            }
            kFontName = (KFontName)Iterables.getLast((Iterable)Iterables.filter((Iterable)styles, KFontName.class), null);
            kFontSize = (KFontSize)Iterables.getLast((Iterable)Iterables.filter((Iterable)styles, KFontSize.class), null);
            kFontBold = (KFontBold)Iterables.getLast((Iterable)Iterables.filter((Iterable)styles, KFontBold.class), null);
            kFontItalic = (KFontItalic)Iterables.getLast((Iterable)Iterables.filter((Iterable)styles, KFontItalic.class), null);
        }
        String fontName = kFontName != null ? kFontName.getName() : KlighdConstants.DEFAULT_FONT_NAME;
        int fontSize = kFontSize != null ? kFontSize.getSize() : 10;
        int fontStyle = kFontBold != null && kFontBold.isBold() ? 1 : 0;
        int n = fontStyle = kFontItalic != null && kFontItalic.isItalic() ? fontStyle | 2 : fontStyle;
        if (graphElement != null) {
            graphElement.setProperty(CoreOptions.FONT_NAME, (Object)fontName);
            graphElement.setProperty(CoreOptions.FONT_SIZE, (Object)fontSize);
        }
        return new FontData(fontName, fontSize, fontStyle);
    }

    public static Bounds estimateTextSize(KText kText) {
        if (kText.getText() == null) {
            if (kText.hasProperty(KlighdOptions.LABELS_TEXT_OVERRIDE)) {
                return PlacementUtil.estimateTextSize(kText, (String)kText.getProperty(KlighdOptions.LABELS_TEXT_OVERRIDE));
            }
            EObject o = kText.eContainer();
            while (o instanceof KRendering) {
                o = o.eContainer();
            }
            if (o instanceof KLabel) {
                return PlacementUtil.estimateTextSize(kText, ((KLabel)o).getText());
            }
            return PlacementUtil.estimateTextSize(kText, null);
        }
        return PlacementUtil.estimateTextSize(kText, kText.getText());
    }

    public static Bounds estimateTextSize(KText kText, String text) {
        Bounds size = PlacementUtil.getTestingTextSize(kText);
        float[] textWidths = null;
        float[] textHeights = null;
        if (size == null) {
            FontData fontData = PlacementUtil.fontDataFor(kText, null);
            if (Klighd.IS_PLATFORM_RUNNING) {
                size = PlacementUtil.estimateTextSize(fontData, text);
            } else {
                String[] lines = text.split("\n");
                textWidths = new float[lines.length];
                textHeights = new float[lines.length];
                float y = 0.0f;
                float maxWidth = Float.MIN_VALUE;
                float totalHeight = 0.0f;
                int i = 0;
                while (i < lines.length) {
                    Bounds lineSize = PlacementUtil.estimateTextSize(fontData, lines[i]);
                    if (i == 0) {
                        y = lineSize.y;
                    }
                    if (lineSize.width > maxWidth) {
                        maxWidth = lineSize.width;
                    }
                    totalHeight += lineSize.height;
                    textWidths[i] = lineSize.width;
                    textHeights[i] = lineSize.height;
                    ++i;
                }
                size = new Bounds(0.0f, y, maxWidth, totalHeight);
            }
        }
        if (kText != null && textWidths != null && textHeights != null) {
            kText.getProperties().put(KlighdProperties.CALCULATED_TEXT_BOUNDS, (Object)Bounds.of(size));
            kText.getProperties().put(KlighdProperties.CALCULATED_TEXT_LINE_WIDTHS, (Object)textWidths);
            kText.getProperties().put(KlighdProperties.CALCULATED_TEXT_LINE_HEIGHTS, (Object)textHeights);
        }
        return size;
    }

    public static Bounds getTestingTextSize(KText kText) {
        if (kText != null) {
            PersistentEntry testHeight = (PersistentEntry)Iterables.find((Iterable)kText.getPersistentEntries(), KlighdInternalProperties.PRED_TESTING_HEIGHT, null);
            PersistentEntry testWidth = (PersistentEntry)Iterables.find((Iterable)kText.getPersistentEntries(), KlighdInternalProperties.PRED_TESTING_WIDTH, null);
            if (testHeight != null || testWidth != null) {
                float width;
                float height = testHeight != null ? Float.parseFloat(testHeight.getValue()) : 0.0f;
                float f = width = testWidth != null ? Float.parseFloat(testWidth.getValue()) : 0.0f;
                if (height != 0.0f || width != 0.0f) {
                    return new Bounds(width, height);
                }
            }
        }
        return null;
    }

    public static Bounds estimateTextSize(FontData fontData, String text) {
        Display display = null;
        try {
            display = Display.getCurrent();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (gc != null || display != null) {
            return PlacementUtil.estimateTextSizeSWT(fontData, text, display);
        }
        return PlacementUtil.estimateTextSizeAWT(fontData, text);
    }

    private static Bounds estimateTextSizeSWT(FontData fontData, String text, Display display) {
        Bounds textBounds;
        if (gc == null) {
            gc = new GC((Drawable)display);
            gc.setAntialias(0);
            asyncGC = new GC((Drawable)display);
            asyncGC.setAntialias(0);
            org.eclipse.swt.graphics.Point dpi = display.getDPI();
            displayScale = new Point(KlighdConstants.DEFAULT_DISPLAY_DPI / (float)dpi.x, KlighdConstants.DEFAULT_DISPLAY_DPI / (float)dpi.y);
        }
        GC myGC = Display.getCurrent() != null ? gc : asyncGC;
        Font font = FONT_CACHE.get(fontData);
        if (font == null) {
            font = new Font((Device)display, fontData);
            FONT_CACHE.put(fontData, font);
        }
        myGC.setFont(font);
        if (Strings.isNullOrEmpty((String)text)) {
            textBounds = new Bounds(myGC.textExtent(" "));
            textBounds.width = 0.0f;
        } else {
            textBounds = new Bounds(myGC.textExtent(text));
        }
        if (!Klighd.isSuppressDisplayScaleCompensationWhileHandlingText()) {
            textBounds.width *= PlacementUtil.displayScale.x;
            textBounds.height *= PlacementUtil.displayScale.y;
        }
        return textBounds;
    }

    private static Bounds estimateTextSizeAWT(FontData fontData, String text) {
        Bounds textBounds;
        fmg.setFont(new java.awt.Font(fontData.getName(), KTextUtil.swtFontStyle2Awt(fontData.getStyle()), fontData.getHeight()));
        FontMetrics fm = fmg.getFontMetrics();
        if (Strings.isNullOrEmpty((String)text)) {
            textBounds = new Bounds(fm.getStringBounds(" ", fmg));
            textBounds.width = 0.0f;
        } else {
            textBounds = new Bounds(fm.getStringBounds(text, fmg));
        }
        if (Klighd.simulateSwtFontSizeInAwt()) {
            textBounds.width *= PT_TO_PX_FACTOR;
            textBounds.height *= PT_TO_PX_FACTOR;
        }
        return textBounds;
    }

    public static Bounds estimatePointPlacedChildSize(KRendering rendering, KPointPlacementData ppd) {
        Bounds minimalSize = Bounds.of(ppd.getMinWidth(), ppd.getMinHeight());
        Bounds cSize = Bounds.max(minimalSize, PlacementUtil.basicEstimateSize(rendering, minimalSize));
        float requiredWidth = PlacementUtil.getHorizontalSize(ppd, cSize.getWidth());
        float requiredHeight = PlacementUtil.getVerticalSize(ppd, cSize.getHeight());
        return Bounds.of(requiredWidth, requiredHeight);
    }

    private static float getHorizontalSize(KPointPlacementData ppd, float minWidth) {
        if (ppd == null) {
            return minWidth;
        }
        KPosition pos = ppd.getReferencePoint();
        float abs = pos != null && pos.getX() != null ? pos.getX().getAbsolute() : 0.0f;
        float calculatedWidth = 0.0f;
        switch (ppd.getHorizontalAlignment()) {
            case LEFT: 
            case RIGHT: {
                calculatedWidth = abs + minWidth + ppd.getHorizontalMargin();
                break;
            }
            case CENTER: {
                float halfWidth = minWidth / 2.0f;
                calculatedWidth = abs > halfWidth ? abs + halfWidth + ppd.getHorizontalMargin() : minWidth + 2.0f * ppd.getHorizontalMargin();
            }
        }
        return calculatedWidth;
    }

    private static float getVerticalSize(KPointPlacementData ppd, float minHeight) {
        if (ppd == null) {
            return minHeight;
        }
        KPosition pos = ppd.getReferencePoint();
        float abs = pos != null && pos.getY() != null ? pos.getY().getAbsolute() : 0.0f;
        float calculatedHeight = 0.0f;
        switch (ppd.getVerticalAlignment()) {
            case TOP: 
            case BOTTOM: {
                calculatedHeight = abs + minHeight + ppd.getVerticalMargin();
                break;
            }
            case CENTER: {
                float halfHeight = minHeight / 2.0f;
                calculatedHeight = abs > halfHeight ? abs + halfHeight + ppd.getVerticalMargin() : minHeight + 2.0f * ppd.getVerticalMargin();
            }
        }
        return calculatedHeight;
    }

    private static Bounds estimateAreaPlacedChildSize(KRendering rendering, KAreaPlacementData apd, Bounds initialSize) {
        Bounds cSize = PlacementUtil.evaluateAreaPlacement(apd, initialSize);
        Bounds containerMinSize = PlacementUtil.basicEstimateSize(rendering, cSize);
        KPosition tL = apd.getTopLeft();
        KPosition bR = apd.getBottomRight();
        return PlacementUtil.inverselyApplyBoundingBoxKPositions(containerMinSize, tL, bR);
    }

    static Bounds inverselyApplyBoundingBoxKPositions(Bounds innerBounds, KPosition topLeft, KPosition bottomRight) {
        Pair<Float, Float> horSize = PlacementUtil.getHorizontalSize(topLeft, bottomRight);
        Pair<Float, Float> verSize = PlacementUtil.getVerticalSize(topLeft, bottomRight);
        return PlacementUtil.inverselyApplySizeData(innerBounds, horSize, verSize);
    }

    private static Pair<Float, Float> getHorizontalSize(KPosition tL, KPosition bR) {
        int posId1;
        float rel1;
        float abs1;
        int posId0;
        float rel0;
        float abs0;
        if (tL == null) {
            abs0 = 0.0f;
            rel0 = 0.0f;
            posId0 = 0;
        } else {
            KXPosition lPos = KRenderingUtil.toNonNullLeftPosition((KXPosition)tL.getX());
            abs0 = lPos.getAbsolute();
            rel0 = lPos.getRelative();
            int n = posId0 = lPos.eClass().getClassifierID() == 29 ? 0 : 1;
        }
        if (bR == null) {
            abs1 = 0.0f;
            rel1 = 0.0f;
            posId1 = 0;
        } else {
            KXPosition rPos = KRenderingUtil.toNonNullRightPosition((KXPosition)bR.getX());
            abs1 = rPos.getAbsolute();
            rel1 = rPos.getRelative();
            posId1 = rPos.eClass().getClassifierID() == 30 ? 0 : 1;
        }
        return PlacementUtil.getSize(abs0, rel0, posId0, abs1, rel1, posId1);
    }

    private static Pair<Float, Float> getVerticalSize(KPosition tL, KPosition bR) {
        int posId1;
        float rel1;
        float abs1;
        KYPosition rPos;
        int posId0;
        float rel0;
        float abs0;
        if (tL == null) {
            abs0 = 0.0f;
            rel0 = 0.0f;
            posId0 = 0;
        } else {
            rPos = KRenderingUtil.toNonNullTopPosition((KYPosition)tL.getY());
            abs0 = rPos.getAbsolute();
            rel0 = rPos.getRelative();
            int n = posId0 = rPos.eClass().getClassifierID() == 31 ? 0 : 1;
        }
        if (bR == null) {
            abs1 = 0.0f;
            rel1 = 0.0f;
            posId1 = 0;
        } else {
            rPos = KRenderingUtil.toNonNullBottomPosition((KYPosition)bR.getY());
            abs1 = rPos.getAbsolute();
            rel1 = rPos.getRelative();
            posId1 = rPos.eClass().getClassifierID() == 32 ? 0 : 1;
        }
        return PlacementUtil.getSize(abs0, rel0, posId0, abs1, rel1, posId1);
    }

    private static Pair<Float, Float> getSize(float abs0, float rel0, int positionId0, float abs1, float rel1, int positionId1) {
        float absOffset;
        float relWidth;
        int position = positionId0 * 100 + positionId1;
        switch (position) {
            case 0: {
                relWidth = 1.0f - (rel1 + rel0);
                absOffset = abs0 + abs1;
                break;
            }
            case 1: {
                relWidth = rel1 - rel0;
                if (relWidth == 0.0f) {
                    absOffset = abs1;
                    break;
                }
                absOffset = abs0 - abs1;
                break;
            }
            case 100: {
                relWidth = rel0 - rel1;
                if (relWidth == 0.0f) {
                    absOffset = abs0;
                    break;
                }
                absOffset = -abs0 + abs1;
                break;
            }
            case 101: {
                relWidth = rel1 + rel0 - 1.0f;
                absOffset = -abs0 - abs1;
                break;
            }
            default: {
                relWidth = 1.0f;
                absOffset = 0.0f;
            }
        }
        return new Pair((Object)Float.valueOf(absOffset), (Object)Float.valueOf(relWidth));
    }

    private static Bounds inverselyApplySizeData(Bounds bounds, Pair<Float, Float> horSize, Pair<Float, Float> vertSize) {
        float absXOffest = ((Float)horSize.getFirst()).floatValue();
        float relWidth = ((Float)horSize.getSecond()).floatValue();
        float absYOffest = ((Float)vertSize.getFirst()).floatValue();
        float relHeight = ((Float)vertSize.getSecond()).floatValue();
        bounds.width = relWidth == 0.0f ? absXOffest : (bounds.width + absXOffest) / relWidth;
        bounds.height = relHeight == 0.0f ? absYOffest : (bounds.height + absYOffest) / relHeight;
        return bounds;
    }

    public static void calculateInsets(KRendering rootRendering, KInsets insets, Bounds minSize) {
        if (rootRendering == null) {
            return;
        }
        LinkedList path = Lists.newLinkedList();
        if (!PlacementUtil.findChildArea(rootRendering, path)) {
            return;
        }
        Bounds currentBounds = minSize;
        KContainerRendering currentParent = null;
        float leftInset = 0.0f;
        float rightInset = 0.0f;
        float topInset = 0.0f;
        float bottomInset = 0.0f;
        while (!path.isEmpty()) {
            KRendering currentRendering = (KRendering)path.pollFirst();
            Bounds bounds = currentParent == null ? PlacementUtil.calculateBounds(null, currentBounds, null, currentRendering) : PlacementUtil.calculateBounds(currentParent.getChildPlacement(), currentBounds, (List<KRendering>)currentParent.getChildren(), currentRendering);
            leftInset += bounds.x;
            rightInset += currentBounds.width - bounds.x - bounds.width;
            topInset += bounds.y;
            bottomInset += currentBounds.height - bounds.y - bounds.height;
            while (currentRendering instanceof KRenderingRef) {
                KRenderingRef renderingRef = (KRenderingRef)currentRendering;
                currentRendering = renderingRef.getRendering();
                path.removeFirst();
            }
            if (!(currentRendering instanceof KContainerRendering)) continue;
            currentParent = (KContainerRendering)currentRendering;
            currentBounds = bounds;
            currentBounds.x = 0.0f;
            currentBounds.y = 0.0f;
        }
        insets.setLeft(leftInset);
        insets.setRight(rightInset);
        insets.setTop(topInset);
        insets.setBottom(bottomInset);
    }

    private static Bounds calculateBounds(KPlacement placement, final Bounds parentBounds, final List<KRendering> children, final KRendering child) {
        KPlacementData pd;
        KPointPlacementData ppd;
        Bounds bounds = null;
        bounds = placement == null ? ((ppd = KRenderingUtil.asPointPlacementData((KPlacementData)(pd = KRenderingUtil.getPlacementData((KRendering)child)))) != null ? PlacementUtil.evaluatePointPlacement(ppd, PlacementUtil.estimateSize(child, new Bounds(0.0f, 0.0f)), parentBounds) : PlacementUtil.evaluateAreaPlacement(KRenderingUtil.asAreaPlacementData((KPlacementData)pd), parentBounds)) : (Bounds)new KRenderingSwitch<Bounds>(){

            public Bounds caseKGridPlacement(KGridPlacement gridPlacement) {
                Bounds[] childBounds = GridPlacementUtil.evaluateGridPlacement(gridPlacement, children, parentBounds);
                if (childBounds == null) {
                    return Bounds.of(0.0f, 0.0f);
                }
                int index = children.lastIndexOf(child);
                return childBounds[index];
            }
        }.doSwitch((EObject)placement);
        if (child instanceof KPolyline) {
            return PlacementUtil.evaluatePolylineBounds((KPolyline)child, bounds);
        }
        return bounds;
    }

    private static Bounds evaluatePolylineBounds(KPolyline line, Bounds givenBounds) {
        if (line == null || line.getPoints().isEmpty()) {
            return Bounds.of(givenBounds.width, givenBounds.height);
        }
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        for (KPosition polylinePoint : line.getPoints()) {
            Point point = PlacementUtil.evaluateKPosition(polylinePoint, givenBounds, true);
            if (point.x > maxX) {
                maxX = point.x;
            }
            if (!(point.y > maxY)) continue;
            maxY = point.y;
        }
        return Bounds.max(Bounds.of(maxX, maxY), givenBounds);
    }

    public static boolean findChildArea(KRendering rendering, LinkedList<KRendering> path) {
        KRenderingRef renderingReference;
        KRendering referencedRendering;
        path.addLast(rendering);
        if (rendering instanceof KChildArea) {
            return true;
        }
        if (rendering instanceof KContainerRendering) {
            KContainerRendering containerRendering = (KContainerRendering)rendering;
            for (KRendering childRendering : containerRendering.getChildren()) {
                if (!PlacementUtil.findChildArea(childRendering, path)) continue;
                return true;
            }
        } else if (rendering instanceof KRenderingRef && (referencedRendering = (renderingReference = (KRenderingRef)rendering).getRendering()) != null && PlacementUtil.findChildArea(referencedRendering, path)) {
            return true;
        }
        path.removeLast();
        return false;
    }

    public static class Point {
        float x;
        float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public Point(org.eclipse.swt.graphics.Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        public void setLocation(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        public Point2D.Float toPoint2D() {
            return new Point2D.Float(this.x, this.y);
        }

        public KVector toKVector() {
            return new KVector((double)this.x, (double)this.y);
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }
    }

    public static class Triple<A, B, C> {
        private final A a;
        private final B b;
        private final C c;

        public Triple(A theA, B theB, C theC) {
            this.a = theA;
            this.b = theB;
            this.c = theC;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }

        public C getC() {
            return this.c;
        }
    }
}

