/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.microlayout;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.klighd.krendering.KContainerRendering;
import de.cau.cs.kieler.klighd.krendering.KGridPlacement;
import de.cau.cs.kieler.klighd.krendering.KGridPlacementData;
import de.cau.cs.kieler.klighd.krendering.KPlacement;
import de.cau.cs.kieler.klighd.krendering.KPlacementData;
import de.cau.cs.kieler.klighd.krendering.KPosition;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingFactory;
import de.cau.cs.kieler.klighd.krendering.KRenderingUtil;
import de.cau.cs.kieler.klighd.microlayout.Bounds;
import de.cau.cs.kieler.klighd.microlayout.PlacementUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.emf.common.util.EList;

public final class GridPlacementUtil {
    public static final IProperty<GridSizeAssignment> ESTIMATED_GRID_DATA = new Property("klighd.grid.estimatedGridData");
    public static final IProperty<Pair<Integer, Integer>> CHILD_AREA_POSITION = new Property("klighd.grid.childAreaPosition");

    private GridPlacementUtil() {
    }

    public static Bounds[] evaluateGridPlacement(KGridPlacement gridPlacement, List<KRendering> children, Bounds parentBounds) {
        if (parentBounds.isEmpty()) {
            Object[] result = new Bounds[children.size()];
            Arrays.fill(result, Bounds.of(0.0f, 0.0f));
            return result;
        }
        GridPlacer placer = new GridPlacer(gridPlacement, children);
        return placer.evaluate(parentBounds);
    }

    public static Bounds estimateGridSize(KContainerRendering container, Bounds parentBounds) {
        int numRows;
        int numColumns = ((KGridPlacement)container.getChildPlacement()).getNumColumns();
        EList childRenderings = container.getChildren();
        if (numColumns == -1) {
            numColumns = childRenderings.size();
            numRows = 1;
        } else if (numColumns < 2) {
            numColumns = 1;
            numRows = childRenderings.size();
        } else {
            numRows = (childRenderings.size() + numColumns - 1) / numColumns;
        }
        float[] minColumnWidths = new float[numColumns];
        float[] minRowHeights = new float[numRows];
        int childAreaRowId = -1;
        int childAreaColId = -1;
        int k = 0;
        while (k < childRenderings.size()) {
            KRendering currentChild = (KRendering)childRenderings.get(k);
            int row = k / numColumns;
            int col = k - row * numColumns;
            LinkedList path = Lists.newLinkedList();
            if (PlacementUtil.findChildArea(currentChild, path)) {
                childAreaColId = col;
                childAreaRowId = row;
            }
            Bounds cellSize = PlacementUtil.basicEstimateSize(currentChild, new Bounds(0.0f, 0.0f));
            KGridPlacementData gridData = KRenderingUtil.asGridPlacementData((KPlacementData)KRenderingUtil.getPlacementData((KRendering)currentChild));
            if (gridData != null) {
                KPosition topLeft = gridData.getTopLeft();
                KPosition bottomRight = gridData.getBottomRight();
                PlacementUtil.inverselyApplyBoundingBoxKPositions(cellSize, topLeft, bottomRight);
                Bounds.max(cellSize, Bounds.of(gridData.getMinCellWidth(), gridData.getMinCellHeight()));
            }
            minRowHeights[row] = Math.max(minRowHeights[row], cellSize.height);
            minColumnWidths[col] = Math.max(minColumnWidths[col], cellSize.width);
            ++k;
        }
        boolean deliver = container.eDeliver();
        container.eSetDeliver(false);
        GridSizeAssignment pSpacing = (GridSizeAssignment)container.getProperty(ESTIMATED_GRID_DATA);
        if (pSpacing != null) {
            pSpacing.setCalculatedSizes(minColumnWidths, minRowHeights);
        } else {
            container.setProperty(ESTIMATED_GRID_DATA, (Object)new GridSizeAssignment(minColumnWidths, minRowHeights));
        }
        Pair pCAPos = (Pair)container.getProperty(CHILD_AREA_POSITION);
        if (pCAPos != null) {
            pCAPos.setFirst((Object)childAreaColId);
            pCAPos.setSecond((Object)childAreaRowId);
        } else {
            container.setProperty(CHILD_AREA_POSITION, (Object)Pair.of((Object)childAreaColId, (Object)childAreaRowId));
        }
        container.eSetDeliver(deliver);
        Bounds childBounds = new Bounds(0.0f, 0.0f);
        float[] fArray = minColumnWidths;
        int n = minColumnWidths.length;
        int n2 = 0;
        while (n2 < n) {
            float width = fArray[n2];
            childBounds.width += width;
            ++n2;
        }
        fArray = minRowHeights;
        n = minRowHeights.length;
        n2 = 0;
        while (n2 < n) {
            float height = fArray[n2];
            childBounds.height += height;
            ++n2;
        }
        KGridPlacement placement = KRenderingUtil.asGridPlacement((KPlacement)container.getChildPlacement());
        PlacementUtil.inverselyApplyBoundingBoxKPositions(childBounds, placement.getTopLeft(), placement.getBottomRight());
        return childBounds;
    }

    private static class GridPlacer {
        private KContainerRendering parent;
        private KPosition topLeft = null;
        private KPosition bottomRight = null;
        private List<KRendering> children;
        private int numColumns;
        private int numRows;
        private int numFlexibleCols = 0;
        private int numFlexibleRows = 0;
        private boolean[] flexibleCols;
        private boolean[] flexibleRows;
        private float minOverallWidth = 0.0f;
        private float minOverallHeight = 0.0f;
        private float[] columnMaxMinWidth;
        private float[] rowMaxMinHeight;
        private float[] calculatedRowHeight;
        private float[] calculatedColumnWidth;
        private static final float TOLERANCE = 0.1f;

        GridPlacer(KGridPlacement gridPlacement, List<KRendering> children) {
            GridSizeAssignment estimatedSpacing;
            this.parent = (KContainerRendering)gridPlacement.eContainer();
            this.children = children;
            if (children.size() == 0) {
                return;
            }
            int setColumns = gridPlacement.getNumColumns();
            this.topLeft = gridPlacement.getTopLeft();
            this.bottomRight = gridPlacement.getBottomRight();
            this.numColumns = setColumns == -1 ? children.size() : (setColumns < 1 ? 1 : gridPlacement.getNumColumns());
            this.numRows = (children.size() - 1) / this.numColumns + 1;
            this.flexibleCols = new boolean[this.numColumns];
            this.flexibleRows = new boolean[this.numRows];
            GridSizeAssignment spacingProperty = (GridSizeAssignment)this.parent.getProperty(ESTIMATED_GRID_DATA);
            boolean gridSizingAvailable = spacingProperty != null;
            GridSizeAssignment gridSizeAssignment = estimatedSpacing = !gridSizingAvailable ? null : new GridSizeAssignment(spacingProperty);
            if (gridSizingAvailable) {
                this.calculatedColumnWidth = (float[])estimatedSpacing.getCalculatedColumnWidths().clone();
                this.calculatedRowHeight = (float[])estimatedSpacing.getCalculatedRowHeights().clone();
            }
            if (this.columnMaxMinWidth == null) {
                this.columnMaxMinWidth = new float[this.numColumns];
                Arrays.fill(this.columnMaxMinWidth, 0.0f);
            }
            if (this.rowMaxMinHeight == null) {
                this.rowMaxMinHeight = new float[this.numRows];
                Arrays.fill(this.rowMaxMinHeight, 0.0f);
            }
            Arrays.fill(this.flexibleCols, true);
            Arrays.fill(this.flexibleRows, true);
            int i = 0;
            while (i < children.size()) {
                Bounds childMinSize;
                KRendering r = children.get(i);
                int column = i % this.numColumns;
                int row = i / this.numColumns;
                KGridPlacementData gpd = KRenderingUtil.asGridPlacementData((KPlacementData)KRenderingUtil.getPlacementData((KRendering)r));
                if (gpd == null) {
                    gpd = KRenderingFactory.eINSTANCE.createKGridPlacementData();
                }
                if (gridSizingAvailable) {
                    childMinSize = Bounds.of(estimatedSpacing.calculatedColumnWidths[column], estimatedSpacing.calculatedRowHeights[row]);
                } else {
                    childMinSize = PlacementUtil.basicEstimateSize(r, new Bounds(0.0f, 0.0f));
                    PlacementUtil.inverselyApplyBoundingBoxKPositions(childMinSize, gpd.getTopLeft(), gpd.getBottomRight());
                }
                int n = column;
                this.flexibleCols[n] = this.flexibleCols[n] & gpd.getFlexibleWidth();
                int n2 = row;
                this.flexibleRows[n2] = this.flexibleRows[n2] & gpd.getFlexibleHeight();
                this.columnMaxMinWidth[column] = ElkMath.maxf((float[])new float[]{gpd.getMinCellWidth(), childMinSize.width, this.columnMaxMinWidth[column]});
                this.rowMaxMinHeight[row] = ElkMath.maxf((float[])new float[]{gpd.getMinCellHeight(), childMinSize.height, this.rowMaxMinHeight[row]});
                ++i;
            }
            i = 0;
            while (i < this.numColumns) {
                this.minOverallWidth += this.columnMaxMinWidth[i];
                this.numFlexibleCols += this.flexibleCols[i] ? 1 : 0;
                ++i;
            }
            i = 0;
            while (i < this.numRows) {
                this.minOverallHeight += this.rowMaxMinHeight[i];
                this.numFlexibleRows += this.flexibleRows[i] ? 1 : 0;
                ++i;
            }
        }

        public Bounds[] evaluate(Bounds parentBounds) {
            if (this.children.size() == 0) {
                return new Bounds[0];
            }
            Object[] bounds = new Bounds[this.children.size()];
            if (parentBounds.width == 0.0f || parentBounds.height == 0.0f) {
                Arrays.fill(bounds, new Bounds(0.0f, 0.0f));
                return bounds;
            }
            if (this.parent.getProperty(ESTIMATED_GRID_DATA) == null) {
                GridPlacementUtil.estimateGridSize(this.parent, parentBounds);
            }
            GridSizeAssignment estimatedGrid = (GridSizeAssignment)this.parent.getProperty(ESTIMATED_GRID_DATA);
            Pair childAreaPosition = (Pair)this.parent.getProperty(CHILD_AREA_POSITION);
            int width = 0;
            int height = 0;
            float widthScale = 1.0f;
            float heightScale = 1.0f;
            if (estimatedGrid != null) {
                int i = 0;
                while (i < estimatedGrid.getCalculatedColumnWidths().length) {
                    width = (int)((float)width + estimatedGrid.getCalculatedColumnWidths()[i]);
                    ++i;
                }
                i = 0;
                while (i < estimatedGrid.getCalculatedRowHeights().length) {
                    height = (int)((float)height + estimatedGrid.getCalculatedRowHeights()[i]);
                    ++i;
                }
            }
            Bounds gridBounds = PlacementUtil.evaluateAreaPlacement(this.topLeft, this.bottomRight, parentBounds);
            if (childAreaPosition != null && (Integer)childAreaPosition.getFirst() > -1 && (Integer)childAreaPosition.getSecond() > -1) {
                if (estimatedGrid != null) {
                    this.calculatedColumnWidth = (float[])estimatedGrid.getCalculatedColumnWidths().clone();
                    this.calculatedRowHeight = (float[])estimatedGrid.getCalculatedRowHeights().clone();
                    if (gridBounds.width - (float)width > 0.1f && (Integer)childAreaPosition.getFirst() < this.numColumns) {
                        int n = (Integer)childAreaPosition.getFirst();
                        this.calculatedColumnWidth[n] = this.calculatedColumnWidth[n] + (gridBounds.width - (float)width);
                    }
                    if (gridBounds.height - (float)height > 0.1f && (Integer)childAreaPosition.getSecond() < this.numRows) {
                        int n = (Integer)childAreaPosition.getSecond();
                        this.calculatedRowHeight[n] = this.calculatedRowHeight[n] + (gridBounds.height - (float)height);
                    }
                } else {
                    boolean[] tempFlexibleCols = new boolean[this.flexibleCols.length];
                    tempFlexibleCols[((Integer)childAreaPosition.getFirst()).intValue()] = true;
                    boolean[] tempFlexibleRows = new boolean[this.flexibleRows.length];
                    tempFlexibleRows[((Integer)childAreaPosition.getSecond()).intValue()] = true;
                    this.calculatedColumnWidth = this.computeCellSizes(gridBounds.width, this.minOverallWidth, this.columnMaxMinWidth, 1.0f, tempFlexibleCols);
                    this.calculatedRowHeight = this.computeCellSizes(gridBounds.height, this.minOverallHeight, this.rowMaxMinHeight, 1.0f, tempFlexibleRows);
                }
            } else {
                this.calculatedColumnWidth = this.computeCellSizes(gridBounds.width, this.minOverallWidth, this.columnMaxMinWidth, this.numFlexibleCols, this.flexibleCols);
                this.calculatedRowHeight = this.computeCellSizes(gridBounds.height, this.minOverallHeight, this.rowMaxMinHeight, this.numFlexibleRows, this.flexibleRows);
            }
            float startX = gridBounds.x;
            float startY = gridBounds.y;
            float currentX = startX;
            float currentY = startY;
            int i = 0;
            while (i < this.children.size()) {
                KGridPlacementData gpd = KRenderingUtil.asGridPlacementData((KPlacementData)KRenderingUtil.getPlacementData((KRendering)this.children.get(i)));
                int column = i % this.numColumns;
                int row = i / this.numColumns;
                Bounds cellBounds = Bounds.of(this.calculatedColumnWidth[column], this.calculatedRowHeight[row]);
                Bounds localBounds = gpd == null ? cellBounds : PlacementUtil.evaluateAreaPlacement(gpd.getTopLeft(), gpd.getBottomRight(), cellBounds);
                bounds[i] = localBounds.move(currentX, currentY);
                currentX += cellBounds.width * 1.0f;
                if (column == this.numColumns - 1) {
                    currentY += cellBounds.height * 1.0f;
                    currentX = startX;
                }
                ++i;
            }
            return bounds;
        }

        private float[] computeCellSizes(float availableSize, float requiredSize, float[] requiredSizes, float countFlexibleSizes, boolean[] flexibleSizes) {
            boolean overSized;
            float[] result = new float[requiredSizes.length];
            float overSize = availableSize - requiredSize;
            boolean bl = overSized = overSize > 0.0f;
            float overSizeShare = !overSized ? 0.0f : overSize / (countFlexibleSizes == 0.0f ? 1.0f : countFlexibleSizes);
            float remainingSize = availableSize;
            int i = 0;
            while (i < requiredSizes.length) {
                if (!(remainingSize >= 0.0f)) break;
                result[i] = requiredSizes[i];
                if (overSized && (flexibleSizes[i] || countFlexibleSizes == 0.0f && i + 1 == requiredSizes.length)) {
                    int n = i;
                    result[n] = result[n] + overSizeShare;
                }
                remainingSize -= result[i];
                ++i;
            }
            return result;
        }
    }

    private static class GridSizeAssignment {
        private float[] calculatedColumnWidths;
        private float[] calculatedRowHeights;

        GridSizeAssignment(GridSizeAssignment other) {
            this.calculatedColumnWidths = other == null ? null : (float[])other.calculatedColumnWidths.clone();
            this.calculatedRowHeights = other == null ? null : (float[])other.calculatedRowHeights.clone();
        }

        GridSizeAssignment(float[] cols, float[] rows) {
            this.calculatedColumnWidths = cols;
            this.calculatedRowHeights = rows;
        }

        public void setCalculatedSizes(float[] cols, float[] rows) {
            this.calculatedColumnWidths = cols;
            this.calculatedRowHeights = rows;
        }

        public float[] getCalculatedColumnWidths() {
            return this.calculatedColumnWidths;
        }

        public float[] getCalculatedRowHeights() {
            return this.calculatedRowHeights;
        }

        public String toString() {
            return "(Widths = " + Arrays.toString(this.calculatedColumnWidths) + ", Height = " + Arrays.toString(this.calculatedRowHeights) + ")";
        }
    }
}

