/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.microlayout;

import de.cau.cs.kieler.klighd.krendering.KDecoratorPlacementData;
import de.cau.cs.kieler.klighd.krendering.KPlacementData;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingRef;
import de.cau.cs.kieler.klighd.krendering.KRenderingUtil;
import de.cau.cs.kieler.klighd.microlayout.Bounds;
import de.cau.cs.kieler.klighd.util.MathUtil;
import java.awt.geom.Point2D;
import org.eclipse.elk.core.util.Pair;

public final class DecoratorPlacementUtil {
    private DecoratorPlacementUtil() {
    }

    public static Decoration evaluateDecoratorPlacement(KDecoratorPlacementData dpd, Point2D[] path) {
        Decoration decoration = new Decoration();
        Point2D[] points = null;
        if (path != null) {
            points = path;
        }
        if (points == null) {
            points = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0)};
        }
        if (dpd == null) {
            decoration.origin = (Point2D)points[0].clone();
            decoration.bounds = new Bounds(0.0f, 0.0f);
            decoration.rotation = 0.0f;
            return decoration;
        }
        Pair<Integer, Point2D> result = MathUtil.getSegmentStartIndexAndPoint(points, dpd.getAbsolute(), dpd.getRelative());
        decoration.origin = (Point2D)result.getSecond();
        decoration.bounds = new Bounds(dpd.getXOffset(), dpd.getYOffset(), dpd.getWidth(), dpd.getHeight());
        if (dpd.isRotateWithLine() && points.length > 1) {
            int segmentStart = (Integer)result.getFirst();
            decoration.rotation = (float)MathUtil.angle(points[segmentStart], points[segmentStart + 1]);
        } else {
            decoration.rotation = 0.0f;
        }
        return decoration;
    }

    public static KDecoratorPlacementData asDecoratorPlacementData(KPlacementData data) {
        if (data instanceof KDecoratorPlacementData) {
            return (KDecoratorPlacementData)data;
        }
        return null;
    }

    public static KDecoratorPlacementData getDecoratorPlacementData(KRendering rendering) {
        KDecoratorPlacementData data = DecoratorPlacementUtil.asDecoratorPlacementData(KRenderingUtil.getPlacementData((KRendering)rendering));
        if (data == null && rendering instanceof KRenderingRef) {
            return DecoratorPlacementUtil.getDecoratorPlacementData(((KRenderingRef)rendering).getRendering());
        }
        return data;
    }

    public static class Decoration {
        private Point2D origin;
        private Bounds bounds;
        private float rotation;

        public final Point2D getOrigin() {
            return this.origin;
        }

        public final Bounds getBounds() {
            return this.bounds;
        }

        public final double getRotation() {
            return this.rotation;
        }
    }
}

