/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.microlayout;

import de.cau.cs.kieler.klighd.kgraph.KGraphFactory;
import de.cau.cs.kieler.klighd.kgraph.KInsets;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.swt.graphics.Point;

public class Bounds {
    float x;
    float y;
    float width;
    float height;
    KInsets insets = null;

    public Bounds(float width, float height) {
        this.x = 0.0f;
        this.y = 0.0f;
        this.width = width;
        this.height = height;
        this.insets = KGraphFactory.eINSTANCE.createKInsets();
    }

    public Bounds(double width, double height) {
        this.x = 0.0f;
        this.y = 0.0f;
        this.width = (float)width;
        this.height = (float)height;
        this.insets = KGraphFactory.eINSTANCE.createKInsets();
    }

    public Bounds(Bounds bounds) {
        this.x = bounds.x;
        this.y = bounds.y;
        this.width = bounds.width;
        this.height = bounds.height;
        this.insets = KGraphFactory.eINSTANCE.createKInsets();
    }

    public Bounds(Point point) {
        this.width = point.x;
        this.height = point.y;
        this.insets = KGraphFactory.eINSTANCE.createKInsets();
    }

    public Bounds(Rectangle2D.Float rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
        this.insets = KGraphFactory.eINSTANCE.createKInsets();
    }

    public Bounds(Rectangle2D rect) {
        this.x = (float)rect.getX();
        this.y = (float)rect.getY();
        this.width = (float)rect.getWidth();
        this.height = (float)rect.getHeight();
        this.insets = KGraphFactory.eINSTANCE.createKInsets();
    }

    public Bounds(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.insets = KGraphFactory.eINSTANCE.createKInsets();
    }

    void setBounds(Bounds bounds) {
        this.x = bounds.x;
        this.y = bounds.y;
        this.width = bounds.width;
        this.height = bounds.height;
        this.insets = KGraphFactory.eINSTANCE.createKInsets();
    }

    void setBounds(Rectangle2D bounds) {
        this.x = (float)bounds.getX();
        this.y = (float)bounds.getY();
        this.width = (float)bounds.getWidth();
        this.height = (float)bounds.getHeight();
        this.insets = KGraphFactory.eINSTANCE.createKInsets();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isEmpty() {
        return this.width == 0.0f && this.height == 0.0f;
    }

    public Bounds move(float horDir, float vertDir) {
        this.x += horDir;
        this.y += vertDir;
        return this;
    }

    public Rectangle2D toRectangle2D() {
        return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
    }

    public Ellipse2D toEllipse2D() {
        return new Ellipse2D.Float(this.x, this.y, this.width, this.height);
    }

    public <S extends RectangularShape> S setBoundsOf(S shape) {
        shape.setFrame(this.x, this.y, this.width, this.height);
        return shape;
    }

    public KInsets getInsets() {
        return this.insets;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "|" + this.width + "," + this.height + ")";
    }

    public static Pair<Boolean, Boolean> compare(Bounds b1, Bounds b2) {
        return Bounds.compare(b1, b2, 0.0f);
    }

    public static Pair<Boolean, Boolean> compare(Bounds b1, Bounds b2, float delta) {
        boolean widthEqual = Math.abs(b1.width - b2.width) <= delta;
        boolean heightEqual = Math.abs(b1.height - b2.height) <= delta;
        return Pair.of((Object)widthEqual, (Object)heightEqual);
    }

    public static Bounds max(Bounds b1, Bounds b2) {
        b1.width = Math.max(b1.width, b2.width);
        b1.height = Math.max(b1.height, b2.height);
        return b1;
    }

    public static Bounds min(Bounds b1, Bounds b2) {
        b1.width = Math.min(b1.width, b2.width);
        b1.height = Math.min(b1.height, b2.height);
        return b1;
    }

    public static Bounds of(Bounds bounds) {
        return new Bounds(bounds);
    }

    public static Bounds of(float width, float height) {
        return new Bounds(width, height);
    }

    public static Bounds of(float x, float y, float width, float height) {
        return new Bounds(x, y, width, height);
    }

    public static Bounds of(Rectangle2D rect) {
        return new Bounds(rect);
    }

    public static Bounds of(KVector sizeVector) {
        return new Bounds(sizeVector.x, sizeVector.y);
    }

    public static Bounds immutableCopy(Bounds bounds) {
        return new ImmutableBounds(bounds);
    }

    public static class ImmutableBounds
    extends Bounds {
        private static final String MSG = "This bounds object is immutable! Modifying is not allowed.";

        public ImmutableBounds(float width, float height) {
            super(width, height);
        }

        public ImmutableBounds(double width, double height) {
            super(width, height);
        }

        public ImmutableBounds(Bounds bounds) {
            super(bounds);
        }

        @Override
        void setBounds(Bounds bounds) {
            throw new UnsupportedOperationException(MSG);
        }

        @Override
        void setBounds(Rectangle2D rect) {
            throw new UnsupportedOperationException(MSG);
        }

        @Override
        public Bounds move(float hor, float vert) {
            throw new UnsupportedOperationException(MSG);
        }
    }
}

