/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.labels.management;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.klighd.labels.management.AbstractKlighdLabelManager;
import java.util.List;
import java.util.Objects;
import org.eclipse.elk.graph.ElkLabel;

public class ListLabelManager
extends AbstractKlighdLabelManager {
    private final List<AbstractKlighdLabelManager> labelManagers = Lists.newArrayList();
    private boolean stopOnFirstHit = true;

    public ListLabelManager withStopOnFirstHit(boolean stop) {
        this.stopOnFirstHit = stop;
        return this;
    }

    public ListLabelManager addLabelManager(AbstractKlighdLabelManager manager) {
        Objects.requireNonNull(manager, "The label manager cannot be null");
        this.labelManagers.add(manager);
        return this;
    }

    public List<AbstractKlighdLabelManager> getLabelManagers() {
        return this.labelManagers;
    }

    @Override
    public AbstractKlighdLabelManager.Result doResizeLabel(ElkLabel label, double targetWidth) {
        String newLabelText = null;
        boolean foundActiveLabelManager = false;
        for (AbstractKlighdLabelManager manager : this.labelManagers) {
            AbstractKlighdLabelManager.Result result = manager.manageElkLabelSize(label, targetWidth);
            if (result.isUnmodified()) {
                foundActiveLabelManager = true;
                continue;
            }
            if (!result.isModified()) continue;
            foundActiveLabelManager = true;
            newLabelText = result.getNewText();
            label.setText(newLabelText);
            if (this.stopOnFirstHit) break;
        }
        if (foundActiveLabelManager) {
            if (newLabelText == null) {
                return AbstractKlighdLabelManager.Result.unmodified();
            }
            return AbstractKlighdLabelManager.Result.modified(newLabelText);
        }
        return AbstractKlighdLabelManager.Result.inactive();
    }
}

