/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.labels.management;

import de.cau.cs.kieler.klighd.KlighdOptions;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingOptions;
import de.cau.cs.kieler.klighd.krendering.KRenderingRef;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.labels.management.LabelManagementResult;
import de.cau.cs.kieler.klighd.labels.management.LabelManagementUtil;
import de.cau.cs.kieler.klighd.microlayout.Bounds;
import de.cau.cs.kieler.klighd.microlayout.PlacementUtil;
import org.eclipse.elk.core.labels.ILabelManager;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.graph.ElkLabel;

public abstract class AbstractKlighdLabelManager
implements ILabelManager {
    public static final double NO_FIXED_TARGET_WIDTH = -1.0;
    private boolean active = true;
    private Mode mode = Mode.TARGET_WIDTH;
    private double fixedTargetWidth = -1.0;

    public final AbstractKlighdLabelManager setActive(boolean isActive) {
        this.active = isActive;
        return this;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final Mode getMode() {
        return this.mode;
    }

    public final AbstractKlighdLabelManager setMode(Mode newMode) {
        this.mode = newMode;
        return this;
    }

    public final double getFixedTargetWidth() {
        return this.fixedTargetWidth;
    }

    public final AbstractKlighdLabelManager setFixedTargetWidth(double targetWidth) {
        this.fixedTargetWidth = targetWidth < 0.0 ? -1.0 : targetWidth;
        return this;
    }

    public final KVector manageLabelSize(Object label, double targetWidth) {
        if (label instanceof ElkLabel) {
            ElkLabel elkLabel = (ElkLabel)label;
            double effectiveTargetWidth = this.fixedTargetWidth != -1.0 ? this.fixedTargetWidth : targetWidth;
            Result managementResult = this.manageElkLabelSize(elkLabel, effectiveTargetWidth);
            if (managementResult.isUnmodified()) {
                elkLabel.setProperty(KlighdOptions.LABELS_MANAGEMENT_RESULT, (Object)LabelManagementResult.MANAGED_UNMODIFIED);
                return this.calculateFinalLabelSize(elkLabel, elkLabel.getText());
            }
            if (managementResult.isModified()) {
                elkLabel.setProperty(KlighdOptions.LABELS_MANAGEMENT_RESULT, (Object)LabelManagementResult.MANAGED_MODIFIED);
                elkLabel.setText(managementResult.getNewText());
                return this.calculateFinalLabelSize(elkLabel, elkLabel.getText());
            }
            return null;
        }
        return null;
    }

    private KVector calculateFinalLabelSize(ElkLabel elkLabel, String text) {
        KRendering rootRendering = (KRendering)elkLabel.getProperty(KRenderingOptions.K_RENDERING);
        if (rootRendering instanceof KRenderingRef) {
            rootRendering = ((KRenderingRef)rootRendering).getRendering();
        }
        Bounds newSize = null;
        if (rootRendering instanceof KText) {
            newSize = PlacementUtil.estimateTextSize((KText)rootRendering, text);
        } else {
            KText kText = LabelManagementUtil.ktextFor(elkLabel);
            kText.setProperty(KlighdOptions.LABELS_TEXT_OVERRIDE, (Object)text);
            newSize = PlacementUtil.estimateSize(rootRendering, new Bounds(0.0f, 0.0f));
            kText.setProperty(KlighdOptions.LABELS_TEXT_OVERRIDE, null);
        }
        if (newSize != null) {
            return new KVector((double)newSize.getWidth(), (double)newSize.getHeight());
        }
        return new KVector();
    }

    protected final boolean isInContext(ElkLabel label) {
        return (Boolean)label.getProperty(KlighdOptions.LABELS_ELEMENT_IN_FOCUS) == false;
    }

    protected Result manageElkLabelSize(ElkLabel label, double targetWidth) {
        if (this.isActive()) {
            if (this.isInContext(label)) {
                return this.doResizeLabel(label, targetWidth);
            }
            return Result.unmodified();
        }
        return Result.inactive();
    }

    protected Result doResizeLabel(ElkLabel label, double targetWidth) {
        return Result.unmodified();
    }

    public static enum Mode {
        TARGET_WIDTH,
        ALWAYS_ON;

    }

    public static final class Result {
        private static final Result RESULT_INACTIVE = new Result(LabelManagementResult.UNMANAGED, null);
        private static final Result RESULT_UNMODIFIED = new Result(LabelManagementResult.MANAGED_UNMODIFIED, null);
        private final LabelManagementResult result;
        private final String newText;

        private Result(LabelManagementResult result, String newText) {
            this.result = result;
            this.newText = newText;
        }

        public static Result inactive() {
            return RESULT_INACTIVE;
        }

        public static Result unmodified() {
            return RESULT_UNMODIFIED;
        }

        public static Result modified(String text) {
            return new Result(LabelManagementResult.MANAGED_MODIFIED, text);
        }

        public boolean isInactive() {
            return this.result == LabelManagementResult.UNMANAGED;
        }

        public boolean isUnmodified() {
            return this.result == LabelManagementResult.MANAGED_UNMODIFIED;
        }

        public boolean isModified() {
            return this.result == LabelManagementResult.MANAGED_MODIFIED;
        }

        public String getNewText() {
            return this.newText;
        }
    }
}

