/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.labels.decoration;

import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.krendering.KBackground;
import de.cau.cs.kieler.klighd.krendering.KContainerRendering;
import de.cau.cs.kieler.klighd.krendering.KForeground;
import de.cau.cs.kieler.klighd.krendering.KPolygon;
import de.cau.cs.kieler.klighd.krendering.KPosition;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KXPosition;
import de.cau.cs.kieler.klighd.krendering.KYPosition;
import de.cau.cs.kieler.klighd.labels.decoration.AbstractDecoratorRenderingProvider;
import de.cau.cs.kieler.klighd.labels.decoration.EdgeLabelStyleModifier;
import de.cau.cs.kieler.klighd.labels.decoration.LabelDecorationConfigurator;
import org.eclipse.elk.core.math.ElkPadding;

public final class DirectionalArrowsDecorator
extends AbstractDecoratorRenderingProvider {
    private Color arrowColor = new Color();

    private DirectionalArrowsDecorator() {
    }

    public static DirectionalArrowsDecorator create() {
        return new DirectionalArrowsDecorator();
    }

    public DirectionalArrowsDecorator withColor(int r, int g, int b, int a) {
        this.arrowColor.r = r;
        this.arrowColor.g = g;
        this.arrowColor.b = b;
        this.arrowColor.a = a;
        return this;
    }

    public DirectionalArrowsDecorator withColor(java.awt.Color color) {
        this.arrowColor.r = color.getRed();
        this.arrowColor.g = color.getGreen();
        this.arrowColor.b = color.getBlue();
        this.arrowColor.a = color.getAlpha();
        return this;
    }

    @Override
    public ElkPadding createDecoratorRendering(KContainerRendering container, KLabel label, LabelDecorationConfigurator.LayoutMode layoutMode) {
        boolean leftRight;
        boolean topBottom = layoutMode != LabelDecorationConfigurator.LayoutMode.HORIZONTAL;
        boolean bl = leftRight = layoutMode != LabelDecorationConfigurator.LayoutMode.VERTICAL;
        if (topBottom) {
            container.getChildren().add((Object)this.createUpArrow());
            container.getChildren().add((Object)this.createDownArrow());
        }
        if (leftRight) {
            container.getChildren().add((Object)this.createLeftArrow());
            container.getChildren().add((Object)this.createRightArrow());
        }
        return new ElkPadding();
    }

    private KRendering createLeftArrow() {
        KPolygon arrow = this.createInitializedPolygon();
        this.addPoint(arrow, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(-4.0f, 0.5f));
        this.addPoint(arrow, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(4.0f, 0.5f));
        this.addPoint(arrow, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.5f));
        this.addPoint(arrow, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(-4.0f, 0.5f));
        this.setPlacement((KRendering)arrow, (KXPosition<?>)this.left(-4.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f), (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        EdgeLabelStyleModifier.install((KRendering)arrow, EdgeLabelStyleModifier.Visibility.DIRECTION_LEFT);
        return arrow;
    }

    private KRendering createRightArrow() {
        KPolygon arrow = this.createInitializedPolygon();
        this.addPoint(arrow, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(-4.0f, 0.5f));
        this.addPoint(arrow, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(4.0f, 0.5f));
        this.addPoint(arrow, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.5f));
        this.addPoint(arrow, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(-4.0f, 0.5f));
        this.setPlacement((KRendering)arrow, (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f), (KXPosition<?>)this.right(-4.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        EdgeLabelStyleModifier.install((KRendering)arrow, EdgeLabelStyleModifier.Visibility.DIRECTION_RIGHT);
        return arrow;
    }

    private KRendering createUpArrow() {
        KPolygon arrow = this.createInitializedPolygon();
        this.addPoint(arrow, (KXPosition<?>)this.left(-4.0f, 0.5f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        this.addPoint(arrow, (KXPosition<?>)this.left(4.0f, 0.5f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        this.addPoint(arrow, (KXPosition<?>)this.right(0.0f, 0.5f), (KYPosition<?>)this.top(0.0f, 0.0f));
        this.addPoint(arrow, (KXPosition<?>)this.left(-4.0f, 0.5f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        this.setPlacement((KRendering)arrow, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.top(-4.0f, 0.0f), (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.top(0.0f, 0.0f));
        EdgeLabelStyleModifier.install((KRendering)arrow, EdgeLabelStyleModifier.Visibility.DIRECTION_UP);
        return arrow;
    }

    private KRendering createDownArrow() {
        KPolygon arrow = this.createInitializedPolygon();
        this.addPoint(arrow, (KXPosition<?>)this.left(-4.0f, 0.5f), (KYPosition<?>)this.top(0.0f, 0.0f));
        this.addPoint(arrow, (KXPosition<?>)this.left(4.0f, 0.5f), (KYPosition<?>)this.top(0.0f, 0.0f));
        this.addPoint(arrow, (KXPosition<?>)this.right(0.0f, 0.5f), (KYPosition<?>)this.bottom(0.0f, 0.0f));
        this.addPoint(arrow, (KXPosition<?>)this.left(-4.0f, 0.5f), (KYPosition<?>)this.top(0.0f, 0.0f));
        this.setPlacement((KRendering)arrow, (KXPosition<?>)this.left(0.0f, 0.0f), (KYPosition<?>)this.bottom(0.0f, 0.0f), (KXPosition<?>)this.right(0.0f, 0.0f), (KYPosition<?>)this.bottom(-4.0f, 0.0f));
        EdgeLabelStyleModifier.install((KRendering)arrow, EdgeLabelStyleModifier.Visibility.DIRECTION_DOWN);
        return arrow;
    }

    private KPolygon createInitializedPolygon() {
        KPolygon poly = R_FACTORY.createKPolygon();
        KBackground bg = R_FACTORY.createKBackground();
        poly.getStyles().add((Object)bg);
        bg.setColor(this.arrowColor.r, this.arrowColor.g, this.arrowColor.b, this.arrowColor.a);
        KForeground fg = R_FACTORY.createKForeground();
        poly.getStyles().add((Object)fg);
        fg.setColor(this.arrowColor.r, this.arrowColor.g, this.arrowColor.b, this.arrowColor.a);
        return poly;
    }

    private void addPoint(KPolygon poly, KXPosition<?> xPos, KYPosition<?> yPos) {
        KPosition pos = R_FACTORY.createKPosition();
        pos.setX(xPos);
        pos.setY(yPos);
        poly.getPoints().add((Object)pos);
    }

    private static class Color {
        private int r = 0;
        private int g = 0;
        private int b = 0;
        private int a = 255;

        private Color() {
        }
    }
}

