/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.internal.preferences;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.klighd.IKlighdPreferenceStore;
import de.cau.cs.kieler.klighd.internal.preferences.PreferenceInitializer;
import java.util.HashMap;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class KlighdPlainPreferenceStore
implements IKlighdPreferenceStore {
    private final HashMap<Object, Object> values = Maps.newHashMap();
    private final HashMap<Object, Object> defaults = Maps.newHashMap();

    public KlighdPlainPreferenceStore() {
        new PreferenceInitializer().initializeDefaultPreferences(this);
    }

    @Override
    public boolean getBoolean(String preferenceId) {
        Object value = this.values.get(preferenceId);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof Boolean ? (Boolean)defaultValue : false;
    }

    @Override
    public double getDouble(String preferenceId) {
        Object value = this.values.get(preferenceId);
        if (value instanceof Double) {
            return (Double)value;
        }
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof Double ? (Double)defaultValue : 0.0;
    }

    @Override
    public float getFloat(String preferenceId) {
        Object value = this.values.get(preferenceId);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof Float ? ((Float)defaultValue).floatValue() : 0.0f;
    }

    @Override
    public int getInt(String preferenceId) {
        Object value = this.values.get(preferenceId);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof Integer ? (Integer)defaultValue : 0;
    }

    @Override
    public long getLong(String preferenceId) {
        Object value = this.values.get(preferenceId);
        if (value instanceof Long) {
            return (Long)value;
        }
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof Long ? (Long)defaultValue : 0L;
    }

    @Override
    public String getString(String preferenceId) {
        Object value = this.values.get(preferenceId);
        if (value instanceof Integer) {
            return (String)value;
        }
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof String ? (String)defaultValue : "";
    }

    @Override
    public void setValue(String preferenceId, boolean value) {
        this.values.put(preferenceId, value);
    }

    @Override
    public void setValue(String preferenceId, double value) {
        this.values.put(preferenceId, value);
    }

    @Override
    public void setValue(String preferenceId, float value) {
        this.values.put(preferenceId, Float.valueOf(value));
    }

    @Override
    public void setValue(String preferenceId, int value) {
        this.values.put(preferenceId, value);
    }

    @Override
    public void setValue(String preferenceId, long value) {
        this.values.put(preferenceId, value);
    }

    @Override
    public void setValue(String preferenceId, String value) {
        this.values.put(preferenceId, value);
    }

    @Override
    public boolean isDefault(String preferenceId) {
        return !this.values.containsKey(preferenceId) && this.defaults.containsKey(preferenceId) || this.defaults.containsKey(preferenceId) && this.defaults.get(preferenceId) == this.values.get(preferenceId);
    }

    @Override
    public void setToDefault(String preferenceId) {
        this.values.remove(preferenceId);
    }

    @Override
    public boolean getDefaultBoolean(String preferenceId) {
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof Boolean ? (Boolean)defaultValue : false;
    }

    @Override
    public double getDefaultDouble(String preferenceId) {
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof Double ? (Double)defaultValue : 0.0;
    }

    @Override
    public float getDefaultFloat(String preferenceId) {
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof Float ? ((Float)defaultValue).floatValue() : 0.0f;
    }

    @Override
    public int getDefaultInt(String preferenceId) {
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof Integer ? (Integer)defaultValue : 0;
    }

    @Override
    public long getDefaultLong(String preferenceId) {
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof Long ? (Long)defaultValue : 0L;
    }

    @Override
    public String getDefaultString(String preferenceId) {
        Object defaultValue = this.defaults.get(preferenceId);
        return defaultValue instanceof String ? (String)defaultValue : "";
    }

    @Override
    public void setDefault(String preferenceId, boolean value) {
        this.defaults.put(preferenceId, value);
    }

    @Override
    public void setDefault(String preferenceId, double value) {
        this.defaults.put(preferenceId, value);
    }

    @Override
    public void setDefault(String preferenceId, float value) {
        this.defaults.put(preferenceId, Float.valueOf(value));
    }

    @Override
    public void setDefault(String preferenceId, int value) {
        this.defaults.put(preferenceId, value);
    }

    @Override
    public void setDefault(String preferenceId, long value) {
        this.defaults.put(preferenceId, value);
    }

    @Override
    public void setDefault(String preferenceId, String value) {
        this.defaults.put(preferenceId, value);
    }

    @Override
    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
    }

    @Override
    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
    }
}

