/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.internal.macrolayout;

import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.internal.util.KlighdInternalProperties;
import de.cau.cs.kieler.klighd.kgraph.KEdge;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.kgraph.KPort;
import de.cau.cs.kieler.klighd.util.AbstractRunnableWithResult;
import de.cau.cs.kieler.klighd.util.ExpansionAwareLayoutOption;
import de.cau.cs.kieler.klighd.util.RenderingContextData;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyValueProxy;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class KlighdLayoutConfigurationStore
implements ILayoutConfigurationStore {
    private final IWorkbenchPart workbenchPart;
    private final KGraphElement graphElement;
    private static final double ASPECT_RATIO_ROUND = 100.0;

    public KlighdLayoutConfigurationStore(IWorkbenchPart workbenchPart, KGraphElement context) {
        this.workbenchPart = workbenchPart;
        this.graphElement = context;
    }

    public Object getOptionValue(String optionId) {
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(optionId);
        if (optionData == null || this.graphElement == null) {
            return null;
        }
        Object value = this.graphElement.getProperties().get((Object)optionData);
        if (value instanceof IPropertyValueProxy) {
            return ((IPropertyValueProxy)value).resolveValue((IProperty)optionData);
        }
        if (optionData.equals((Object)CoreOptions.PADDING)) {
            return this.getPaddingLayoutOptionValue();
        }
        if (value == null) {
            KNode node;
            ExpansionAwareLayoutOption.ExpansionAwareLayoutOptionData ealo = (ExpansionAwareLayoutOption.ExpansionAwareLayoutOptionData)this.graphElement.getProperty(ExpansionAwareLayoutOption.OPTION);
            if (ealo == null) {
                return this.getSpecialLayoutOptionValue(optionData);
            }
            if (this.graphElement instanceof KNode) {
                node = (KNode)this.graphElement;
            } else if (this.graphElement instanceof KPort) {
                node = ((KPort)this.graphElement).getNode();
            } else {
                return null;
            }
            RenderingContextData rcd = RenderingContextData.get((KGraphElement)node);
            boolean expanded = !node.getChildren().isEmpty() && (Boolean)rcd.getProperty(KlighdInternalProperties.POPULATED) != false;
            return ealo.getValue(optionData, expanded);
        }
        return value;
    }

    private Object getPaddingLayoutOptionValue() {
        if (this.graphElement instanceof KNode) {
            KNode node = (KNode)this.graphElement;
            ElkPadding padding = new ElkPadding((ElkPadding)node.getProperty(CoreOptions.PADDING));
            padding.left += (double)node.getInsets().getLeft();
            padding.right += (double)node.getInsets().getRight();
            padding.top += (double)node.getInsets().getTop();
            padding.bottom += (double)node.getInsets().getBottom();
            return padding;
        }
        return null;
    }

    private Object getSpecialLayoutOptionValue(LayoutOptionData optionData) {
        if (optionData.equals((Object)CoreOptions.ASPECT_RATIO) && (this.getContainer() == null || this.isSingleNodeOnRootLevel())) {
            IViewer viewer = this.getViewer();
            if (viewer == null || viewer.getControl() == null || viewer.getControl().isDisposed()) {
                return null;
            }
            final Control control = viewer.getControl();
            AbstractRunnableWithResult<Double> runnable = new AbstractRunnableWithResult<Double>(){

                @Override
                public void run() {
                    Point size;
                    try {
                        size = control.getSize();
                    }
                    catch (SWTException exception) {
                        return;
                    }
                    if (size.x == 0 || size.y == 0) {
                        return;
                    }
                    this.setResult((double)Math.round(100.0 * (double)size.x / (double)size.y) / 100.0);
                }
            };
            if (control.getDisplay() == Display.getCurrent()) {
                runnable.run();
            } else {
                control.getDisplay().syncExec((Runnable)runnable);
            }
            return runnable.getResult();
        }
        return null;
    }

    public void setOptionValue(String optionId, String valueString) {
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(optionId);
        Object value = optionData.parseValue(valueString);
        if (this.graphElement != null) {
            this.graphElement.setProperty((IProperty)optionData, value);
        }
    }

    private IViewer getViewer() {
        IViewer viewer = (IViewer)this.graphElement.getProperty(KlighdInternalProperties.VIEWER);
        if (viewer == null && this.workbenchPart instanceof IDiagramWorkbenchPart) {
            viewer = ((IDiagramWorkbenchPart)this.workbenchPart).getViewer();
            this.graphElement.setProperty(KlighdInternalProperties.VIEWER, (Object)viewer);
        }
        return viewer;
    }

    public Collection<String> getAffectedOptions() {
        if (this.graphElement == null) {
            return Collections.emptyList();
        }
        LinkedList<String> options = new LinkedList<String>();
        Map allProperties = null;
        while (allProperties == null) {
            try {
                allProperties = this.graphElement.getAllProperties();
            }
            catch (ConcurrentModificationException e) {
                String msg = "Concurrent modification in KGraphPropertyLayoutConfig:" + Klighd.LINE_SEPARATOR + "  element == " + this.graphElement + Klighd.LINE_SEPARATOR + "  sourceElement == " + this.graphElement.getProperty(KlighdInternalProperties.MODEL_ELEMENT);
                Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg));
            }
        }
        Set entrySet = allProperties.entrySet();
        Object node = this.graphElement instanceof KNode ? (KNode)this.graphElement : (this.graphElement instanceof KPort ? ((KPort)this.graphElement).getNode() : null);
        if (node != null) {
            for (Map.Entry entry : entrySet) {
                if (entry == null || entry.getKey() == null || !((IProperty)entry.getKey()).equals(ExpansionAwareLayoutOption.OPTION)) continue;
                ExpansionAwareLayoutOption.ExpansionAwareLayoutOptionData ealo = (ExpansionAwareLayoutOption.ExpansionAwareLayoutOptionData)entry.getValue();
                RenderingContextData rcd = RenderingContextData.get((KGraphElement)node);
                boolean expanded = !node.getChildren().isEmpty() && (Boolean)rcd.getProperty(KlighdInternalProperties.POPULATED) != false;
                Set keySet = ealo.getValues(expanded).getAllProperties().keySet();
                for (IProperty iProperty : keySet) {
                    options.add(iProperty.getId());
                }
            }
        }
        for (Map.Entry entry : entrySet) {
            if (entry == null || entry.getKey() == null || ((IProperty)entry.getKey()).equals(ExpansionAwareLayoutOption.OPTION)) continue;
            options.add(((IProperty)entry.getKey()).getId());
        }
        if (this.getContainer() == null || this.isSingleNodeOnRootLevel()) {
            options.add(CoreOptions.ASPECT_RATIO.getId());
        }
        return options;
    }

    public EditingDomain getEditingDomain() {
        return null;
    }

    public Set<LayoutOptionData.Target> getOptionTargets() {
        if (this.graphElement instanceof KEdge) {
            return EnumSet.of(LayoutOptionData.Target.EDGES);
        }
        if (this.graphElement instanceof KLabel) {
            return EnumSet.of(LayoutOptionData.Target.LABELS);
        }
        if (this.graphElement instanceof KPort) {
            return EnumSet.of(LayoutOptionData.Target.PORTS);
        }
        if (this.graphElement instanceof KNode) {
            if (((KNode)this.graphElement).getChildren().isEmpty()) {
                return EnumSet.of(LayoutOptionData.Target.NODES);
            }
            return EnumSet.of(LayoutOptionData.Target.NODES, LayoutOptionData.Target.PARENTS);
        }
        return EnumSet.noneOf(LayoutOptionData.Target.class);
    }

    public ILayoutConfigurationStore getParent() {
        KNode container = this.getContainer();
        if (container != null) {
            return new KlighdLayoutConfigurationStore(this.workbenchPart, (KGraphElement)container);
        }
        return null;
    }

    private KNode getContainer() {
        if (this.graphElement instanceof KNode) {
            return ((KNode)this.graphElement).getParent();
        }
        if (this.graphElement instanceof KEdge) {
            return ((KEdge)this.graphElement).getSource().getParent();
        }
        if (this.graphElement instanceof KPort) {
            return ((KPort)this.graphElement).getNode().getParent();
        }
        if (this.graphElement instanceof KLabel) {
            KLabeledGraphElement labeledGraphElement = ((KLabel)this.graphElement).getParent();
            if (labeledGraphElement instanceof KNode) {
                return ((KNode)labeledGraphElement).getParent();
            }
            if (labeledGraphElement instanceof KEdge) {
                return ((KEdge)labeledGraphElement).getSource().getParent();
            }
            if (labeledGraphElement instanceof KPort) {
                return ((KPort)labeledGraphElement).getNode().getParent();
            }
        }
        return null;
    }

    private boolean isSingleNodeOnRootLevel() {
        if (this.graphElement instanceof KNode) {
            KNode node = (KNode)this.graphElement;
            return node.getParent() != null && node.getParent().getParent() == null && node.getParent().getChildren().size() == 1;
        }
        return false;
    }

    public static final class Provider
    implements ILayoutConfigurationStore.Provider {
        public ILayoutConfigurationStore get(IWorkbenchPart workbenchPart, Object context) {
            if (context instanceof KGraphElement) {
                try {
                    return new KlighdLayoutConfigurationStore(workbenchPart, (KGraphElement)context);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

