/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.internal.macrolayout;

import de.cau.cs.kieler.klighd.krendering.KPolygon;
import de.cau.cs.kieler.klighd.krendering.KPosition;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingUtil;
import de.cau.cs.kieler.klighd.krendering.KRoundedRectangle;
import de.cau.cs.kieler.klighd.microlayout.Bounds;
import de.cau.cs.kieler.klighd.microlayout.PlacementUtil;
import java.util.Iterator;
import java.util.List;
import org.eclipse.elk.core.math.KVector;

public final class AnchorUtil {
    private static final double FA = 0.1;

    private AnchorUtil() {
    }

    public static KVector nearestBorderPoint(KVector point, double width, double height, KRendering rendering, double scale) {
        if (width < 0.0 || height < 0.0) {
            throw new IllegalArgumentException("width (" + width + ") and height (" + height + ") must be >= 0.");
        }
        KRendering actualRendering = KRenderingUtil.dereference((KRendering)rendering);
        if (actualRendering != null) {
            switch (actualRendering.eClass().getClassifierID()) {
                case 4: {
                    KRoundedRectangle roundedRectangle = (KRoundedRectangle)actualRendering;
                    double cornerWidth = (double)roundedRectangle.getCornerWidth() * scale;
                    cornerWidth = 2.0 * cornerWidth <= width ? cornerWidth : width / 2.0;
                    double cornerHeight = (double)roundedRectangle.getCornerHeight() * scale;
                    cornerHeight = 2.0 * cornerHeight <= height ? cornerHeight : height / 2.0;
                    return AnchorUtil.nearestBorderPointRoundedRectangle(point, width, height, cornerWidth, cornerHeight);
                }
                case 2: {
                    return AnchorUtil.collideTowardsEllipseCenter(point, width, height);
                }
            }
        }
        return AnchorUtil.nearestBorderPointRectangle(point, width, height);
    }

    private static KVector nearestBorderPointRectangle(KVector point, double width, double height) {
        KVector result = new KVector(point);
        if (point.x < 0.0) {
            result.x = 0.0;
        } else if (point.x > width) {
            result.x = width;
        }
        if (point.y < 0.0) {
            result.y = 0.0;
        } else if (point.y > height) {
            result.y = height;
        }
        return result;
    }

    private static KVector nearestBorderPointRoundedRectangle(KVector point, double width, double height, double cornerWidth, double cornerHeight) {
        assert (width >= 0.0) : "width = " + width;
        assert (height >= 0.0) : "height = " + height;
        double rectWidthWithoutCornerWidth = width - cornerWidth;
        double rectWidthWithoutTwiceCornerWidth = rectWidthWithoutCornerWidth - cornerWidth;
        double rectHeightWidthoutCornerHeight = height - cornerHeight;
        double rectHeightWithoutTwiceCornerHeight = rectHeightWidthoutCornerHeight - cornerHeight;
        KVector result = new KVector(point);
        if (point.x <= 0.0) {
            if (point.y <= cornerHeight) {
                result = AnchorUtil.collideTowardsEllipseCenter(result, 2.0 * cornerWidth, 2.0 * cornerHeight);
            } else if (point.y >= rectHeightWidthoutCornerHeight) {
                result.y -= rectHeightWithoutTwiceCornerHeight;
                result = AnchorUtil.collideTowardsEllipseCenter(result, 2.0 * cornerWidth, 2.0 * cornerHeight);
                result.y += rectHeightWithoutTwiceCornerHeight;
            } else {
                result.x = 0.0;
            }
        }
        if (point.x >= width) {
            if (point.y <= cornerHeight) {
                result.x -= rectWidthWithoutTwiceCornerWidth;
                result = AnchorUtil.collideTowardsEllipseCenter(result, 2.0 * cornerWidth, 2.0 * cornerHeight);
                result.x += rectWidthWithoutTwiceCornerWidth;
            } else if (point.y >= rectHeightWidthoutCornerHeight) {
                result.x -= rectWidthWithoutTwiceCornerWidth;
                result.y -= rectHeightWithoutTwiceCornerHeight;
                result = AnchorUtil.collideTowardsEllipseCenter(result, 2.0 * cornerWidth, 2.0 * cornerHeight);
                result.x += rectWidthWithoutTwiceCornerWidth;
                result.y += rectHeightWithoutTwiceCornerHeight;
            } else {
                result.x = width;
            }
        }
        if (point.y <= 0.0) {
            if (point.x <= cornerWidth) {
                result = AnchorUtil.collideTowardsEllipseCenter(result, 2.0 * cornerWidth, 2.0 * cornerHeight);
            } else if (point.x >= rectWidthWithoutCornerWidth) {
                result.x -= rectWidthWithoutTwiceCornerWidth;
                result = AnchorUtil.collideTowardsEllipseCenter(result, 2.0 * cornerWidth, 2.0 * cornerHeight);
                result.x += rectWidthWithoutTwiceCornerWidth;
            } else {
                result.y = 0.0;
            }
        }
        if (point.y >= height) {
            if (point.x <= cornerWidth) {
                result.y -= rectHeightWithoutTwiceCornerHeight;
                result = AnchorUtil.collideTowardsEllipseCenter(result, 2.0 * cornerWidth, 2.0 * cornerHeight);
                result.y += rectHeightWithoutTwiceCornerHeight;
            } else if (point.x >= rectWidthWithoutCornerWidth) {
                result.x -= rectWidthWithoutTwiceCornerWidth;
                result.y -= rectHeightWithoutTwiceCornerHeight;
                result = AnchorUtil.collideTowardsEllipseCenter(result, 2.0 * cornerWidth, 2.0 * cornerHeight);
                result.x += rectWidthWithoutTwiceCornerWidth;
                result.y += rectHeightWithoutTwiceCornerHeight;
            } else {
                result.y = height;
            }
        }
        return result;
    }

    public static KVector collideTowardsCenter(KVector point, double width, double height, KRendering rendering) {
        if (width < 0.0 || height < 0.0) {
            throw new IllegalArgumentException("width (" + width + ") and height (" + height + ") must be >= 0.");
        }
        if (rendering != null) {
            switch (rendering.eClass().getClassifierID()) {
                case 2: {
                    return AnchorUtil.collideTowardsEllipseCenter(point, width, height);
                }
                case 6: {
                    KPolygon polygon = (KPolygon)rendering;
                    return AnchorUtil.collideTowardsPolygonCenter(point, width, height, (List<KPosition>)polygon.getPoints());
                }
            }
            return AnchorUtil.collideTowardsRectangleCenter(point, width, height);
        }
        return AnchorUtil.collideTowardsRectangleCenter(point, width, height);
    }

    private static KVector collideTowardsRectangleCenter(KVector point, double width, double height) {
        assert (width >= 0.0) : "width = " + width;
        assert (height >= 0.0) : "height = " + height;
        KVector center = new KVector(width / 2.0, height / 2.0);
        if (point.y < 0.0 || point.y > height || point.x < 0.0 || point.x > width) {
            KVector result = AnchorUtil.intersectLines(0.0, 0.0, width, 0.0, point.x, point.y, center.x, center.y);
            if (result != null) {
                return result;
            }
            result = AnchorUtil.intersectLines(0.0, height, width, height, point.x, point.y, center.x, center.y);
            if (result != null) {
                return result;
            }
            result = AnchorUtil.intersectLines(0.0, 0.0, 0.0, height, point.x, point.y, center.x, center.y);
            if (result != null) {
                return result;
            }
            result = AnchorUtil.intersectLines(width, 0.0, width, height, point.x, point.y, center.x, center.y);
            if (result != null) {
                return result;
            }
        }
        return new KVector(center);
    }

    private static KVector collideTowardsEllipseCenter(KVector point, double width, double height) {
        assert (width >= 0.0) : "width = " + width;
        assert (height >= 0.0) : "height = " + height;
        double a = width * 0.5;
        double b = height * 0.5;
        KVector offsetPoint = new KVector(point.x - a, point.y - b);
        double determinant = offsetPoint.x * offsetPoint.x / (a * a) + offsetPoint.y * offsetPoint.y / (b * b);
        if (determinant == 0.0) {
            return new KVector(point);
        }
        double t0 = 1.0 / Math.sqrt(determinant);
        return new KVector(offsetPoint.x * t0 + a, offsetPoint.y * t0 + b);
    }

    private static KVector collideTowardsPolygonCenter(KVector point, double width, double height, List<KPosition> polygonPoints) {
        KVector intersection;
        assert (width >= 0.0) : "width = " + width;
        assert (height >= 0.0) : "height = " + height;
        Bounds figureBounds = new Bounds(width, height);
        if (polygonPoints.size() < 3) {
            return new KVector(point);
        }
        KVector result = new KVector(width / 2.0, height / 2.0);
        Iterator<KPosition> polygonPointsIterator = polygonPoints.iterator();
        KVector firstPoint = PlacementUtil.evaluateKPosition(polygonPointsIterator.next(), figureBounds, true).toKVector();
        KVector segmentStart = null;
        KVector segmentEnd = firstPoint;
        while (polygonPointsIterator.hasNext()) {
            segmentStart = segmentEnd;
            segmentEnd = PlacementUtil.evaluateKPosition(polygonPointsIterator.next(), figureBounds, true).toKVector();
            intersection = AnchorUtil.intersectLines(segmentStart.x, segmentStart.y, segmentEnd.x, segmentEnd.y, point.x, point.y, result.x, result.y);
            if (intersection == null) continue;
            result = intersection;
        }
        intersection = AnchorUtil.intersectLines(firstPoint.x, firstPoint.y, segmentEnd.x, segmentEnd.y, point.x, point.y, result.x, result.y);
        if (intersection != null) {
            result = intersection;
        }
        return result;
    }

    private static KVector intersectLines(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double divisor = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (divisor == 0.0) {
            return null;
        }
        double x1y2minusy1x2 = x1 * y2 - y1 * x2;
        double x3y4minusy3x4 = x3 * y4 - y3 * x4;
        KVector res = new KVector((x1y2minusy1x2 * (x3 - x4) - (x1 - x2) * x3y4minusy3x4) / divisor, (x1y2minusy1x2 * (y3 - y4) - (y1 - y2) * x3y4minusy3x4) / divisor);
        if ((x1 - 0.1 <= res.x && res.x <= x2 + 0.1 || x1 + 0.1 >= res.x && res.x >= x2 - 0.1) && (x3 - 0.1 <= res.x && res.x <= x4 + 0.1 || x3 + 0.1 >= res.x && res.x >= x4 - 0.1) && (y1 - 0.1 <= res.y && res.y <= y2 + 0.1 || y1 + 0.1 >= res.y && res.y >= y2 - 0.1) && (y3 - 0.1 <= res.y && res.y <= y4 + 0.1 || y3 + 0.1 >= res.y && res.y >= y4 - 0.1)) {
            return res;
        }
        return null;
    }
}

